Ext.namespace('Cascade.panel.lager');
/**
 * @class Cascade.panel.lager.auswahl_standard
 * <li>category   Client Lager
 * <li>package    Cascade.panel.lager
 * <li>copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * @version 1.0 - 2011 - new - 
 */
Cascade.panel.lager.auswahl_standard = function()
{
	var form,_gridTable,idx,posXY,nXPos,nYPos,strHtmlTable;
	var bBlock = false;
	
	//Tooltip function for Special dimensions
	var _getTooltip = function(bDisable){
		if(bDisable)
			return ('<img src="EasyKatImages/icons/plugin_disabled.png" id="HTML_DIS_SPECIAL_DIMENSION"  style="cursor:pointer;margin-top: -2px; margin-left:-20px;"  onclick="Cascade.panel.lager.auswahl_standard.onMouseClickInfo(this);" onmouseover="Cascade.panel.lager.auswahl_standard.onMouseOverInfo(this);" onmouseout="Cascade.panel.lager.auswahl_standard.onMouseOutInfo(this);"/>'+' '+'$LAGER_SONDERABMESSUNGEN_LABEL$');
		else	
			return ('<img src="EasyKatImages/icons/plugin_edit.png" id="HTML_EN_SPECIAL_DIMENSION"  style="cursor:pointer;margin-top: -2px;margin-left:-20px;"  onclick="Cascade.panel.lager.auswahl_standard.onMouseClickInfo(this);" onmouseover="Cascade.panel.lager.auswahl_standard.onMouseOverInfo(this);" onmouseout="Cascade.panel.lager.auswahl_standard.onMouseOutInfo(this);"/>'+' '+'$LAGER_SONDERABMESSUNGEN_LABEL$');
	}
	
	var storeGefuehrtMehrfach = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeTraegerArt = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeTraegerGroesse = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeGleitelement = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeOberflaeche  = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeACCESSORY =  new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeTable = new Ext.data.SimpleStore({
		fields : [
			{ name: 'id'		}, 
			{ name: 'typ' 		},
			{ name: 'nennweite' },
			{ name: 'nennhoehe' },
			{ name: 'emass' 	},
			{ name: 'max_daemmdicke' },
			{ name: 'auflagelast_minus_fz' },
			{ name: 'axiallast_fy' },
			{ name: 'querlast_fx' },
			{ name: 'abhebelast_fz' },
			{ name: 'gewicht' },
			{ name: 'preis' }
		] 
	} );
	
	var _deleteTableStore = function(){
		Ext.getCmp('lager.auswahl_standard_tabelle').getStore().loadData([]);
		if(Ext.getCmp('move-next').hidden == false)
			_setTableSelEvent('','-');		
	}
	
	var _onActionComplete = function(strform, action){ //Wenn bentigt erweitern
		Cascade.app.getNextPanel(form,action); //Next Dialog		
	}
	
	var _setRadioEvent = function(oClicked, bChecked){
		if(!bBlock && bChecked){
			_deleteTableStore();
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-standard/setRadio',
				params  : {
					'radiogroup' : oClicked.name,
					'radiovalue' : oClicked.inputValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_standard_setGuiValue(message);
				}
			});	
		}
	}
	
	var _setCheckBoxEvent = function(strCheckboxId,strValue){
		if(!bBlock){
			_deleteTableStore();
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-standard/setCheckBox',
				params  : {
					'checkboxid'	: strCheckboxId,
					'checkboxvalue' : strValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_standard_setGuiValue(message);
				}
			});	
		}
	}
	
	var _setComboBoxEvent = function(combo, record, idx){
		if(!bBlock){
			_deleteTableStore();
			var strComboBoxId 		= combo.id;
			var strSelectionValueId	= combo.getValue();
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-standard/setComboBox',
				params  : {
					'comboboxid'	: strComboBoxId,
					'comboboxvalue' : strSelectionValueId
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_standard_setGuiValue(message);
				}
			});	
		}
	}
	
	var _setNumberfieldEvent = function(field, newValue, oldValue){
		if(!bBlock){
			_deleteTableStore();
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-standard/setNumberfield',
				params  : {
					'numberfieldid'			: field.id,
					'numberfieldvalue' 		: newValue,
					'numberfieldvalueold' 	: oldValue
				},
				success : function(response, options) {
					bBlock = true;
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message[0])
						Ext.getCmp(message[0]).setValue(message[1]);
					
					bBlock = false;	
				}
			});	
		}
	};
	
	var _setButtonEvent = function(){
		if(!bBlock){
			_deleteTableStore();
			Ext.Ajax.request({   
			    url		: 'lager.auswahl-standard/getButton',
				success	: function( response, options){
					var message	= Ext.util.JSON.decode(response.responseText);
					Cascade.panel.lager.auswahl_standard_setGuiValue(message);
				}
			});	
		}
	}
	
	var _setTableSelEvent = function(rowIndex,rowId){
		if(!bBlock){
			Ext.Ajax.request({   
			    url		: 'lager.auswahl-standard/setTableSel',
			    params  : {
					'selection'	: rowIndex,
					'rowId'		: rowId
				},
				success	: function( response, options){
					if(rowId == '-'){
						Ext.getCmp('move-next').hide();
						//Ext.getCmp( 'topology-panel' ).body.update( '<center><img src="EasyKatImages/LK/prodeinzel/FLEXPERTE_0.png" /></center>' );
						Ext.getCmp( 'topology-panel' ).body.update( '<center><img src="" /></center>' );
					}
					else{
						Ext.getCmp('move-next').show();
						
						if(Ext.getCmp('move-next').disabled)
							Ext.getCmp('move-next').enable();
						
					var message	= Ext.util.JSON.decode(response.responseText);
					//Ext.getCmp( 'topology-panel' ).body.update( '<center><img src="EasyKatImages/WITgifs/RH/'+message.image+'.jpg" /></center>' );
					Ext.getCmp( 'LAGER_PIC_PREVIEW' ).body.update( '<center><img src="EasyKatImages/WITgifs/RH/'+message.image+'.jpg" /></center>' );
					}	
				},
				failure: function (result, request){
				}
			});
			var HALT;
		}
	}
	
	return {
		setSearchButton	: function(){
			_setButtonEvent();
		},
		setHTML_Table_SpecialDimension: function(strHtml){
			strHtmlTable =	strHtml;		
		},
		updateFieldSetTitle: function(strId,strTitle){
			if(strId=="LAGER_SONDERABMESSUNGEN"){
				bBlock = true;
				var bDis = (strTitle == 'true' || strTitle == true) ? true : false;
				Ext.getCmp(strId).setTitle(_getTooltip(bDis),true);
				
				/*
				if(bDis){
					Ext.getCmp("LAGER_SONDERABMESSUNGEN").disable();
					_setCheckBoxEvent("	LAGER_SONDERABMESSUNGEN",false);
				}
				else
					Ext.getCmp("LAGER_SONDERABMESSUNGEN").enable();	
				*/
				bBlock = false;
			}
		},
		onMouseClickInfo : function(oHtml,dVersion){
			 if(!dVersion)
            	dVersion = 1;
            	
            switch(oHtml.id){
                case "HTML_DIS_SPECIAL_DIMENSION" :
                    break;
                case "HTML_EN_SPECIAL_DIMENSION":
                		var aGetFieldSetPosition = Ext.getCmp("LAGER_SONDERABMESSUNGEN").el.getAnchorXY();
                		if(!Ext.getCmp("LAGER_SONDERABMESSUNGEN").collapsed)
                			Cascade.panel.lager.auswahl_standard_sonder.init([(aGetFieldSetPosition[0]-150),(aGetFieldSetPosition[1]+30)]);
                		else{
                			 Ext.MessageBox.show({
						       title	: '$IDC_INFO$',
						       msg		: '$INFO_CHECKBOX_NICHT_AKTIV$',
						       maxWidth : 800,
						       minWidth : 400,
						       buttons	: Ext.MessageBox.OK,
						       icon	: 'ext-mb-info'
    						});	
                		}                			
                	break;    
            }
		},
		onMouseOverInfo: function(oHtml,dVersion){
            if(!dVersion)
            	dVersion = 1;
            	
            switch(oHtml.id){
                case "HTML_DIS_SPECIAL_DIMENSION" :
                        posXY = Ext.getCmp("LAGER_SONDERABMESSUNGEN").el.getAnchorXY();
                        nXPos = posXY[0]+20;
                        nYPos = posXY[1]+35;
                        Cascade.base.Tooltip.onMouseOverSelectionInfo("LAGER_SONDERABMESSUNGEN","$INFO_SONDERABMESSUNG_DIS_LABEL$",dVersion,nXPos,nYPos);
                    break;
                case "HTML_EN_SPECIAL_DIMENSION":
                		posXY = Ext.getCmp("LAGER_SONDERABMESSUNGEN").el.getAnchorXY();
                        nXPos = posXY[0]+20;
                        nYPos = posXY[1]+25;
                        Cascade.base.Tooltip.onMouseOverSelectionInfo("LAGER_SONDERABMESSUNGEN","$INFO_SONDERABMESSUNG_EN_LABEL$<br>"+strHtmlTable,dVersion,nXPos,nYPos);
                	break;    
            }
		},
		onMouseOutInfo: function(oHtml){
            switch(oHtml.id){
                case "HTML_DIS_SPECIAL_DIMENSION" :
                        Cascade.base.Tooltip.onMouseOutSelectionInfo("LAGER_SONDERABMESSUNGEN");
                    break;
                 case "HTML_EN_SPECIAL_DIMENSION":	
                 		Cascade.base.Tooltip.onMouseOutSelectionInfo("LAGER_SONDERABMESSUNGEN");
                 	break;
            }    	    
		},
		setResetName : function(){
			bBlock = true;
			var oAdd = { 
				id		: form.getId(), 
				idx		: idx, 
				title	: form.title 
			};
			Cascade.app.setRemoveEntryFromHistory();
			Cascade.app.setAddEntryToHistory(oAdd);
			bBlock = false;
		},
		setBlockEvent : function(bBlockEvent){
			bBlock = bBlockEvent;
		},
		getStore : function(){
			return ({
				'storeGefuehrtMehrfach' : storeGefuehrtMehrfach,
				'storeTraegerArt'		: storeTraegerArt,
				'storeTraegerGroesse'	: storeTraegerGroesse,
				'storeTable'			: storeTable,
				'storeGleitelement'		: storeGleitelement,
				'storeOberflaeche'		: storeOberflaeche,
				'storeACCESSORY'		: storeACCESSORY
			});			
		},
		init: function(idx){
			this.idx = idx;
			bBlock = true;
			if (!form) {				
				// erzeuge Tabelle fr Suchresultate Lager
				_gridTable = new Ext.grid.GridPanel(
				{
					id		: 'lager.auswahl_standard_tabelle',
					style 	: 'padding-top: 5px',
					store 	: storeTable,
					columns	: [{ 	
						// Typ
						header: '$TCH_TYP$', 
						width: 150, 
						sortable: true, 
						dataIndex: 'typ'
					},{ 	
						// Nennweite
						header: '$TCH_RH_NENNWEITE$',
						width: 45,
						sortable: true,
						dataIndex: 'nennweite'
					},{ 	
						// Nennhhe
						header: '$TCH_NENNHOEHE$',
						width: 45, 
						sortable: true,
						dataIndex: 'nennhoehe'
					},{ 	
						// E-Mass
						header: '$TCH_EMASS$',
						width: 60, 
						sortable: true,
						dataIndex: 'emass'
					},{ 
						// maximale Dmmdicke J
						header: '$TCH_MAXDAEMMDICKE$', 
						width: 60, 
						sortable: true,
						dataIndex: 'max_daemmdicke'
					},{ 
						// Auflagelast -Fz
						header: '$TCH_AUFLAGELAST$', 
						width: 60, 
						sortable: true,
						dataIndex: 'auflagelast_minus_fz' 
					},{ 
						// Axiallast Fy
						header: '$TCH_AXIALLAST$', 
						width: 60, 
						sortable: true,
						dataIndex: 'axiallast_fy' 
					},{ 
						// Querlast Fx
						header: '$TCH_QUERLAST$', 
						width: 60, 
						sortable: true,
						dataIndex: 'querlast_fx' 
					},{ 
						// Abhebelast Fz
						header: '$TCH_ABHEBELAST$', 
						width: 60, 
						sortable: true,
						dataIndex: 'abhebelast_fz' 
					},{ 
						// Gewicht
						header: '$TCH_GEWICHT$', 
						width: 55, 
						sortable: true,
						dataIndex: 'gewicht' 
					},{ 
						// Preis
						header: 'W_V_S_V', 
						width: 45, 
						sortable: true,
						dataIndex: 'preis' 
					}],
					sm: new Ext.grid.RowSelectionModel( { singleSelect: true} ),
										
					width			: 720,
					//autoWidth: true,
					height			: 140,
					frame			: false,
					border			: false,
					title			: '',
					header			: false,
					listeners	: {	
						'headerclick' : function(grid,colIndex,e){
						},
						'cellclick' : function(grid, rowIndex, colIndex, e ) {
							_setTableSelEvent(rowIndex,storeTable.getAt(rowIndex).data.id)
						}
					}					
				});
				
				form = new Ext.FormPanel({
					frame		: true,
					id			: 'lager.auswahl_standard',
					title		: 'WIRD_VOM_SERVER_VORGEGEBEN',
					bodyStyle	: 'padding-left: 5px',
					listeners: {
						'actioncomplete': _onActionComplete
					},
					items: [{
						layout		:'column',
						border		: false,
						labelStyle	: 'font-size:11px',
						items : [{						
							xtype		: 'fieldset',
							title		: '$LAGER_FUNCTION_LABEL$',
							id			: 'LAGER_FUNCTION',
							style		: 'padding-left: 5px',
							//width		: 350,
							width		: 270,
							height		: 165,				
							items		: [{
								layout		: 'form',
								hideLabels	: true,
								defaultType	: 'radio',
								items: [{
	                                id			: 'LAGER_FUNCTION_LOSE',
									inputValue	: 'LOSE',
									boxLabel	: '$LAGER_LOSE$',
									name		: 'LAGER_FUNCTION',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
	                                id			: 'LAGER_FUNCTION_GEFUEHRT',
									inputValue	: 'GEFUEHRT',
									boxLabel	: '$LAGER_GEFUEHRT$',
									name		: 'LAGER_FUNCTION',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
	                                id			: 'LAGER_FUNCTION_GEFUEHRT_MEHRFACH',
									inputValue	: 'GEFUEHRT_MEHRFACH',
									boxLabel	: '$LAGER_GEFUEHRT_MEHRFACH$',
									name		: 'LAGER_FUNCTION',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								}]							
							},{
								layout		: 'form',
								border		: false,
								hideLabels	: true,
								style		: 'padding-left: 15px',
								items 		: [{
									//COMBO
									xtype			: 'combo',
									id				: 'LAGER_GEFUEHRT_MEHRFACH',
									fieldLabel		: '',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		: 'LAGER_GEFUEHRT_MEHRFACH_NAME',
									store			: storeGefuehrtMehrfach,
									listWidth		: 200,
									width			: 200,
									listeners		: {
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'text',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									editable		: false
								}]
							}]
						},{
							xtype		: 'fieldset',
							title		: '$LAGER_MERKMALE_LABEL$',
							id			: 'LAGER_MERKMALE',
							//width		: 350,
							width		: 270,
							style		: 'margin-left: 5px ; padding: 5px',
							height		: 145,
							//height		: 150,	// fr Schelle 45
							items		: [{
								layout	: 'form',
								border  : false,
								id		: 'LAGE_MERKMALE_HOEHENVERSTELLBAR_FORM',
								items	: [{
									xtype			: 'checkbox',
									id				: 'LAGE_MERKMALE_HOEHENVERSTELLBAR',
									hiddenName		: 'LAGE_MERKMALE_HOEHENVERSTELLBAR',
									boxLabel		: '$IDC_HOEHENVERSTELLBAR_LABEL$',
									valueField		: 'id',
									displayField	: 'LAGE_MERKMALE_HOEHENVERSTELLBAR',
									mode			: 'local',
									triggerAction	: 'all'	,
									hideLabel		: true,
									listeners		: {
										render : function(a,value,c) {
											this.on({
			                                    check : function(a,value,c) {
			                                        _setCheckBoxEvent(this.id,value);
			                                    }
			                                });
										}
									}
								}]
							},{
								layout	: 'form',
								border  : false,
								id		: 'LAGE_MERKMALE_GAT_FORM',
								items	: [{
									xtype			: 'checkbox',
									id				: 'LAGE_MERKMALE_GAT',
									hiddenName		: 'LAGE_MERKMALE_GAT',
									boxLabel		: '$IDC_GLEITUNTERLAGE_LABEL$',
									valueField		: 'id',
									displayField	: 'LAGE_MERKMALE_GAT',
									mode			: 'local',
									triggerAction	: 'all'	,
									hideLabel		: true,
									listeners		: {
										render : function(a,value,c) {
											this.on({
			                                    check : function(a,value,c) {
			                                        _setCheckBoxEvent(this.id,value);
			                                    }
			                                });
										}
									}
								}]
							},{
								layout	: 'form',
								border  : false,
								id		: 'LAGE_MERKMALE_BUEGEL_FORM',
								items	: [{
									xtype			: 'checkbox',
									id				: 'LAGE_MERKMALE_BUEGEL',
									hiddenName		: 'LAGE_MERKMALE_BUEGEL',
									boxLabel		: '$IDC_BUEGELAUSFUEHRUNG_LABEL$',
									valueField		: 'id',
									displayField	: 'LAGE_MERKMALE_BUEGEL',
									mode			: 'local',
									triggerAction	: 'all'	,
									hideLabel		: true,
									listeners		: {
										render : function(a,value,c) {
											this.on({
			                                    check : function(a,value,c) {
			                                        _setCheckBoxEvent(this.id,value);
			                                    }
			                                });
										}
									}
								}]							
							}/*,{	// Schelle 45
								layout	: 'form',
								border  : false,
								id		: 'LAGE_MERKMALE_SCHELLE_WINKEL_FORM',
								items	: [{
									xtype			: 'checkbox',
									id				: 'LAGE_MERKMALE_SCHELLE_WINKEL',
									hiddenName		: 'LAGE_MERKMALE_SCHELLE_WINKEL',
									//boxLabel		: '$IDC_BUEGELAUSFUEHRUNG_LABEL$',
									boxLabel		: 'SCHELLE 45',
									valueField		: 'id',
									displayField	: 'LAGE_MERKMALE_SCHELLE_WINKEL',
									mode			: 'local',
									triggerAction	: 'all'	,
									hideLabel		: true,
									listeners		: {
										render : function(a,value,c) {
											this.on({
			                                    check : function(a,value,c) {
			                                        _setCheckBoxEvent(this.id,value);
			                                    }
			                                });
										}
									}
								}]							
							}*/,{ //ComboBox
								layout 		: 'form',
								border 		: false,
								labelWidth	: 95,
								id			: "LAGER_MERKMALE_ACCESSORY_FORM", 
								items		: [{
									xtype			: 'combo',
									id				: 'LAGER_MERKMALE_ACCESSORY',
									fieldLabel		: '$IDC_ANSCHLUSSTEILE_LABEL$',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		:'LAGER_LAGERSYSTEM_ACCESSORY_NAME',
									store			: storeACCESSORY,
									listWidth		: 140,
									listeners		: {
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'text',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									width			: 110,
									editable		: false
								}]
							},{ //ComboBox
								layout 		: 'form',
								border 		: false,
								labelWidth	: 95,
								id			: "LAGER_MERKMALE_GLEITELEMENT_FORM",
								items		: [{
									xtype			: 'combo',
									id				: 'LAGER_MERKMALE_GLEITELEMENT',
									fieldLabel		: '$GLEITELEMENT$',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		:'LAGER_LAGERSYSTEM_GLEITELEMENT_NAME',
									store			: storeGleitelement,
									listWidth		: 140,
									listeners		: {
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'text',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									width			: 110,
									editable		: false
								}]
							},{
								layout 		: 'form',
								border 		: false,
								labelWidth	: 95,
								id			: "LAGER_MERKMALE_OBERFLAECHE_FROM",
								items		: [{
									xtype			: 'combo',
									id				: 'LAGER_MERKMALE_OBERFLAECHE',
									fieldLabel		: '$OBERFLAECHENSCHUTZ$',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		:'LAGER_LAGERSYSTEM_OBERFLAECHE_NAME',
									store			: storeOberflaeche,
									listWidth		: 140,
									listeners		: {
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'text',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									width			: 110,
									editable		: false
								}]
							}]
						},{
							xtype		: 'fieldset',
							title		: '$LAGER_BEFESTIGUNG_BAUWERK_LABEL$',
							id			: 'LAGER_BEFESTIGUNG_BAUWERK',
							//width		: 150,
							width		: 120,
							style		: 'margin-left: 5px ; padding: 5px',
							height		: 145,					
							items		: [{
								layout		: 'form',
								hideLabels	: true,
								items		: [{
									xtype		: 'radio',
									id			: 'LAGER_BEFESTIGUNG_BAUWERK_KLEMMBAR',
									inputValue	: 'KLEMMBAR',
									boxLabel	: '$IDC_KLEMMBAR_LABEL$',
									name		: 'LAGER_BB',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								}]
							},{//fieldset wird verschoben --> id 'LAGER_BEFESTIGUNG_BAUWERK_SCHRAUBBAR' als label
								layout		: 'form',
								style		: 'padding-left: 5px',
								border		: false,
								items		: [{
									xtype		: 'fieldset',
									title		: '$IDC_SCHRAUBBAR_LABEL$',
									id			: 'LAGER_BEFESTIGUNG_BAUWERK_SCHRAUBBAR_FIELDSET',
									autoWidth	: true,
									autoHeight	: true,								
									items		: [{	
										layout		: 'form',
										hideLabels	: true,
										defaultType	: 'radio',
										items		: [{
											id			: 'LAGER_BEFESTIGUNG_BAUWERK_SCHRAUBBAR_EINFACH',
											inputValue	: 'EINFACH',
											boxLabel	: '$IDC_EINFACH_LABEL$',
											name		: 'LAGER_BB_SCHRAUBBAR',
											listeners	: {
				                                'check': _setRadioEvent
				                            }
										},{
											id			: 'LAGER_BEFESTIGUNG_BAUWERK_SCHRAUBBAR_DOPPELT',
											inputValue	: 'DOPPELT',
											boxLabel	: '$IDC_DOPPELT_LABEL$',
											name		: 'LAGER_BB_SCHRAUBBAR',
											listeners	: {
				                                'check': _setRadioEvent
				                            }
										}]
									}]
								}]
							},{
								layout		: 'form',
								style		: 'margin-top: -88px',
								hideLabels	: true,
								height		: 25,
								items		: [{
									xtype		: 'radio',
									id			: 'LAGER_BEFESTIGUNG_BAUWERK_SCHRAUBBAR',
									inputValue	: 'SCHRAUBBAR',
									name		: 'LAGER_BB',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								}]								
							}]
						},{
							xtype		: 'fieldset',
							title		: '$LAGER_TRAEGER_LABEL$',
							id			: 'LAGER_TRAEGER',
							width		: 230,
							style		: 'margin-left: 5px ; padding: 5px',
							height		: 145,					
							items		: [{
								layout 		: 'form',
								border 		: false,
								labelWidth	: 95,
								items		: [{
									xtype			: 'combo',
									id				: 'LAGER_TRAEGER_ART',
									fieldLabel		: '$IDC_PROFILART_RH_LABEL$',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		:'LAGER_TRAEGER_ART_NAME',
									store			: storeTraegerArt,
									listWidth		: 140,
									listeners		: {
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'text',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									width			: 80,
									editable		: false
								}]
							},{
								layout 		: 'form',
								border 		: false,
								labelWidth	: 95,
								items		: [{
									xtype			: 'combo',
									id				: 'LAGER_TRAEGER_GROESSE',
									fieldLabel		: '$IDC_TRAEGERGROESSE_LABEL$',
									labelSeparator	: '',
									labelAlign		: 'left',
									hiddenName		:'LAGER_TRAEGER_GROESSE_NAME',
									store			: storeTraegerGroesse,
									listWidth		: 140,
									listeners		: {
										'select': _setComboBoxEvent
									},
									valueField		: 'id',
									displayField	: 'text',
									typeAhead		: true,
									mode			: 'local',
									triggerAction	: 'all',
									selectOnFocus	: true,
									width			: 80,
									editable		: false
								}]
							},{
								layout 	: 'table',
								border	: false,
								width	: 220,
								items	: [{
									layout 		: 'form',
									border 		: false,
									width		: 190,
									labelWidth	: 95,
									items		: [{
										xtype			: 'numberfield',
										fieldLabel		: '$IDC_TRAEGERHOEHE_LABEL$',
										id				: 'LAGER_TRAEGER_HOEHE',
										labelSeparator	: '&nbsp;',
										width			: 80,
										listeners: {
											'change': _setNumberfieldEvent
										}
									}]
								},{
									xtype		: 'textfield',
									value		: 'mm',
									hideLabels	: true,
									readOnly	: true,
									width		: 30,
									cls			: 'textfield-transparent'
								}]
							},{
								layout 	: 'table',
								border	: false,
								width	: 220,
								items	: [{
									layout 		: 'form',
									border 		: false,
									width		: 190,
									labelWidth	: 95,
									items		: [{
										xtype			: 'numberfield',
										fieldLabel		: '$IDC_TRAEGERBREITE_LABEL$',
										id				: 'LAGER_TRAEGER_BREITE',
										labelSeparator	: '&nbsp;',
										width			: 80,
										listeners: {
											'change': _setNumberfieldEvent
										}
									}]
								},{
									xtype		: 'textfield',
									value		: 'mm',
									hideLabels	: true,
									readOnly	: true,
									width		: 30,
									cls			: 'textfield-transparent'
								}]
							},{
								layout 	: 'table',
								border	: false,
								width	: 220,
								items	: [{
									layout 		: 'form',
									border 		: false,
									width		: 190,
									labelWidth	: 95,
									items		: [{
										xtype			: 'numberfield',
										fieldLabel		: '$FLANSCHDICKE$',
										id				: 'LAGER_TRAEGER_FLANSCHDICKE',
										labelSeparator	: '&nbsp;',
										width			: 80,
										listeners: {
											'change': _setNumberfieldEvent
										}
									}]
								},{
									xtype		: 'textfield',
									value		: 'mm',
									hideLabels	: true,
									readOnly	: true,
									width		: 30,
									cls			: 'textfield-transparent'
								}]
							}]
						//}]
						},{//Bildchen
							hidden		: true,	// sobald Bilder vorhanden -> false
							//hidden		: false,
							width 		: 110,
							height		: 110,
							layout		: 'form',
							//frame  		: true,
							frame  		: false,
							//style		: 'padding-left: 210px',
							style		: 'margin-left: 1px ; padding: 8px',
							id			: 'LAGER_PIC_PREVIEW',
							html		: ''						
						}]
					},{//Zeile 2
						layout		: 'column',
						border		: false,
						labelStyle	: 'font-size:11px',
						style		: 'padding-top: 5px',
						hideLabels	: true,
						items : [{ //Tatsaechliche Mae
							xtype			: 'fieldset',
							id				: 'LAGER_TATSAECHLICHE_MASS',
							title			: '$LAGER_TATSAECHLICHE_MASS_LABEL$',
							//style			: 'margin-left: 5px ; padding: 5px',
							style			: 'padding: 5px',
							width			: 340,
							height			: 70,
							items			: [{
								layout 	: 'table',
								border	: false,
								width	: 330,
								items	: [{
									layout 		: 'form',
									border 		: false,
									width		: 280,
									labelWidth	: 150,
									items		: [{
										xtype			: 'numberfield',
										fieldLabel		: '$IDC_HOEHEN_ACT_LABEL$',
										id				: 'LAGER_TATSAECHLICHE_HOEHE',
										labelSeparator	: '&nbsp;',
										width			: 90,
										listeners: {
											'change': _setNumberfieldEvent
										}
									}]
								},{
									xtype		: 'textfield',
									value		: 'mm',
									hideLabels	: true,
									readOnly	: true,
									width		: 30,
									cls			: 'textfield-transparent',
									style		: 'margin-left: 5px; margin-top: -5px'
								}]
							},{
								layout 	: 'table',
								border	: false,
								width	: 330,
								items	: [{
									layout 		: 'form',
									border 		: false,
									width		: 280,
									labelWidth	: 150,
									items		: [{
										xtype			: 'numberfield',
										fieldLabel		: '$IDC_EMASS_ACT_LABEL$',
										id				: 'LAGER_TATSAECHLICHE_EINBAUMASS',
										labelSeparator	: '&nbsp;',
										width			: 90,
										listeners: {
											'change': _setNumberfieldEvent
										}
									}]
								},{
									xtype		: 'textfield',
									value		: 'mm',
									hideLabels	: true,
									readOnly	: true,
									width		: 30,
									cls			: 'textfield-transparent',
									style		: 'margin-left: 5px; margin-top: -5px'
								}]
							}]
						}]
					},{ //ZEILE 3 - BUTTON
						layout 	: 'table',
						border	: false,
						width	: 500,
						items	: [{
							xtype	: 'button',
							minWidth: 130,
							width	: 140,
							style	: 'margin-top: 2px;',
							text	: '$IDC_SUCHEN_BUT$',
							handler	: function(){
								_setButtonEvent();
							}
						},{
							layout 	: 'form',
							border 	: false,
							width	: 20
						},{
							//layout 	: 'form',							
							//style	: 'margin-top: 5px;',
							//border  : false,
							//width	: 340,
							//items	: [{
								xtype			: 'fieldset',
								hidden			: true,
								id				: 'LAGER_SONDERABMESSUNGEN',
								title			: _getTooltip(true), //'$LAGER_SONDERABMESSUNGEN_LABEL$',//_getTooltip(true),
								border			: false,
								animCollapse	: true,
								titleCollapse	: true,
								checkboxToggle	: true,
								checkboxName	: 'LAGER_SONDERABMESSUNGEN_CHECK_NAME',
								width			: 330,
								style			: 'margin-top: 10px;',
								listeners: {
									'expand': function(panel) {
										if(!bBlock){
											_setCheckBoxEvent("LAGER_SONDERABMESSUNGEN",true);
											Cascade.panel.lager.auswahl_standard.updateFieldSetTitle("LAGER_SONDERABMESSUNGEN",false);
										}
									},
									
									'collapse': function(panel) {
										if(!bBlock){
											_setCheckBoxEvent("LAGER_SONDERABMESSUNGEN",false);
											Cascade.panel.lager.auswahl_standard.updateFieldSetTitle("LAGER_SONDERABMESSUNGEN",true);
										}
									}
								}
							//}]
						}]
					},
					_gridTable
					]
				});
				
				var cp = Ext.getCmp('center-panel');
				cp.insert(idx, form);
				cp.doLayout();
			}
			//else
			//	Cascade.app.setUpdateViewport(form.id);
			
			form.getForm().reset();
			bBlock = false;
			Ext.Ajax.request({   
			    url		: 'lager.auswahl-standard/getInitalValues',
				success	: function( response, options){
					Ext.getCmp('lager.auswahl_standard_tabelle').getStore().loadData([]);
					Ext.getCmp('move-next').hide();
					var message	= Ext.util.JSON.decode(response.responseText);
					Cascade.panel.lager.auswahl_standard_setGuiValue(message);					
				}
			});	
		}
	}
}();