Ext.namespace('Cascade.panel.lager');
Cascade.panel.lager.auswahl_sattel = function()
{
	var form,_gridTable,idx;
	var bBlock = false;
	
	var storeSattelLaenge = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeOberflaeche  = new Ext.data.SimpleStore({
		id		: 'id',
		fields	: ['id', 'text']
	});
	
	var storeTable = new Ext.data.SimpleStore({
		fields : [
			{ name: 'id'}, 
			{ name: 'typ' },
			{ name: 'nennweite' },
			{ name: 'max_daemmdicke' },
			{ name: 'auflagelast_minus_fz' },
			{ name: 'querlast_fx' },
			{ name: 'abhebelast_fz' },
			{ name: 'gewicht' },
			{ name: 'preis' }
		] 
	} );
	
	var _deleteTableStore = function(){
		Ext.getCmp('lager.auswahl_sattel_tabelle').getStore().loadData([]);
		if(Ext.getCmp('move-next').hidden == false)
			_setTableSelEvent('-');		
	}
	
	var _onActionComplete = function(strform, action){ //Wenn bentigt erweitern
		Cascade.app.getNextPanel(form,action); //Next Dialog		
	}
	
	var _setRadioEvent = function(oClicked, bChecked){
		if(!bBlock && bChecked){
			_deleteTableStore();	
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-sattel/setRadio',
				params  : {
					'radiogroup' : oClicked.name,
					'radiovalue' : oClicked.inputValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_sattel_setGuiValue(message);
				}
			});	
		}
	}
	
	var _setCheckBoxEvent = function(strCheckboxId,strValue){
		if(!bBlock){
			_deleteTableStore();
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-sattel/setCheckBox',
				params  : {
					'checkboxid'	: strCheckboxId,
					'checkboxvalue' : strValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_sattel_setGuiValue(message);
				}
			});	
		}
	}

	var _setComboBoxEvent = function(combo, record, idx){
		if(!bBlock){
			_deleteTableStore();
			var strComboBoxId 		= combo.id;
			var strSelectionValueId	= combo.getValue();
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-sattel/setComboBox',
				params  : {
					'comboboxid'	: strComboBoxId,
					'comboboxvalue' : strSelectionValueId
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_sattel_setGuiValue(message);
				}
			});	
		}
	}
	
	var _setNumberfieldEvent = function(field, newValue, oldValue){
		if(!bBlock){
			_deleteTableStore();
			Ext.Ajax.request( {
				url 	: 'lager.auswahl-sattel/setNumberfield',
				params  : {
					'numberfieldid'		: field.id,
					'numberfieldvalue' 	: newValue
				},
				success : function(response, options) {
					var message	= Ext.util.JSON.decode(response.responseText);
					if(message)
						Cascade.panel.lager.auswahl_sattel_setGuiValue(message);
				}
			});	
		}
	};
	
	var _setButtonEvent = function(){
		if(!bBlock){
			_deleteTableStore();
			Ext.Ajax.request({   
			    url		: 'lager.auswahl-sattel/getButton',
				success	: function( response, options){
					var message	= Ext.util.JSON.decode(response.responseText);
					Cascade.panel.lager.auswahl_sattel_setGuiValue(message);
				}
			});	
		}
	}
	
	var _setTableSelEvent = function(rowIndex,rowId){
		if(!bBlock){
			Ext.Ajax.request({   
			    url		: 'lager.auswahl-sattel/setTableSel',
			    params  : {
					'selection'	: rowIndex,
					'rowId'		: rowId
				},
				success	: function( response, options){
					if(rowId == '-')
						Ext.getCmp('move-next').hide();
					else
						Ext.getCmp('move-next').show();
				}
			});	
		}
	}
	
	return {
		setBlockEvent : function(bBlockEvent){
			bBlock = bBlockEvent;
		},
		getStore : function(){
			return ({
				'storeSattelLaenge' 	: storeSattelLaenge,
				'storeOberflaeche'		: storeOberflaeche,
				'storeTable'			: storeTable
			});			
		},
		init: function(idx){
			this.idx = idx;
			bBlock = true;
			if (!form) {				
				// erzeuge Tabelle fr Suchresultate Lager
				_gridTable = new Ext.grid.GridPanel(
				{
					id: 'lager.auswahl_sattel_tabelle',
					style : 'padding-top: 5px',
					store : storeTable,
					columns: [
						{ 	
							// Typ
							header: '$TCH_TYP$', 
							width: 160, 
							sortable: true, 
							dataIndex: 'typ'
						},
						{ 	
							// Nennweite
							header: '$TCH_RH_NENNWEITE$',
							width: 75,
							sortable: true,
							dataIndex: 'nennweite'
						},
						{ 
							// maximale Dmmdicke J
							header: '$TCH_MAXDAEMMDICKE$', 
							width: 80, 
							sortable: true,
							dataIndex: 'max_daemmdicke'
						},
						{ 
							// Auflagelast -Fz
							header: '$TCH_AUFLAGELAST$', 
							width: 80, 
							sortable: true,
							dataIndex: 'auflagelast_minus_fz' 
						},
						{ 
							// Querlast Fx
							header: '$TCH_QUERLAST$', 
							width: 80, 
							sortable: true,
							dataIndex: 'querlast_fx' 
						},
						{ 
							// Abhebelast Fz
							header: '$TCH_ABHEBELAST$', 
							width: 60, 
							sortable: true,
							dataIndex: 'abhebelast_fz' 
						},
						{ 
							// Gewicht
							header: '$TCH_GEWICHT$', 
							width: 65, 
							sortable: true,
							dataIndex: 'gewicht' 
						},
						{ 
							// Preis
							header: 'W_V_S_V', 
							width: 65, 
							sortable: true,
							dataIndex: 'preis' 
						}
					],
					sm: new Ext.grid.RowSelectionModel( { singleSelect: true} ),										
					width: 690,
					height: 200,
					frame: false,
					border: false,
					title: '',
					header: false,
					listeners	: {	
						'headerclick' : function(grid,colIndex,e){
						},
						'cellclick' : function(grid, rowIndex, colIndex, e ) {
							_setTableSelEvent(rowIndex,storeTable.getAt(rowIndex).data.id)
						}
					}	
				} );
				
				form = new Ext.FormPanel({
					frame		: true,
					id			: 'lager.auswahl_sattel',
					title		: '$LAGER_AUSWAHL_SATTEL$',
					bodyStyle	: 'padding-left: 5px',
					listeners: {
						'actioncomplete': _onActionComplete
					},
					items: [{
						layout		:'column',
						border		: false,
						labelStyle	: 'font-size:11px',
						items : [{ //checkbox Abhebesicherung
							layout	: 'form',
							border  : false,
							autoHeight	: true,
							items	: [{
								xtype			: 'checkbox',
								id				: 'LAGER_SATTEL_ZYLIDER',
								hiddenName		: 'LAGER_SATTEL_ZYLIDER_NAME',
								boxLabel		: '$LAGER_ZYLINDER_ROLLENLAGER$',
								valueField		: 'id',
								displayField	: 'LAGER_SATTEL_ZYLIDER',
								mode			: 'local',
								triggerAction	: 'all'	,
								hideLabel		: true,
								listeners		: {
									render : function(a,value,c) {
										this.on({
		                                    check : function(a,value,c) {
		                                        _setCheckBoxEvent(this.id,value);
		                                    }
		                                });
									}
								}
							}]
						},{
							layout		: 'form',
							border  	: false,
							autoHeight	: true,
							id			: 'LAGER_SATTEL_ABHEBESICHERUNG_FORM',
							style		: 'margin-left: 130px',
							items		: [{
								xtype			: 'checkbox',
								id				: 'LAGER_SATTEL_ABHEBESICHERUNG',
								hiddenName		: 'LAGER_SATTEL_ABHEBESICHERUNG_NAME',
								boxLabel		: '$LAGER_MIT_ABHEBESICHERUNG$',
								valueField		: 'id',
								displayField	: 'LAGER_SATTEL_ABHEBESICHERUNG',
								mode			: 'local',
								triggerAction	: 'all'	,
								hideLabel		: true,
								listeners		: {
									render : function(a,value,c) {
										this.on({
		                                    check : function(a,value,c) {
		                                        _setCheckBoxEvent(this.id,value);
		                                    }
		                                });
									}
								}
							}]
						}]
					},{//Zeile 2 - FieldSets
						layout		:'column',
						border		: false,
						labelStyle	: 'font-size:11px',
						style		: 'padding-top:5px',
						items : [{
							xtype			: 'fieldset',
							id				: 'LAGER_SATTEL_ROHRUMSCHLUSS',
							title			: '$LAGER_ROHRUMSCHLUSS$',
							checkboxToggle	: true,
							checkboxName	: 'LAGER_SATTEL_ROHRUMSCHLUSS_CHECK_NAME',
							animCollapse	: true,
							titleCollapse	: true,
							height			: 100,
							width			: 290,	
							style			: 'padding: 5px;',						
							listeners: {
								'expand': function(panel) {
									if(!bBlock){
										_setCheckBoxEvent("LAGER_SATTEL_ROHRUMSCHLUSS",true);
										bBlock = true;
										Ext.getCmp("LAGER_SATTEL_ANSCHWEISSEN").collapse();
										bBlock = false;
										_setCheckBoxEvent("LAGER_SATTEL_ANSCHWEISSEN",false);										
									}
								},
								
								'collapse': function(panel) {
									if(!bBlock){
										_setCheckBoxEvent("LAGER_SATTEL_ROHRUMSCHLUSS",false);
										bBlock = true;
										Ext.getCmp("LAGER_SATTEL_ANSCHWEISSEN").expand();
										bBlock = false;
										_setCheckBoxEvent("LAGER_SATTEL_ANSCHWEISSEN",true);										
									}
								}
							},
							items	: [{
								layout		: 'form',
								hideLabels	: true,
								defaultType	: 'radio',
								items: [{
	                                id			: 'LAGER_SATTEL_ROHRUMSCHLUSS_SCHELLE_SCHELLE',
									inputValue	: 'SCHELLE_SCHELLE',
									boxLabel	: '$LAGER_SCHELLE_SCHELLE$',
									name		: 'LAGER_SATTEL_ROHRUMSCHLUSS_R',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
	                                id			: 'LAGER_SATTEL_ROHRUMSCHLUSS_SCHELLE_SCHALE',
									inputValue	: 'SCHELLE_SCHALE',
									boxLabel	: '$LAGER_SCHELLE_SCHALE$',
									name		: 'LAGER_SATTEL_ROHRUMSCHLUSS_R',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
	                                id			: 'LAGER_SATTEL_ROHRUMSCHLUSS_SCHALE_SCHALE',
									inputValue	: 'SCHALE_SCHALE',
									boxLabel	: '$LAGER_SCHALE_SCHALE$',
									name		: 'LAGER_SATTEL_ROHRUMSCHLUSS_R',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
	                                id			: 'LAGER_SATTEL_ROHRUMSCHLUSS_BUEGEL_SCHALE',
									inputValue	: 'BUEGEL_SCHALE',
									boxLabel	: '$LAGER_BUEGEL_SCHALE$',
									name		: 'LAGER_SATTEL_ROHRUMSCHLUSS_R',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								}]
							}]							
						},{
							xtype			: 'fieldset',
							id				: 'LAGER_SATTEL_ANSCHWEISSEN',
							title			: '$LAGER_ZUM_ANSCHWEISSEN$',
							checkboxToggle	: true,
							checkboxName	: 'LAGER_SATTEL_ANSCHWEISSEN_CHECK_NAME',
							animCollapse	: true,
							titleCollapse	: true,
							height			: 100,
							width			: 280,
							style			: 'margin-left: 35px; padding: 5px;',							
							listeners: {
								'expand': function(panel) {
									if(!bBlock){
										_setCheckBoxEvent("LAGER_SATTEL_ANSCHWEISSEN",true);
										bBlock = true;
										Ext.getCmp("LAGER_SATTEL_ROHRUMSCHLUSS").collapse();
										bBlock = false;
										_setCheckBoxEvent("LAGER_SATTEL_ROHRUMSCHLUSS",false);										
									}
								},
								
								'collapse': function(panel) {
									if(!bBlock){
										_setCheckBoxEvent("LAGER_SATTEL_ANSCHWEISSEN",false);
										bBlock = true;
										Ext.getCmp("LAGER_SATTEL_ROHRUMSCHLUSS").expand();
										bBlock = false;
										_setCheckBoxEvent("LAGER_SATTEL_ROHRUMSCHLUSS",true);										
									}
								}
							},
							items	: [{
								layout		: 'form',
								hideLabels	: true,
								defaultType	: 'radio',
								items: [{
	                                id			: 'LAGER_SATTEL_ANSCHWEISSEN_BIEGETEIL',
									inputValue	: 'BIEGETEIL',
									boxLabel	: '$LAGER_BIEGETEIL$',
									name		: 'LAGER_SATTEL_ANSCHWEISSEN_R',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
	                                id			: 'LAGER_SATTEL_ANSCHWEISSEN_STEGE',
									inputValue	: 'STEGE',
									boxLabel	: '$LAGER_STEGE$',
									name		: 'LAGER_SATTEL_ANSCHWEISSEN_R',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
	                                id			: 'LAGER_SATTEL_ANSCHWEISSEN_STEGE_M_SCHALE',
									inputValue	: 'STEGE_M_SCHALE',
									boxLabel	: '$LAGER_STEGE_M_SCHALE$',
									name		: 'LAGER_SATTEL_ANSCHWEISSEN_R',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								},{
	                                id			: 'LAGER_SATTEL_ANSCHWEISSEN_N_SCHALE',
									inputValue	: 'N_SCHALE',
									boxLabel	: '$LAGER_N_SCHALE$',
									name		: 'LAGER_SATTEL_ANSCHWEISSEN_R',
									listeners	: {
		                                'check': _setRadioEvent
		                            }
								}]
							}]
						}]
					},{ //Zeile 3 - Auflagedurchmesser
						layout		:'column',
						border		: false,
						hidden		: true,
						labelStyle	: 'font-size:11px',
						style		: 'padding-top:5px',
						items : [{ //checkbox Abhebesicherung
							layout		: 'form',
							border  	: false,
							autoHeight	: true,
							labelWidth	: 145,
							items		: [{//DURCHMESSER
								xtype			: 'numberfield',
								fieldLabel		: '$LAGER_AUFLAGEDURCHMESSER $',
								id				: 'LAGER_SATTEL_AUFLAGEDURCHMESSER',
								labelSeparator	: '&nbsp;',
								width			: 140,
								listeners		: {
									'change': _setNumberfieldEvent
								}
							}]
						},{
							layout		: 'form',
							border  	: false,
							autoHeight	: true,
							style		: 'margin-left: 45px;',
							items		: [{//SONDER
								layout 	: 'table',
								border	: false,
								items	: [{
									xtype			: 'checkbox',
									width			: 30,
									id				: 'LAGER_SATTEL_AUFLAGEDURCHMESSER_SONDER_CHECK',
									hiddenName		: 'LAGER_SATTEL_AUFLAGEDURCHMESSER_SONDER_CHECK_NAME',
									valueField		: 'id',
									displayField	: 'LAGER_SATTEL_AUFLAGEDURCHMESSER_SONDER_CHECK',
									mode			: 'local',
									triggerAction	: 'all'	,
									hideLabel		: true,
									listeners		: {
										render : function(a,value,c) {
											this.on({
			                                    check : function(a,value,c) {
			                                        _setCheckBoxEvent(this.id,value);
			                                    }
			                                });
										}
									}
								},{
									layout 		: 'form',
									border 		: false,
									width		: 200,
									labelWidth	: 95,
									style		: 'padding-top:3px;',
									items		: [{
										xtype			: 'numberfield',
										fieldLabel		: '$LAGER_SONDER$',
										id				: 'LAGER_SATTEL_AUFLAGEDURCHMESSER_SONDER',
										labelSeparator	: '&nbsp;',
										width			: 100,
										listeners: {
											'change': _setNumberfieldEvent
										}
									}]
								},{
									xtype		: 'textfield',
									value		: 'mm',
									hideLabels	: true,
									readOnly	: true,
									width		: 30,
									cls			: 'textfield-transparent'
								}]
							}]
						}]
					},{ //Zeile 4 - Sattelnge
						layout		:'column',
						border		: false,
						labelStyle	: 'font-size:11px',
						style		: 'padding-top:5px',
						items : [{ //checkbox Abhebesicherung
							layout		: 'form',
							border  	: false,
							autoHeight	: true,
							width		: 320,
							labelWidth	: 145,
							items		: [{//Lnge
								xtype			: 'combo',
								id				: 'LAGER_SATTEL_LAENGE_COMBO',
								fieldLabel		: '$LAGER_SATTEL_LAENGE$',
								labelSeparator	: '',
								labelAlign		: 'left',
								hiddenName		:'LAGER_SATTEL_LAENGE_NAME',
								store			: storeSattelLaenge,
								listWidth		: 140,
								listeners		: {
									'select': _setComboBoxEvent
								},
								valueField		: 'id',
								displayField	: 'text',
								typeAhead		: true,
								mode			: 'local',
								triggerAction	: 'all',
								selectOnFocus	: true,
								width			: 140,
								editable		: false
							}]
						},{
							layout		: 'form',
							border  	: false,
							autoHeight	: true,
							labelWidth	: 95,
							style		: 'margin-left: 15px;',
							items		: [{//SONDER
								layout 	: 'table',
								border	: false,
								items	: [{
									xtype			: 'checkbox',
									width			: 30,
									id				: 'LAGER_SATTEL_LAENGE_SONDER_CHECK',
									hiddenName		: 'LAGER_SATTEL_LAENGE_SONDER_CHECK_NAME',
									valueField		: 'id',
									displayField	: 'LAGER_SATTEL_LAENGE_SONDER_CHECK',
									mode			: 'local',
									triggerAction	: 'all'	,
									hideLabel		: true,
									listeners		: {
										render : function(a,value,c) {
											this.on({
			                                    check : function(a,value,c) {
			                                        _setCheckBoxEvent(this.id,value);
			                                    }
			                                });
										}
									}
								},{
									layout 		: 'form',
									border 		: false,
									width		: 200,
									labelWidth	: 95,
									style		: 'padding-top:3px;',
									items		: [{
										xtype			: 'numberfield',
										fieldLabel		: '$LAGER_SONDER$',
										id				: 'LAGER_SATTEL_LAENGE_SONDER',
										labelSeparator	: '&nbsp;',
										width			: 100,
										listeners: {
											'change': _setNumberfieldEvent
										}
									}]
								},{
									xtype		: 'textfield',
									value		: 'mm',
									hideLabels	: true,
									readOnly	: true,
									width		: 30,
									cls			: 'textfield-transparent'
								}]
							}]
						}]
					},{ //ZEILE 5 - Oberflaeche
						layout 		: 'form',
						border 		: false,
						labelWidth	: 145,
						items		: [{
							xtype			: 'combo',
							id				: 'LAGER_SATTEL_OBERFLAECHE_COMBO',
							fieldLabel		: '$OBERFLAECHENSCHUTZ$',
							labelSeparator	: '',
							labelAlign		: 'left',
							hiddenName		:'LAGER_SATTEL_OBERFLAECHE_NAME',
							store			: storeOberflaeche,
							listWidth		: 140,
							listeners		: {
								'select': _setComboBoxEvent
							},
							valueField		: 'id',
							displayField	: 'text',
							typeAhead		: true,
							mode			: 'local',
							triggerAction	: 'all',
							selectOnFocus	: true,
							width			: 140,
							editable		: false
						}]
					},{ //ZEILE 6 - BUTTON
						xtype	: 'button',
						minWidth: 130,
						style	: 'margin-top: 10px;',
						text	: '$IDC_SUCHEN_BUT$',
						handler	: function(){
							_setButtonEvent();
						}
					},
					_gridTable]
				});
				
				var cp = Ext.getCmp('center-panel');
				cp.insert(idx, form);
				cp.doLayout();
			}
			
			form.getForm().reset();
			bBlock = false;			
			
			Ext.Ajax.request({   
			    url		: 'lager.auswahl-sattel/getInitalValues',
				success	: function( response, options){
					var message	= Ext.util.JSON.decode(response.responseText);
					Ext.getCmp('lager.auswahl_sattel_tabelle').getStore().loadData([]);
					Ext.getCmp('move-next').hide();
					Cascade.panel.lager.auswahl_sattel_setGuiValue(message);
				}
			});	
		}
	}
}();