Ext.namespace('Cascade.panel.lager');
Cascade.panel.lager.auswahl_rollenlager_setGuiValue = function(message)
{
	if(!message)
		return;
	if(!message.fieldset){
		if(!message.resulttable)
			return;
		else
			message.fieldset = {};			
	}
		
	Cascade.panel.lager.auswahl_rollenlager.setBlockEvent(true);
	var oDialogStores = Cascade.panel.lager.auswahl_rollenlager.getStore();
	
	/**
	 * @private function
	 */
	var _setDisabled = function(strId,bValue){	
		if(bValue)
			Ext.getCmp(strId).disable();
		else if(bValue !== "undefined")
			Ext.getCmp(strId).enable();	
	}
	
	var _setHide = function(strId,bValue){			
		if(bValue)
			Ext.getCmp(strId).hide();
		else if(bValue !== "undefined")
			Ext.getCmp(strId).show();	
	}
	
	/**
	 * @private function
	 */	
	var _setValueRadio = function(strValue){	
		Ext.getCmp(strValue).suspendEvents(false);			
		Ext.getCmp(strValue).setValue(true);			
		Ext.getCmp(strValue).resumeEvents();	
	}
	
	/**
	 * @private
	 * initialisierung des Fieldsets Trger
	 */	
	var _setFieldSet_Traeger = function(message_traeger){
		if(message_traeger.store){
			if(message_traeger.store.storeTArt)
				oDialogStores.storeTraegerArt.loadData(message_traeger.store.storeTArt);
			if(message_traeger.store.storeTGroesse)	
				oDialogStores.storeTraegerGroesse.loadData(message_traeger.store.storeTGroesse);
		}
		
		if(message_traeger.disabled){	
			_setDisabled("LAGER_ROLLEN_TRAEGER_HOEHE",message_traeger.disabled.disHoehe);
			_setDisabled("LAGER_ROLLEN_TRAEGER_BREITE",message_traeger.disabled.disBreite);
			_setDisabled("LAGER_ROLLEN_TRAEGER_FLANSCHDICKE",message_traeger.disabled.disFDicke);			
			_setDisabled("LAGER_ROLLEN_TRAEGER_ART",message_traeger.disabled.disTArt);
			_setDisabled("LAGER_ROLLEN_TRAEGER_GROESSE",message_traeger.disabled.disTGroesse);
		}
		
		if(message_traeger.value){
			Ext.getCmp("LAGER_ROLLEN_TRAEGER_HOEHE").setValue(message_traeger.value.vHoehe);
			Ext.getCmp("LAGER_ROLLEN_TRAEGER_BREITE").setValue(message_traeger.value.vBreite);
			Ext.getCmp("LAGER_ROLLEN_TRAEGER_FLANSCHDICKE").setValue(message_traeger.value.vFDicke);			
			Ext.getCmp("LAGER_ROLLEN_TRAEGER_ART").setValue(message_traeger.value.vTArt);
			Ext.getCmp("LAGER_ROLLEN_TRAEGER_GROESSE").setValue(message_traeger.value.vTGroesse);
		}
	}
	
	/**
	 * @private
	 * neu - angepasst
	 * man kommt nur noch in die LagerSystem Maske wenn Klemmsysteme existieren
	 * alles andere wird in Lager.Auswahl Standard abgefangen und ermittelt 
	 */
	var _setFieldSet_LagerSystem_Function = function(message_lagersystem){
		if(message_lagersystem.disabled){
			for(var i=0;i<message_lagersystem.disabled.length;i++){		
				var aPart = message_lagersystem.disabled[i];
				_setDisabled("LAGER_LAGERSYSTEM_"+aPart[0],aPart[1]);
			}
		}
		
		if(message_lagersystem.value){
			for(var i=0;i<message_lagersystem.value.length;i++){		
				_setValueRadio("LAGER_LAGERSYSTEM_ABHEBESICHERUNG_"+message_lagersystem.value[i]);
			}
		}
	}
	/**
	 * @private
	 * fr Rollenlager gibt es ein eigenes Fieldset was hierdurch initialisiert wird.
	 * Beachte: entwender Rollenlager oder LagerSystem beides zur gleichen zeit geht nicht
	 */
	var _setFieldSet_Rollenlager_Function = function(message_rollelager){
		if(message_rollelager.value){
			_setValueRadio("LAGER_ROLLENLAGER_COLUMN_"+message_rollelager.value.vRadioBf);
			_setValueRadio("LAGER_ROLLENLAGER_COLUMN_"+message_rollelager.value.vRadioFk);
			
			if(message_rollelager.value.vAbhebesicherung == true)
				Ext.getCmp("LAGER_ROLLENLAGER_COLUMN_ABHEBESICHERUNG").setValue(true);				
			else if(message_rollelager.value.vAbhebesicherung == false)
				Ext.getCmp("LAGER_ROLLENLAGER_COLUMN_ABHEBESICHERUNG").setValue(false);
		}
		
		if(message_rollelager.disabled){
			_setDisabled("LAGER_ROLLENLAGER_COLUMN_ABHEBESICHERUNG",message_rollelager.disabled.vAbhebesicherung);
			_setDisabled("LAGER_ROLLENLAGER_COLUMN_LOSE",message_rollelager.disabled.Lose);
			_setDisabled("LAGER_ROLLENLAGER_COLUMN_GEFUEHRT",message_rollelager.disabled.Gefuehrt);
			_setDisabled("LAGER_ROLLENLAGER_COLUMN_KLEMMBAR",message_rollelager.disabled.KLEMMBAR);
			_setDisabled("LAGER_ROLLENLAGER_COLUMN_SCHRAUBBAR",message_rollelager.disabled.SCHRAUBBAR);
			
		}	
		
		if(message_rollelager.show == false){
			Ext.getCmp("LAGER_ROLLENLAGER_BEFESTIGUNG_FIELDSET").hide();
			Ext.getCmp("LAGER_ROLLENLAGER_FUNCTION_FIELDSET").hide();
			Ext.getCmp("LAGER_ROLLENLAGER_COLUMN_ABHEBESICHERUNG_FORM").hide();
		}
		else{
			Ext.getCmp("LAGER_ROLLENLAGER_BEFESTIGUNG_FIELDSET").show();
			Ext.getCmp("LAGER_ROLLENLAGER_FUNCTION_FIELDSET").show();
			Ext.getCmp("LAGER_ROLLENLAGER_COLUMN_ABHEBESICHERUNG_FORM").show();
		}
		
		if(message_rollelager.hide){
			_setHide("LAGER_ROLLENLAGER_COLUMN_ABHEBESICHERUNG_FORM",message_rollelager.hide.vAbhebesicherung);
		}		
	}
	
	var _setFieldSet_Rollenlager = function(message_rr){
		if(message_rr.store){
			if(message_rr.store.Art)
				oDialogStores.storeRollenlagerArt.loadData(message_rr.store.Art);
			if(message_rr.store.Typ)
				oDialogStores.storeRollenlagerTyp.loadData(message_rr.store.Typ);	
			if(message_rr.store.Material)
				oDialogStores.storeRollenlagerMaterial.loadData(message_rr.store.Material);		
			if(message_rr.store.Oberflaeche)
				oDialogStores.storeRollenlagerOberflaeche.loadData(message_rr.store.Oberflaeche);		
		}
		
		if(message_rr.value){ 
			if(message_rr.value.vArt)
				Ext.getCmp("LAGER_ROLLENLAGER_ART").setValue(message_rr.value.vArt);
			
			if(message_rr.value.vTyp)
				Ext.getCmp("LAGER_ROLLENLAGER_TYP").setValue(message_rr.value.vTyp);	
				
			if(message_rr.value.vMaterial)
				Ext.getCmp("LAGER_ROLLENLAGER_MATERIAL").setValue(message_rr.value.vMaterial);
			
			if(message_rr.value.vOberflaeche)
				Ext.getCmp("LAGER_ROLLENLAGER_OBERFLAECHE").setValue(message_rr.value.vOberflaeche);	
		}
		
		if(message_rr.hide){
			if(message_rr.hide){
				_setHide("LAGER_ROLLENLAGER_ART_FORM",message_rr.hide.hArt);
				_setHide("LAGER_ROLLENLAGER_TYP_FORM",message_rr.hide.hTyp);
				_setHide("LAGER_ROLLENLAGER_MATERIAL_FORM",message_rr.hide.hMaterial);
				_setHide("LAGER_ROLLENLAGER_OBERFLAECHE_FORM",message_rr.hide.hOberflaeche);
			}
		}
	}
	
	var _setFieldSet_Sattel = function(message_sattel){
		if(message_sattel.value){
			if(message_sattel.value.vRAD != undefined)
				Ext.getCmp("LAGER_ROLLEN_SATTEL_ROHRAUSSENDURCHMESSER").setValue(message_sattel.value.vRAD);
			
			if(message_sattel.value.vAD != undefined)
				Ext.getCmp("LAGER_ROLLEN_SATTEL_AUFLAGEDURCHMESSER").setValue(message_sattel.value.vAD);
			
			if(message_sattel.value.vSL != undefined)
				Ext.getCmp("LAGER_ROLLEN_SATTEL_SATTELLAENGE").setValue(message_sattel.value.vSL);		
		
			//Test Button Search disable/enable
			var oRohrauss = Ext.getCmp("LAGER_ROLLEN_SATTEL_ROHRAUSSENDURCHMESSER");
			var oAuflaged = Ext.getCmp("LAGER_ROLLEN_SATTEL_AUFLAGEDURCHMESSER");
			var oSattella = Ext.getCmp("LAGER_ROLLEN_SATTEL_SATTELLAENGE");
			
			var __disable = function(bRohrauss){
				if(oRohrauss.getValue()>0 && bRohrauss)
					oRohrauss.el.dom.style.borderBottomColor = "";
				else
					oRohrauss.el.dom.style.borderBottomColor = "red";
				
				if(oAuflaged.getValue()>0)
					oAuflaged.el.dom.style.borderBottomColor = "";
				else
					oAuflaged.el.dom.style.borderBottomColor = "red";	
					
				if(oSattella.getValue()>0)
					oSattella.el.dom.style.borderBottomColor = "";
				else
					oSattella.el.dom.style.borderBottomColor = "red";		
				
				Ext.getCmp("LAGER_ROLLEN_SATTEL_BUTTON").disable();						
			}
			
			if(oRohrauss.getValue()>0 && oAuflaged.getValue()>0 && oSattella.getValue()>0){
				if(oRohrauss.getValue() <= oAuflaged.getValue()){
					Ext.getCmp("LAGER_ROLLEN_SATTEL_BUTTON").enable();
					oSattella.el.dom.style.borderBottomColor = "";
					oAuflaged.el.dom.style.borderBottomColor = "";
					oRohrauss.el.dom.style.borderBottomColor = "";
				}
				else
					__disable(false);
			}
			else
				__disable(true);			
		}
	}
	
	if(message.fieldset.lager_traeger){
		if(message.fieldset.lager_traeger.show == true){
			Ext.getCmp("LAGER_ROLLEN_TRAEGER").show();	
			_setFieldSet_Traeger(message.fieldset.lager_traeger);
		}
		else
			Ext.getCmp("LAGER_ROLLEN_TRAEGER").hide();			
	}
	
	if(message.fieldset.strfunction){
		if(message.fieldset.lager_function.radioshow)
			Ext.getCmp("LAGER_ROLLENLAGER_ART_WERKSTOFF_FORM").show();
		else
			Ext.getCmp("LAGER_ROLLENLAGER_ART_WERKSTOFF_FORM").hide();	
		
		if(message.fieldset.lager_function.radiovalue)
			_setValueRadio(message.fieldset.lager_function.radiovalue);
		
		if((message.fieldset.lager_function.radiodisabled==true) ||  (message.fieldset.lager_function.radiodisabled==false))
			_setDisabled("LAGER_ROLLENLAGER_ART_WERKSTOFF_PA",message.fieldset.lager_function.radiodisabled);
		
		
		if(message.fieldset.strfunction == "LAGERSYSTEM"){
			Ext.getCmp("LAGER_ROLLENLAGER_COLUMN").hide();
			Ext.getCmp("LAGER_LAGERSYSTEM_COLUMN").show();
			_setFieldSet_LagerSystem_Function(message.fieldset.lager_function);			
		}
		else{
			Ext.getCmp("LAGER_ROLLENLAGER_COLUMN").show();
			Ext.getCmp("LAGER_LAGERSYSTEM_COLUMN").hide();
			_setFieldSet_Rollenlager_Function(message.fieldset.lager_function);			
		}
		
		if(message.fieldset.lager_function.hide){
			_setHide("LAGER_ROLLEN_AUFLAGE_DURCHMESSER_FORM",message.fieldset.lager_function.hide.Auflagendurchmesser);
			_setHide("LAGER_ROLLEN_FUSSBREITE_FORM",message.fieldset.lager_function.hide.Fussbreite);
		}
		
		if(message.fieldset.lager_function.disabled){
			if(message.fieldset.lager_function.disabled.Auflagendurchmesser != undefined)
				_setDisabled("LAGER_ROLLEN_AUFLAGE_DURCHMESSER",message.fieldset.lager_function.disabled.Auflagendurchmesser);
			
			if(message.fieldset.lager_function.disabled.Fussbreite != undefined)
				_setDisabled("LAGER_ROLLEN_FUSSBREITE",message.fieldset.lager_function.disabled.Fussbreite);
		}
		
		if(message.fieldset.lager_function.value){
			if(message.fieldset.lager_function.disabled.Auflagendurchmesser != undefined)
				Ext.getCmp("LAGER_ROLLEN_AUFLAGE_DURCHMESSER").setValue(message.fieldset.lager_function.value.Auflagendurchmesser);
			
			if(message.fieldset.lager_function.disabled.Fussbreite != undefined)
				Ext.getCmp("LAGER_ROLLEN_FUSSBREITE").setValue(message.fieldset.lager_function.value.Fussbreite);
		}
	}
	
	if(message.fieldset.lager_rollenlager){
		if(message.fieldset.lager_rollenlager.show == true){
			Ext.getCmp("LAGER_ROLLENLAGER").show();	
			_setFieldSet_Rollenlager(message.fieldset.lager_rollenlager);
		}
		else
			Ext.getCmp("LAGER_ROLLENLAGER").hide();			
	}
	
	if(message.fieldset.lager_sattel){
		if(message.fieldset.lager_sattel.show == true){
			Ext.getCmp("LAGER_ROLLEN_SATTEL").show();	
			_setFieldSet_Sattel(message.fieldset.lager_sattel);
		}
		else{
			Ext.getCmp("LAGER_ROLLEN_SATTEL").hide();
			Ext.getCmp("LAGER_ROLLEN_SATTEL_BUTTON").enable();
		}	
	}
	
	if(message.resulttable){
		if(message.resulttable.store)
			oDialogStores.storeTable.loadData(message.resulttable.store);
		
		var oTable = Ext.getCmp("lager.auswahl_rollenlager_tabelle");
		if(message.resulttable.strPriceLabel)			
			oTable.colModel.setColumnHeader(10,message.resulttable.strPriceLabel);
		
		if(message.resulttable.strLastEditionLabel)
			oTable.colModel.setColumnHeader(5,message.resulttable.strLastEditionLabel);
		
		if(message.resulttable.Error)
			Cascade.base.Messages.Warning_Message(message.resulttable.Error);
		
		if(message.resulttable.sel){
			oTable.selModel.selectRow(message.resulttable.sel);
			Ext.getCmp('move-next').show();
		}
		
		oTable.setHeight(150);		
		oTable.getView().refresh();	
	}
	
	if(message.title)
		Ext.getCmp("lager.auswahl_rollenlager").setTitle(message.title);
		
	if(message.image){		
		//vorludig keine Bilder
		/*var oImagePanel = Ext.getCmp("LAGER_ROLLEN_PICTURE");
		
		if(Ext.getCmp("LAGER_ROLLEN_PICTURE_ADD")){
			Ext.getCmp("LAGER_ROLLEN_PICTURE_ADD").updateBox(message.image,true);
		}
		else{			
			var oImageForm = new Ext.Panel({
				layout	: 'form',
				border	: false,
				id		: 'LAGER_ROLLEN_PICTURE_ADD',
				style	: 'margin-left: 5px;',
				html	: message.image		
			});
			
			oImagePanel.add(oImageForm);
			oImagePanel.doLayout();
		}*/
	}	
	
	var strFunctionId = '';
	try{
		strFunctionId = message.fieldset.strfunction;	
	}
	catch(err){}
		
	Cascade.panel.lager.auswahl_rollenlager.setBlockEvent(false);
	Cascade.panel.lager.auswahl_rollenlager.setResetName(strFunctionId);	
}