Ext.namespace('Cascade.panel.lager');
Cascade.panel.lager.auswahl_klemmsystem_setGuiValue = function(strId,message){
	Cascade.panel.lager.auswahl_klemmsystem.setBlockEvent(true);
	var oComboStores = Cascade.panel.lager.auswahl_klemmsystem.getStore();
	
	/**
	 * @private load store data (combo / table Store)
	 */
	_loadStore = function(store,data){
		store.loadData(data);
	};
	
	/**
	 * @private set components values
	 */
	_setValue = function(strCompId,strValue){
		Ext.getCmp(strCompId).setValue(strValue);
	};
	
	/**
	 * @private set disable/enable component
	 */
	_setDisabled = function(strCompId,bValue){
		if(bValue)
			Ext.getCmp(strCompId).disable();
		else
			Ext.getCmp(strCompId).enable();	
	};
	
	/**
	 * @private set hide/show component
	 */
	_setHide = function(strCompId,bValue){
		if(bValue)
			Ext.getCmp(strCompId).hide();
		else
			Ext.getCmp(strCompId).show();	
	};
	
	/**
	 * @private function
	 */	
	var _setValueRadio = function(strValue){	
		Ext.getCmp(strValue).suspendEvents(false);			
		Ext.getCmp(strValue).setValue(true);			
		Ext.getCmp(strValue).resumeEvents();	
	}
	
	if(message.TraegerField){
		if(message.TraegerField.disabled){
			_setDisabled(strId+"_TRAEGER_FLANSCHDICKE",message.TraegerField.disabled.disFDicke);
			_setDisabled(strId+"_TRAEGER_BREITE",message.TraegerField.disabled.disBreite);
			_setDisabled(strId+"_TRAEGER_HOEHE",message.TraegerField.disabled.disHoehe);
			_setDisabled(strId+"_TRAEGER_ART",message.TraegerField.disabled.disTArt);
			_setDisabled(strId+"_TRAEGER_GROESSE",message.TraegerField.disabled.disTGroesse);	
		}
		
		if(message.TraegerField.store){
			if(message.TraegerField.store.storeTArt)
				_loadStore(oComboStores.storeTraegerArt,message.TraegerField.store.storeTArt);
			if(message.TraegerField.store.storeTGroesse)	
				_loadStore(oComboStores.storeTraegerGroesse,message.TraegerField.store.storeTGroesse);
		}
		
		if(message.TraegerField.value){
			_setValue(strId+"_TRAEGER_FLANSCHDICKE",message.TraegerField.value.vFDicke);
			_setValue(strId+"_TRAEGER_BREITE",message.TraegerField.value.vBreite);
			_setValue(strId+"_TRAEGER_HOEHE",message.TraegerField.value.vHoehe);
			_setValue(strId+"_TRAEGER_ART",message.TraegerField.value.vTArt);
			_setValue(strId+"_TRAEGER_GROESSE",message.TraegerField.value.vTGroesse);	
		}
	}
	
	if(message.FunctionField){
		if(message.FunctionField.checkbox){
			for(var a=0;a<message.FunctionField.checkbox.length;a++){
				var aPart = message.FunctionField.checkbox[a];
				_setValue(strId+"_FUNCTION_"+aPart[0],aPart[1]);
			}
		}
		
		if(message.FunctionField.combo){
			for(var a=0;a<message.FunctionField.combo.length;a++){
				var aPart = message.FunctionField.combo[a];
				_loadStore(oComboStores[aPart[2]],aPart[0]);
				_setValue(strId+"_"+aPart[3],aPart[1]);
			}
		}
		
		if(message.FunctionField.disabled){
			for(var a=0;a<message.FunctionField.disabled.length;a++){
				var aPart = message.FunctionField.disabled[a];
				_setDisabled(strId+"_FUNCTION_"+aPart[0],aPart[1]);
			}
		}
		
		if(message.FunctionField.hide){
			for(var a=0;a<message.FunctionField.hide.length;a++){
				var aPart = message.FunctionField.hide[a];
				_setHide(strId+"_FUNCTION_"+aPart[0],aPart[1]);
			}
		}
		
		if(message.FunctionField.value){
			for(var i=0;i<message.FunctionField.value.length;i++){		
				_setValueRadio("LAGER_KLEMMSYSTEM_FUNCTION_ABHEBESICHERUNG_"+message.FunctionField.value[i]);
			}
		}
		
		if(message.FunctionField.valueNumberfield){
			for(var i=0;i<message.FunctionField.valueNumberfield.length;i++){		
				var aPart = message.FunctionField.valueNumberfield[i];
				Ext.getCmp(aPart[0]).setValue(aPart[1]);				
			}
		}
	}
	
	if(message.image){
		//Ext.getCmp( strId+"_PICTURE" ).body.update( '<img src="' + message.image + '" />' );
	}
	
	if(message.Table){
		var oTable = Ext.getCmp("lager.auswahl_klemmsystem_tabelle");
		
		if(message.Table.store)
			_loadStore(oComboStores.storeTable,message.Table.store);
		
		if(message.Table.Header){
			for(var a=0;a<message.Table.Header.length;a++){
				var aPart = message.Table.Header[a];
				oTable.colModel.setColumnHeader(aPart[0],aPart[1]);
			}
		}
		
		if(message.Table.sel)
			oTable.selModel.selectRow(message.Table.sel);
		
		if(message.Table.Error)
			Cascade.base.Messages.Warning_Message(message.Table.Error);
		
		oTable.getView().refresh();	
	}
	
	if(message.hide){
		for(var a=0;a<message.hide.length;a++){
			var aPart = message.hide[a];
			_setHide(aPart[0],aPart[1]);
			
			if(aPart[0] == 'LAGER_KLEMMSYSTEM_SONST_BREITE_FORM' && aPart[1] == false){
				Ext.getCmp('LAGER_KLEMMSYSTEM_FUNCTION').setWidth(410);
				Ext.getCmp('LAGER_KLEMMSYSTEM_FUNCTION_ZUSATZFUNKTIONS').setWidth(385);
			}
			else if(aPart[0] == 'LAGER_KLEMMSYSTEM_SONST_BREITE_FORM' && aPart[1] == true){
				Ext.getCmp('LAGER_KLEMMSYSTEM_FUNCTION').setWidth(235);
				Ext.getCmp('LAGER_KLEMMSYSTEM_FUNCTION_ZUSATZFUNKTIONS').setWidth(210);
			}			
		}
	}
	
	if(message.title)
		Ext.getCmp('lager.auswahl_klemmsystem').setTitle(message.title);
		
	//test ob Table Selektiert ist	
	var aTestSelectionTable = Cascade.panel.lager.auswahl_klemmsystem.getSelectionTable();
	if(aTestSelectionTable>0)
		Ext.getCmp('move-next').show();
	else
		Ext.getCmp('move-next').hide();
	
	Cascade.panel.lager.auswahl_klemmsystem.setBlockEvent(false);	
	Cascade.panel.lager.auswahl_klemmsystem.setResetName();	
}