/**
 * Cascade Clientseitige Logik
 * 
 * Copyright (c) 2008 Plan Software GmbH
 *
 * @category UI
 * @package    
 * @copyright  Copyright (c) 2008 Plan Software GmbH (http://www.plansoft.de)
 */
 
Cascade.panel.klemmsystem_auswahl = function() 
{
	// Basisform
	var _form;
	// Tabelle fr Resultate eines Suchvorganges
	var _table;
	// Daten fr die Combobox 'Lagerfunktion'
	var _storeLagerfunktion;
	// Daten fr die Combobx 'Breite des Lagerfusses'
	var _storeLagerfussbreite;
	// Daten fr die Combobox 'Profilart'
	var _storeProfilart;
	// Daten fr die Combobox 'Trgergre'
	var _storeTraegergroesse;
	// Meldungstexte
	var _meldungen;
	// wenn dieser Wert true ist, werden 'check' events fr Checkboxen nicht verarbeitet (diese werden jedesmal abgesetzt, wenn 
	// der Wert der Checkbox gendert wird, egal, ob durch einen Klick oder durch Setzen im Script
	var _bCheckboxHandlerNichtAktivieren;
    
	/**
	 * setze die mglichen Profilarten
	 *
	 * @params object response: Resultat der Datenabfrage (UI-Variablen, Daten)
	 * @returns	-
	 */
	function _setzeProfilarten( response )
	{
		var cbProfilarten = _form.getForm().findField( 'IDC_PROFILART' );
		var newStore = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data: response.data.profilarten
		} );
		cbProfilarten.bindStore( newStore );
		cbProfilarten.setValue( response.data.IDC_PROFILART );
	}
	
	/**
	 * setze die mglichen Trgergren
	 *
	 * @params object response: Resultat der Datenabfrage (UI-Variablen, Daten)
	 * @returns	-
	 */
	function _setzeTraegergroessen( response )
	{
		var cbTraegergroessen = _form.getForm().findField( 'IDC_TRAEGERGROESSE' );
		var newStore = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data: response.data.traegergroessen
		} );
		cbTraegergroessen.bindStore( newStore );
		cbTraegergroessen.setValue( response.data.IDC_TRAEGERGROESSE );
	}
	
	/**
	 * setze die Trgerdaten fr die aktuelle Trgergre, also Trgerhhe, Trgerbreite und Flanschdicke
	 * sie werden nach einem Submit nicht automatisch neu gesetzt; ein neues 'load' spare ich mir besser
	 *
	 * @params object response: Resultat der Datenabfrage (UI-Variablen, Daten)
	 * @returns	-
	 */
	function _setzeTraegerdaten( response )
	{
		var f = _form.getForm();
		f.findField( 'IDC_TRAEGERHOEHE' ).setValue( response.data.IDC_TRAEGERHOEHE );
		f.findField( 'IDC_TRAEGERBREITE' ).setValue( response.data.IDC_TRAEGERBREITE );
		f.findField( 'IDC_FLANSCHDICKE' ).setValue( response.data.IDC_FLANSCHDICKE );
	}
	
	/**
     * initialisiere die Datenstrukturen fr die Comboboxen
	 *
	 * @params -
	 * @returns	-
	 */
	function _initStaticData()
	{
		// Daten fr die Combobox 'Lagerart'
		_storeLagerfunktion = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				[ 'ID_FUEHRUNGSLAGER', '$ID_FUEHRUNGSLAGER$' ],
				[ 'ID_LOSLAGER', '$ID_LOSLAGER$' ]
			]
		} );
		// Daten fr die Combobx 'Breite des Lagerfusses'
		_storeLagerfussbreite = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : 
			[
				[ 'ID_B080', '$ID_B080$' ],
				[ 'ID_B100', '$ID_B100$' ],
				[ 'ID_B175', '$ID_B175$' ],
				[ 'ID_B190', '$ID_B190$' ],
				[ 'ID_B210', '$ID_B210$' ],
				[ 'ID_B250', '$ID_B250$' ],
				[ 'ID_B280', '$ID_B280$' ],
				[ 'ID_B290', '$ID_B290$' ],
				[ 'ID_B320', '$ID_B320$' ],
				[ 'ID_B340', '$ID_B340$' ]
			]
		} );
		// Daten fr die Combobox 'Profilart'
		_storeProfilart = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
		// Daten fr die Combobox 'Trgergre'
		_storeTraegergroesse = new Ext.data.SimpleStore(
		{
			fields: ['value', 'text'],
			data : []
		} );
	}
		
	
	/**
	 * anzeigen/verstecken der Combobox (und des Labels!) fr die Breite des Lagerfusses
	 *
	 * @params boolean bShow: true - anzeigen, false - verstecken
	 * @returns	-
	 */
	function _showBreiteLagerfuss( bShow )
	{
		var cbLagerfuss = _form.getForm().findField( 'IDC_LAGERFUSSBREITE' );
		if ( bShow )
		{
			// show combo and label
			cbLagerfuss.show();
			cbLagerfuss.getEl().up( 'div.x-form-element' ).prev( 'label' ).show();
		}
		else
		{
			// hide combo and label
			cbLagerfuss.hide();
			cbLagerfuss.getEl().up( 'div.x-form-element' ).prev( 'label' ).hide();
		}
	}
	
	/**
	 * worker handler, wenn der Benutzer die Lagerfunktion gewechselt hat
	 * alle Abhngigkeiten der sonstigen Werte werden neu gesetzt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onChangedLagerfunktion()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var cbLagerfunktion = f.findField( 'IDC_LAGERFUNKTION' );
		var strProfilart = f.findField( 'IDC_PROFILART' ).getValue();
		var bIsGleitunterlage = f.findField( 'IDC_GLEITUNTERLAGE_K' ).getValue();
		var checkAbhebesicherung = f.findField( 'IDC_ABHEBESICHERUNG_K' );
		var checkAbhebesicherung4fach = f.findField( 'IDC_ABHEBESICHERUNG4FACH' );

		// Mglichkeiten fr Lagerfunktion
		if ( !bIsGleitunterlage )
		{
			// ohne Gleitunterlage sind nur Fhrungslager mglich
			cbLagerfunktion.setValue( 'ID_FUEHRUNGSLAGER' );
			checkAbhebesicherung4fach.disable();
		}
		
		// Combobox 'Breite Lagerfu' nur sichtbar bei Gleitunterlage
		_showBreiteLagerfuss( bIsGleitunterlage );		

		// setze enabled/disabled fr Abhebesicherung und Abhebesicherung 4-fach
		var strLagerfunktion = cbLagerfunktion.getValue();
		if ( strLagerfunktion == 'ID_LOSLAGER' )
		{
			checkAbhebesicherung.setValue( false );
			checkAbhebesicherung.disable();
			checkAbhebesicherung4fach.setValue( false );
			checkAbhebesicherung4fach.disable();
		}
		else checkAbhebesicherung.enable();
		if ( !checkAbhebesicherung.getValue() || ( strProfilart== 'U_PROFIL' ) || ( strProfilart == 'L_PROFIL_G' ) || ( strProfilart == 'L_PROFIL_U' ) )
		{
			checkAbhebesicherung4fach.setValue( false );
			checkAbhebesicherung4fach.disable();
		}
		else
		{
			checkAbhebesicherung4fach.enable();
			if ( bIsGleitunterlage )
				checkAbhebesicherung4fach.setValue( true );
		}
		
		// setze das Bild
		_setzeBild();
		
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * worker handler, wenn der Benutzer die Abhebesicherung gewechselt hat
	 * alle Abhngigkeiten der sonstigen Werte werden neu gesetzt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onClickedAbhebesicherung()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var strProfilart = f.findField( 'IDC_PROFILART' ).getValue();
		var bIsGleitunterlage = f.findField( 'IDC_GLEITUNTERLAGE_K' ).getValue();
		var checkAbhebesicherung = f.findField( 'IDC_ABHEBESICHERUNG_K' );
		var checkAbhebesicherung4fach = f.findField( 'IDC_ABHEBESICHERUNG4FACH' );

		// Vernderungen bei 'Abhebesicherung 4-fach' berechnen
		if ( !checkAbhebesicherung.getValue() || ( strProfilart == 'U_PROFIL' ) || ( strProfilart == 'L_PROFIL_G' ) || ( strProfilart == 'L_PROFIL_U' ) )
		{
			checkAbhebesicherung4fach.setValue( false );
			checkAbhebesicherung4fach.disable();
		}
		else
		{
			checkAbhebesicherung4fach.enable();
			if ( bIsGleitunterlage )
				checkAbhebesicherung4fach.setValue( true );
		}
		
		// Bild neu setzen
		_setzeBild();
		
		_bCheckboxHandlerNichtAktivieren = false;
	}
				
	/**
	 * worker handler, wenn der Benutzer die Abhebesicherung 4-fach gewechselt hat
	 * alle Abhngigkeiten der sonstigen Werte werden neu gesetzt
	 *
	 * @params -
	 * @returns	-
	 */
	function _onClickedGleitunterlage()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		var f = _form.getForm();
		var bIsGleitunterlage = f.findField( 'IDC_GLEITUNTERLAGE_K' ).getValue();
		var checkAbhebesicherung = f.findField( 'IDC_ABHEBESICHERUNG_K' );
		var checkAbhebesicherung4fach = f.findField( 'IDC_ABHEBESICHERUNG4FACH' );
		
		if ( !bIsGleitunterlage )
		{
			// ohne Gleitunterlage sind nur Fhrungslager mglich
			f.findField( 'IDC_LAGERFUNKTION' ).setValue( 'ID_FUEHRUNGSLAGER' );
			checkAbhebesicherung.enable();
			checkAbhebesicherung4fach.enable();
			if ( !checkAbhebesicherung.getValue() )
			{
				checkAbhebesicherung4fach.setValue( false );
				checkAbhebesicherung4fach.disable();
			}
		}
		else
		{
			if ( checkAbhebesicherung.getValue() )
			{
				var strProfilart = f.findField( 'IDC_PROFILART' ).getValue();
				
				if ( ( strProfilart == 'U_PROFIL' ) || ( strProfilart == 'L_PROFIL_G' ) || ( strProfilart == 'L_PROFIL_U' ) )
				{
					checkAbhebesicherung4fach.setValue( false );
					checkAbhebesicherung4fach.disable();
				}
				else 
				{
					checkAbhebesicherung4fach.setValue( true );
					checkAbhebesicherung4fach.enable();
				}
			}
		}
		
		// Combobox 'Breite Lagerfu' nur sichtbar bei Gleitunterlage
		_showBreiteLagerfuss( bIsGleitunterlage );		

		// Bild neu setzen
		_setzeBild();
		
		_bCheckboxHandlerNichtAktivieren = false;
	}
						
	/**
	 * wird aufgerufen, wenn der Suchvorgang erfolgreich beendet wurde
	 *
	 * @params object response: Resultat des Suchvorgangs (gefundene Klemmsystem, evtl Suchmeldung etc.)
	 * @returns	-
	 */
	function _updateSuchresultate( response )
	{
		if ( response.success )
			_table.getStore().load();			
		else _resetTable();
		if ( response.data.strMeldung )
			Ext.Msg.alert( _meldungen.msgTitel, response.data.strMeldung );
	}	
	
	/**
	 * lscht alle Zeilen in der Tabelle
	 *
	 * @params -
	 * @returns	-
	 */
	function _resetTable()
	{
		_table.store.removeAll();
	}
	
	/**
	 * hole den Index der aktuell gewhlten Zeile in der Klemmsystemtabelle
	 *
	 * @params -
	 * @returns	integer - Index der aktuell gewhlten Zeile, 
	 *                    -1, wenn kein Lager gewhlt ist
	 */
	 function _holeKlemmsystemIndex()
	 {
		var rcSelected = _table.getSelectionModel().getSelected();
		var nIndex = -1;
		if ( rcSelected )
			nIndex = rcSelected.id - 1;
			
		return( nIndex );
	 }

	/**
	 * setze bersichtsbild fr aktuelles Klemmsystem
	 *
	 * @params -
	 * @returns	-
	 */
	function _setzeBild()
	{
		_bCheckboxHandlerNichtAktivieren = true;
		
		// Shortcuts fr einige Variablen im Panel
		var f = _form.getForm();
		var strLagerfunktion = f.findField( 'IDC_LAGERFUNKTION' ).getValue();
		var strProfilart = f.findField( 'IDC_PROFILART' ).getValue();
		var bIsGleitunterlage = f.findField( 'IDC_GLEITUNTERLAGE_K' ).getValue();
		var bIsAbhebesicherung = f.findField( 'IDC_ABHEBESICHERUNG_K' ).getValue();
		var bIsAbhebesicherung4fach = f.findField( 'IDC_ABHEBESICHERUNG4FACH' ).getValue();
		var cbTraegergroesse = f.findField( 'IDC_TRAEGERGROESSE' );
		var nIndexTraegergroesse = cbTraegergroesse.store.find( cbTraegergroesse.valueField, cbTraegergroesse.getValue() );
		
		var strBild = 'blank.gif';

		// wenn keine Gleitunterlage: die Bilder sind fr alle Lagerfunktionen gleich
		if ( !bIsGleitunterlage )
		{
			// bei U- und L-Profilen
			if ( ( strProfilart == 'U_PROFIL' ) || ( strProfilart == 'L_PROFIL_G' ) || ( strProfilart == 'L_PROFIL_U' ) )
			{
				if ( strProfilart == 'U_PROFIL' )
				{
					if ( bIsAbhebesicherung )
						strBild = 'B_KZU20.jpg';
					else strBild = 'B_KOU20.jpg';
				}
				else
				{
					if ( bIsAbhebesicherung )
						strBild = 'B_KZL20.jpg';
					else strBild = 'B_KOL20.jpg';
				}
			}
			else
			{
				if ( bIsAbhebesicherung )
				{
					if ( bIsAbhebesicherung4fach )
						strBild = 'B_KAT20.jpg';
					else strBild = 'B_KZT20.jpg';
				}
				else strBild = 'B_KOT20.jpg';
			}
		}
		else
        {
			// wenn Gleitunterlage gewhlt
        	if ( strLagerfunktion == 'ID_FUEHRUNGSLAGER' )
       	  	{
				// bei U- und L-Profilen fr Fhrungslager
         		if ( ( strProfilart == 'U_PROFIL' ) || ( strProfilart == 'L_PROFIL_G' ) || ( strProfilart == 'L_PROFIL_U' ) )
				{
					if ( strProfilart == 'U_PROFIL' )
					{
						if ( bIsAbhebesicherung )
							strBild = 'B_KZU40.jpg';
						else strBild = 'B_KOU40.jpg';
					}
					else
					{
						if ( bIsAbhebesicherung )
							strBild = 'B_KZL40.jpg';
                        else strBild = 'B_KOL40.jpg';
					}
				}
				else
				{
                	if ( nIndexTraegergroesse <= 0 )    // T-Profile, Defaultwert
					{
						if ( bIsAbhebesicherung )
						{
							if ( bIsAbhebesicherung4fach )
								strBild = 'B_KAT40_1.jpg';
							else strBild = 'B_KZT40_1.jpg';
						}
			       		else strBild = 'B_KOT40_1.jpg';
                    }
                    else
                    {
						if ( bIsAbhebesicherung )
						{
							if ( bIsAbhebesicherung4fach )
								strBild = 'B_KAT40_2.jpg';
							else strBild = 'B_KZT40_2.jpg';
						}
			       		else strBild = 'B_KOT40_2.jpg';
					}
				}
			}
            else
            {
				// bei U- und L-Profilen fr Loslager
         		if ( ( strProfilart == 'U_PROFIL' ) || ( strProfilart == 'L_PROFIL_G' ) || ( strProfilart == 'L_PROFIL_U' ) )
				{
					if ( strProfilart == 'U_PROFIL' )
						strBild = 'B_KLU40.jpg';
					else strBild = 'B_KLL40.jpg';
				}
				else
				{
                   	if ( nIndexTraegergroesse <= 0 )     // T-Profile, Defaultwert
						strBild = 'B_KLT40_1.jpg';
                    else strBild = 'B_KLT40_2.jpg';
				}
			}
		}

		// setze Bild
		var strFile = 'catalog/client/custom/img/WITgifs/RH/' + 'Var1_' + strBild;
		Ext.getCmp( 'IDC_KLEMMSYSTEM_IMAGE' ).body.update( '<img src="' + strFile + '" />' );
		
		_bCheckboxHandlerNichtAktivieren = false;
	}

	/**
	 * zustzliche Werte, die bei der Initialisierung vom Server bergeben und beim Bearbeiten der Produktlogik gebraucht werden,
	 * werden hier in private Variablen gespeichert
	 *
	 * @params object response: Resultat des Initialisierungsvorgangs (UI-Variablen, Betriebsbedingungen, Meldungen)
	 * @returns	-
	 */
	function _transferToInternalData( response )
	{
		// Meldungstexte
		_meldungen = 
		{
			msgSuche : response.data.msgSuche,
			msgTitel : response.data.msgTitel
		};
	}
	
	// public functions
	return {
		init: function( idx )
		{				
			// wenn noch kein Dialog erzeugt wurde - erster Aufruf der Funktion - mu das Panel erst erzeugt und in 
			// die bestehenden UI-Strukturen eingefgt werden
			if ( !_form ) 
			{				
				_bCheckboxHandlerNichtAktivieren = true;
				
				// private Daten fr Comboboxen etc. initialisieren
				_initStaticData();
				
				// erzeuge Tabelle fr Suchresultate Klemmsysteme
				_table = new Ext.grid.GridPanel(
				{
					id: 'klemmsystem_tabelle',
					store: new Ext.data.Store(
					{
						proxy: new Ext.data.HttpProxy(
						{
							url: 'klemmsystem_auswahl/hole_klemmsystemliste',
							success: function( response, options )
							{
								//_resetTable();
							}
						} ),
						reader: new Ext.data.JsonReader(
						{
							root: 'rows',
							id: 'id'
						},
						[
							{ name: 'typ' },
							{ name: 'abhebelast_fz' },
							{ name: 'querlast_fx' },
							{ name: 'klemmspalt_t' },
							{ name: 'gewicht' },
							{ name: 'preis' }
						] )
					} ),
					
					columns: [
						{ 	
							// Typ
							header: '$TCH_TYP$', 
							width: 150, 
							sortable: true, 
							dataIndex: 'typ'
						},
						{ 
							// Abhebelast Fz
							header: '$TCH_ABHEBELAST$', 
							width: 110, 
							sortable: true,
							dataIndex: 'abhebelast_fz' 
						},
						{ 
							// Querlast Fx
							header: '$TCH_QUERLAST$', 
							width: 110, 
							sortable: true,
							dataIndex: 'querlast_fx' 
						},
						{ 
							// Klemmspalt t
							header: '$TCH_KLEMMSPALT$', 
							width: 100, 
							sortable: true,
							dataIndex: 'klemmspalt_t' 
						},
						{ 
							// Gewicht
							header: '$TCH_GEWICHT$', 
							width: 100, 
							sortable: true,
							dataIndex: 'gewicht' 
						},
						{ 
							// Preis
							header: '$*.TMP.HEADER.TCH_PREIS$', 
							width: 100, 
							sortable: true,
							dataIndex: 'preis' 
						}
					],
					sm: new Ext.grid.RowSelectionModel( { singleSelect: true} ),										
					width: 680,
					height: 130,
					frame: false,
					border: false,
					title: '',
					header: false
				} );
				
				// erzeuge Panel
				_form = new Ext.FormPanel( 
				{
					url:'klemmsystem_auswahl/set-values',
					title: '$IDC_AUSWAHL_KLEMMSYS_LABEL$',
					id: 'klemmsystem_auswahl',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.KLEMMSYSTEM_AUSWAHL' },
					listeners: 
					{
						'actioncomplete': this.onActionComplete,
						'beforeaction': this.onBeforeAction
					},
					
					labelAlign: 'top',
					labelStyle: 'font-size:11px',
					bodyStyle:'padding:0 5px 0',
					frame: true,
					
					items: [ 
					{						
						layout: 'column',
						items: [
						{
							width: 170,
							layout: 'form',
							
							items: [
							{
								xtype: 'combo',
								hiddenName:'IDC_LAGERFUNKTION',
								fieldLabel: '$IDC_LAGERART_LABEL$',
								labelWidth: 180,
								store: _storeLagerfunktion,
								listeners: {
									'select' : this.onChangedLagerfunktion 
								},
								displayField: 'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 130,
                                listWidth: 130,
								editable: false
							},
							{
								xtype: 'fieldset',
								//autoHeight: true,
								height: 160,
								autoWidth: true,
								//width: 200,
								hideLabels: false,
								title: '$IDC_ZUSATZFUNKTIONEN_LABEL$',
								defaultType: 'checkbox',
								items: [
								{
									id:'IDC_ABHEBESICHERUNG_K',
									inputValue: 'true',
									labelSeparator: '',
									hideLabel: true,
									autoWidth: true,
									boxLabel:'$IDC_ABHEBESICHERUNG_LABEL$',
									listeners: {
										'check' : this.onCheckAbhebesicherung
									}
								},
								{
									id:'IDC_ABHEBESICHERUNG4FACH',
									inputValue: 'true',
									labelSeparator: '',
									hideLabel: true,
									//autoWidth: true,
									width: 220,
									boxLabel:'$IDC_ABHEBESICHERUNG_4X_LABEL$',
									listeners: {
										'check' : this.onCheckAbhebesicherung4fach
									}
								},
								{
									id:'IDC_GLEITUNTERLAGE_K',
									inputValue: 'true',
									labelSeparator: '',
									hideLabel: true,
									//autoWidth: true,
									width: 220,
									boxLabel:'$IDC_GLEITUNTERLAGE_LABEL$',
									listeners: {
										'check' : this.onCheckGleitunterlage 
									}
								},
								{
									xtype: 'combo',
									hiddenName: 'IDC_LAGERFUSSBREITE',
									fieldLabel: '$IDC_LAGERFUSSBREITE_LABEL$',
									labelSeparator: ':',
									labelWidth: 200,
									store: _storeLagerfussbreite,
									listeners: {
										'select' : this.onChangedLagerfussbreite
									},
									displayField: 'text',
									valueField: 'value',
									mode: 'local',
									triggerAction: 'all',
									selectOnFocus: true,
									forceSelection: true,
									width: 75,
									listWidth: 75,
									editable: false
								} ]
							},
							{
								xtype: 'button',
								minWidth: 130,
								style: 'margin-left:10px;margin-top:7px;margin-bottom:15px;',
								text: '$IDC_SUCHEN_BUT$',
								handler: function() 
								{
									_form.getForm().submit(
									{
										url : 'klemmsystem-auswahl/suche_klemmsysteme',
										success: function( response, options ) 
										{
											_updateSuchresultate( options.result );
										},
										failure: function( response, options ) 
										{
											_updateSuchresultate( options.result );
										}
									} );
								}
							} ]
						},
						{
							//width: 200, 
							layout: 'form',
							style: 'margin-left: 50px',
							items: [
							{
								xtype: 'combo',
								hiddenName:'IDC_PROFILART',
								fieldLabel: '$IDC_PROFILART_RH_LABEL$',
								labelWidth: 180,
								store: _storeProfilart,
								listeners: {
									'select' : this.onChangedProfilart 
								},
								displayField: 'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 130,
								listWidth: 130,
								editable: false
							},
							{
								xtype: 'combo',
								hiddenName:'IDC_TRAEGERGROESSE',
								fieldLabel: '$IDC_TRAEGERGROESSE_LABEL$',
								style: 'margin-bottom:15px',
								labelWidth: 160,
								store: _storeTraegergroesse,
								listeners: {
									'select' : this.onChangedTraegergroesse
								},
								displayField:'text',
								valueField: 'value',
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								forceSelection: true,
								width: 80,
								listWidth: 80,
								editable: false
							},
							{
								layout: 'column',
								items: [
								{
									layout: 'form',
									width: 140,
									items: [								
									{
										xtype:'numberfield',
										id: 'IDC_TRAEGERHOEHE',
										fieldLabel: '$IDC_TRAEGERHOEHE_LABEL$',
										width: 80,
										disabled: true,
										name: 'IDC_TRAEGERHOEHE'
									} ]
								},
								{
									layout: 'form',
									width: 140,
									items: [								
									{
										xtype:'numberfield',
										id: 'IDC_TRAEGERBREITE',
										fieldLabel: '$IDC_TRAEGERBREITE_LABEL$',
										width: 80,
										disabled: true,
										name: 'IDC_TRAEGERBREITE'
									} ]
								} ]
							},
							{
								xtype:'numberfield',
								id: 'IDC_FLANSCHDICKE',
								fieldLabel: '$IDC_FLANSCHDICKE_LABEL$',
								width: 80,
								disabled: true,
								name: 'IDC_FLANSCHDICKE'
							} ]
						},
						{
							xtype: 'panel',
							id: 'IDC_KLEMMSYSTEM_IMAGE',
							style: "margin-left: 5px; margin-top:7px",
							html: '<img src="catalog/client/custom/img/WITgifs/RH/blank.png" />'
						} ]
					},
					{
						layout: 'fit',
						width: 680,
						items: [ 
							_table,
							{
								xtype: 'hidden',
								id: 'IDC_KLEMMSYSTEM_TABLE_INDEX'
							} ]
					} ]
                } );
				
				// insert panel into main form
				var cp = Ext.getCmp( 'center-panel' );
				cp.insert( idx, _form );
				cp.doLayout();
				
				// insert labels
				Ext.DomHelper.insertAfter( 'IDC_TRAEGERHOEHE', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_TRAEGERBREITE', { tag:'span', html:'&nbsp;[mm]' } );
				Ext.DomHelper.insertAfter( 'IDC_FLANSCHDICKE', { tag:'span', html:'&nbsp;[mm]' } );				
				
				_bCheckboxHandlerNichtAktivieren = false;
			}
			
			_bCheckboxHandlerNichtAktivieren = true;
			_table.getStore().load();
			//_form.getForm().reset();
			_form.load( {
				url: 'klemmsystem-auswahl/get-values',
 				success: function( response, options ) 
				{
					_transferToInternalData( options.result );
                    _resetTable();
					_setzeProfilarten( options.result );
					_setzeTraegergroessen( options.result );
					_onChangedLagerfunktion();
				}
			} );
			
			Ext.getCmp( 'move-next' ).enable();
			_bCheckboxHandlerNichtAktivieren = false;
		},
				
		/**
		 * Event, wenn der Benutzer die Lagerfunktion gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedLagerfunktion: function( combo, record, idx )
		{
			_onChangedLagerfunktion();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Abhebesicherung angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckAbhebesicherung : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_ABHEBESICHERUNG_K' ).disabled )
				return;
			
			_onClickedAbhebesicherung();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Abhebesicherung 4-fach angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckAbhebesicherung4fach : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_ABHEBESICHERUNG4FACH' ).disabled )
				return;

			_onClickedAbhebesicherung();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Gleitunterlage angeclickt hat
		 *
		 * @params object clickedObject - checkbox, bei der der event aufgetreten ist
		 *         boolean bChecked - box gecheckt oder nicht gecheckt
		 * @returns	-
		 */
		onCheckGleitunterlage : function( clickedObject, bChecked )
		{
			// zum Unterdrcken von CheckEvents, wenn der Wert durch ein Script gesetzt wird
			if ( _bCheckboxHandlerNichtAktivieren || _form.getForm().findField( 'IDC_GLEITUNTERLAGE_K' ).disabled )
				return;

			_onClickedGleitunterlage();
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Lagerfubreite gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedLagerfussbreite: function( combo, record, idx )
		{
			_resetTable();
		},
		
		/**
		 * Event, wenn der Benutzer die Profilart gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedProfilart: function( combo, record, idx )
		{
			_resetTable();
			
			// hole neue Trgergrssen, Trgerdaten und den aktuellen Lagertyp
			_form.getForm().submit(
			{
				url : 'klemmsystem-auswahl/hole-traegergroessen',
				success: function( response, options ) 	// wenn das Load ein Submit auslsen wrde, knnte man sich vieles sparen
				{
					_setzeTraegergroessen( options.result );
					_setzeTraegerdaten( options.result );
					_onChangedLagerfunktion();
				}
			} );
		},
		
		/**
		 * Event, wenn der Benutzer die Trgergre gewechselt hat
		 *
		 * @params object combo - combobox, bei der der event aufgetreten ist
		 *         object record - aktuelle ausgewhlter record
		 *         integer idx - Index des aktuell ausgewhlten Records
		 * @returns	-
		 */
		onChangedTraegergroesse: function( combo, record, idx )
		{
			_resetTable();
			
			// hole neue Trgerdaten fr die aktuelle Trgergre und den aktuellen Lagertyp
			_form.getForm().submit(
			{
				url : 'klemmsystem-auswahl/hole-traegerdaten',
				success: function( response, options )	// wenn das Load ein Submit auslsen wrde, knnte man sich vieles sparen
				{
					_setzeTraegerdaten( options.result );
					_setzeBild();
				}
			} );
		},
		
		/**
		 * Event, wenn ein Ajax-Request vollstndig bearbeitet ist
		 *
		 * @params object form: die aktuelle Form
		 *         object action: aktionsobject fr diesen Event
		 * @returns	-
		 */
        onActionComplete : function( form, action ) 
		{
			// das Panel soll nur dann gewechselt werden, wenn der Submit wegen Click des 'next' Buttons erfolgt ist
			if ( action.options.url == form.url )
			{
				// teste, ob berhaupt ein Lager gesucht und ausgewhlt wurde
				var store = _table.getStore();
				if ( ( store.getCount() > 0 ) && _table.getSelectionModel().getSelected() )
					Cascade.app.getNextPanel( form, action );
			}
		},
		
		/**
		 * Event, der aufgerufen wird, bevor ein Ajax-Request ausgelst wird
		 *
		 * @params object form: die aktuelle Form
		 *         object action: aktionsobject fr diesen Event
		 * @returns	-
		 */
		onBeforeAction : function( form, action ) 
		{
			if ( action.type == "submit"  ) 
			{
				var store = _table.getStore();
				
				// der Submit wegen Click des 'next' Buttons soll nur dann erfolgen, wenn ein Lager aus einer Klemmsystemliste gewhlt ist
				if ( action.options.url == form.url )
				{
					// teste, ob berhaupt ein Klemmsystem gesucht und ausgewhlt wurde
					if ( ( store.getCount() <= 0 ) || !_table.getSelectionModel().getSelected() )
					{
						Ext.Msg.alert( _meldungen.msgTitel, _meldungen.msgSuche );
						return( false );
					}
				}
				store.commitChanges();
				
				// hole Index der selektierten Zeile
				var nIndex = _holeKlemmsystemIndex();
				if ( nIndex == -1 )
					nIndex = 0;
				
				// setze Index als Inhalt einer hidden-field
                _form.getForm().findField( 'IDC_KLEMMSYSTEM_TABLE_INDEX' ).setValue( nIndex );				
			}
		}
	}
}();
