


/**
 * SAP Kundenauftrag Testfall per XMLHttpRequest starten
 *
 */
var ncount=null;
var myTimer;
function startSapKundenauftrag()
{
    var strEdit = $F('IDC_EDIT_KUNDENAUFTRAG_DATEI');
	new Ajax.Request('sap_rfc/start_kundenauftrag_testfall?strEdit='+strEdit, {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		}
	});
}

/**
 * SAP Auftragsstueckliste Testfall per XMLHttpRequest starten
 *
 */
function startSapAuftragsstueckliste()
{
    var strEdit = $F('IDC_EDIT_AUFTRAGSSTUECKLISTE_DATEI');
	new Ajax.Request('sap_rfc/start_auftragsstueckliste_testfall?strEdit='+strEdit, {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		}
	});
}

/**
 * SAP Kundenauftrge aus Projektliste per XMLHttpRequest starten
 *
 */
function startSapKundenauftragFromProjectlist()
{
	new Ajax.Request( 'sap_rfc/start_kundenauftrag_from_projectlist',{
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
		parameters: $('isycat').serialize()
	});
}

/**
 * SAP Auftragsstuecklisten aus Projektliste per XMLHttpRequest starten
 *
 */
function startSapZeichnungsuebergabeFromProjectlist()
{
	new Ajax.Request('sap_rfc/start_zeichnungsuebergabe_from_projectlist', {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
		parameters: $('isycat').serialize()
	});
}

/**
 * SAP Zeichnungsuebergabe aus Projektliste per XMLHttpRequest starten
 *
 */
function startSapAuftragsstuecklisteFromProjectlist()
{
	new Ajax.Request('sap_rfc/start_auftragsstueckliste_from_projectlist', {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
		parameters: $('isycat').serialize()
	});
}

/**
 * SAP Zeichnungsgenerierung aus Projektliste per XMLHttpRequest starten
 *
 */
function startSapZeichnungsgenerierungFromProjectlist()
{
	new Ajax.Request('three_d_cad_options/generate_multiple_drawings_for_sap', 
    {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
        autoAbort: true,
        timeout: 240000,
		parameters: $('isycat').serialize()
	});
    /*
	var transId = Ext.Ajax.request( 
    {
        url: 'three_d_cad_options/generate_multiple_drawings_for_sap',
		success: function(response, options) {
            var ng = Ext.decode( response.responseText );
			var msg = ng.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
        autoAbort: true,
        timeout: 1000,
		params: $('isycat').serialize()
	});
    */
    // alert(transId);
    
    Ext.Msg.wait("Starte CAD-Generierung", "Cad Generator");
    
    myTimer = setInterval (updateCadProgress, 10000);    
}

/**
 * Zeichnungsgenerierung fr CRM (MS Dynamics) aus Projektliste per XMLHttpRequest starten
 *
 */
function startCrmZeichnungsgenerierungFromProjectlist()
{
	if(!ncount)
	{
		ncount = 1;
		Ext.Ajax.request( 
		{
			url: 'three_d_cad_options/generate_multiple_drawings_for_crm',
			success: function(response, options) {
				var ng = Ext.decode( response.responseText );
				var msg = ng.message;
				
				// Wenn nur Rohrhalterungen Freipositionen in der Projektliste enthalten sind, wird kein CAD generiert
				// Dann komm der Server zu schnell zurck und der AJAX luft nicht ins failure
				// Deshalb wird hier die Fehlermeldung von Server abgefragt.
				if ( msg == "ERR_NO_POS_ROHRHALTERUNG" )
				{
					Ext.Msg.wait("Bitte warten...", "CRM Save");
					myTimer = setInterval (updateCadProgressCRM, 10000);    
				}
				ncount=null;
			},
			failure: function(response, options) {
				Ext.Msg.wait("Bitte warten...", "CRM Save");
				myTimer = setInterval (updateCadProgressCRM, 10000);    
				ncount=null;
			},
			timeout: 1000
		});
	}
}

/**
 * Freie Zeichnungsgenerierung aus Projektliste per XMLHttpRequest starten
 *
 */
 
function startFreeZeichnungsgenerierungFromProjectlist()
{
/*
	new Ajax.Request('three_d_cad_options/generate_multiple_drawings_free', 
    {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
        autoAbort: true,
        timeout: 240000,
		parameters: $('isycat').serialize()
	});
*/
	var transId = Ext.Ajax.request( 
    {
        url: 'three_d_cad_options/generate_multiple_drawings_free',
		success: function(response, options) {
            var ng = Ext.decode( response.responseText );
			var msg = ng.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
        autoAbort: true,
        timeout: 5000,	// mit zu kurzem timeout kommen die Fehlermeldungen nicht
		params: $('isycat').serialize()
	});
    
    // alert(transId);

    Ext.Msg.wait("Starte CAD-Generierung", "Cad Generator");
    
    myTimer = setInterval (updateCadProgress, 10000);    
    // entfernen mit: 		myTimer=clearInterval (myTimer);
}

function updateCadProgress()
{
	/*
	var transId = Ext.Ajax.request( 
    {
        url: 'three_d_cad_options/update_cad_progress',
		success: function(response, options) {
            var ng = Ext.decode( response.responseText );
			var msg = ng.message;
            var status = ng.status;
			
			if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                //alert( msg );
            }
			if (status == "MSG_CAD_FINISH")
            {
                myTimer = clearInterval (myTimer);
                Ext.Msg.hide();
            }
		},
		failure: function(response, options) {
			//Do nothing
		},
        autoAbort: true,
        timeout: 2000,	// mit zu kurzem timeout kommen die Fehlermeldungen nicht
		params: $('isycat').serialize()
	});
	*/
	
	new Ajax.Request('three_d_cad_options/update_cad_progress', 
    {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            var status = transport.responseJSON.status;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                Ext.Msg.updateText(msg);
                // alert( msg );
            }
            if (status == "MSG_CAD_FINISH")
            {
                myTimer = clearInterval (myTimer);
                Ext.Msg.hide();
            }
		},
		autoAbort: true,
		timeout: 1000,
		parameters: $('isycat').serialize()
	});
}

function updateCadProgressCRM()
{
	Ext.Ajax.request( 
    {
        url: 'three_d_cad_options/update_cad_progress',
		success: function(response, options) {
            var ng = Ext.decode( response.responseText );
			var msg = ng.message;
            var status = ng.status;
			
			if (status == "MSG_CAD_FINISH")
            {
				myTimer = clearInterval (myTimer);
				Ext.Msg.hide();
				
				//Jetzt noch Projektliste speichern
				var strVisibility=document.getElementById('CURRENCY_UNIT_CRM_VISIBILITY_CRM').value;
				var strCurrencyFaktor=document.getElementById('IDC_EDIT_CURRENCY_FACTOR_CRM').value;
	
				if(strVisibility == "visible" && strCurrencyFaktor == "")
				{
					var message=document.getElementById('IDC_ERROR_CRM_NO_CURRENCY_FAKTOR').value;
					alert(message);
				}
				else
					ekSubmit("IDC_SPEICHERN_BUT");
            }
			else
			{
				myTimer = clearInterval (myTimer);
				Ext.Msg.hide();
			}
		},
		failure: function(response, options) {
		
		},
        timeout: 5000	// mit zu kurzem timeout kommen die Fehlermeldungen nicht
	});
}

/**
 * Vorschau Kundenauftrag
 *
 */
function startSapVorschauFromProjectlist()
{
	new Ajax.Request('sap_rfc/start_sap_vorschau_from_projectlist', {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
		parameters: $('isycat').serialize()
	});
}

/**
 * Vorschau Auftragsstckliste
 *
 */
function startSapVorschauAstlFromProjectlist()
{
	new Ajax.Request('sap_rfc/start_sap_vorschau_astl_from_projectlist', {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
		parameters: $('isycat').serialize()
	});
}

/**
 * 
 *
 */
function startSapAlleRfcsFromProjectlist()
{
	new Ajax.Request('sap_rfc/start_sap_alle_rfcs_from_projectlist', {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
		parameters: $('isycat').serialize()
	});
}

/**
 * PDMS Export-Routine aus Projektliste per XMLHttpRequest starten
 *
 */
function schreibeSTKfileFromProjectlist()
{
	new Ajax.Request('index/write_stk_from_projectlist', {
		onComplete: function(transport) {
			var msg = transport.responseJSON.message;
            if ( msg )
            {
                msg = msg.replace(/\\n/g, "\n");
                alert( msg );
            }
		},
		parameters: $('isycat').serialize()
	});
}



