
function onDGLRchange(Typ)
{	
	//bestimme erforderliche Kategorie

	if(document.getElementById('IDC_DGRL_WARNUNG_INSTABIL') != null)
		document.getElementById('IDC_DGRL_WARNUNG_INSTABIL').style.visibility = 'hidden';
		
	var minKategorie = DGRL(Typ);

	if(Typ == 'MS')
	{
		document.getElementById('MIN_KATEGORIE').value = minKategorie;
		
		var strKategorie = "ID_GIP";
		
		if (minKategorie == -1)
			strKategorie = "ID_NODGRL";
		else if (minKategorie == 1)
			strKategorie = "ID_KATEGORIE_I";
		else if (minKategorie == 2)
			strKategorie = "ID_KATEGORIE_II";
		else if (minKategorie == 3)
			strKategorie = "ID_KATEGORIE_III";
			
		var x = document.getElementById(strKategorie+'_KURZ');
		if (x)
		{
			document.getElementById('IDC_RADIO_DGRL_RESULT').innerHTML = '(' + x.value + ')';
		    // ID_GIP, ID_KATEGORIE_I, ID_KATEGORIE_II, ID_KATEGORIE_III  jeweils + _KURZ und translate
		}
		else
			document.getElementById('IDC_RADIO_DGRL_RESULT').innerHTML = '';
		
		if(strKategorie == "ID_NODGRL")
		{
			document.getElementById('IDC_RADIO_DGRL_NEIN').checked = true;
			document.getElementById('IDC_RADIO_DGRL_JA').disabled = true;
		}
		else
		{
			document.getElementById('IDC_RADIO_DGRL_JA').disabled = false;
		}
		
		
		return;
	}
	else
	{
		document.getElementById('IDC_VORGABE_KATEGORIE_COMBO').selectedIndex = minKategorie;
	    setzePruefumfangTextDGRL(minKategorie);
	}
}

function onDGLRKategoriechange(Typ)
{
	var minKategorie = 0;
	
	if(Typ == 'MS_ERGAENZEN')
	{
		minKategorie = document.getElementById('MIN_KATEGORIE').value;
        componentDisable( 'IDC_FLUIDGRUPPE_COMBO' );
	    componentDisable( 'IDC_FLUIDZUSTAND_COMBO' );
	}
	else 
	{
		if(document.getElementById('IDC_DGRL_WARNUNG_INSTABIL') != null)
			document.getElementById('IDC_DGRL_WARNUNG_INSTABIL').style.visibility = 'hidden';
		minKategorie = DGRL();
	}
	
	var selindex = document.getElementById('IDC_VORGABE_KATEGORIE_COMBO').selectedIndex;
	if (selindex < minKategorie)
	{
		document.getElementById('IDC_VORGABE_KATEGORIE_COMBO').selectedIndex = minKategorie;
		setzePruefumfangTextDGRL(minKategorie);
	}
	else
	{
		if (minKategorie == 0)
		{
			document.getElementById('IDC_VORGABE_KATEGORIE_COMBO').selectedIndex = minKategorie;
			setzePruefumfangTextDGRL(minKategorie);
		}
		else
			setzePruefumfangTextDGRL(selindex);
	}
}


function DGRL(Typ)
{
	var Geraet = '';
	if ((Typ == 'MS') || (Typ == 'MS_ERGAENZEN'))
	       Geraet = 'ROHR';
	else
	{       
		if (document.getElementById('IDC_RADIO_ROHR').checked)
		   Geraet  = 'ROHR';	
		else
		   Geraet  = 'BEHAELTER';	
	}

	var Zustand = document.getElementById('IDC_FLUIDZUSTAND_COMBO').options[document.getElementById('IDC_FLUIDZUSTAND_COMBO').selectedIndex].value;
	var Gruppe  = document.getElementById('IDC_FLUIDGRUPPE_COMBO').options[document.getElementById('IDC_FLUIDGRUPPE_COMBO').selectedIndex].value;

	var DN = 0;
	var PS = 0;
	var V  = 0;
	
	if(Typ == 'MS')
	{
		var strDN	    = document.getElementById('IDC_NENNWEITE_COMBO').value;
		DN 		= strDN.replace('ID_','') - 0;
		PS	    = document.getElementById('IDC_BETRIEBSDRUCK').value - 0;
	}
	else
	{
		DN	    = document.getElementById('vorgabe_DN').value - 0;
		PS		= document.getElementById('vorgabe_PS').value - 0;
		V		= document.getElementById('IDC_VOLUMEN_EDIT').value - 0;
	}

	var Kategorie = 0;
	
	if (Geraet == 'BEHAELTER')
	{
		if (Zustand == 'ID_FLUIDZUSTAND_GASFOERMIG')
		{
			if (Gruppe == 'ID_FLUID_GRUPPE_GEFAEHRLICH') {
				Kategorie = Diagramm1(V, PS);
				var PSV = PS * V;
				// -mw- 2014-02-20: Anscheinend wird die Druck-Bedingung hier nicht gebraucht (Nach Liste Hr. Maschlanka von Ende Januar)
				// if ((PS >= 200) && (V > 1) && (PSV > 25) && ((Kategorie == 1) || (Kategorie == 2)))
				if ((V > 1) && (PSV > 25) && ((Kategorie == 1) || (Kategorie == 2)))
				{
					if(document.getElementById('IDC_DGRL_WARNUNG_INSTABIL') != null)
						document.getElementById('IDC_DGRL_WARNUNG_INSTABIL').style.visibility = 'visible';
				}
			}
			else	// UNGEFAEHRLICH
				Kategorie = Diagramm2(V, PS);
		}
		else	// FLUESSIG
		{
			if (Gruppe == 'ID_FLUID_GRUPPE_GEFAEHRLICH')
				Kategorie = Diagramm3(V, PS);
			else	// UNGEFAEHRLICH
				Kategorie = Diagramm4(V, PS);
		}
	}
	else	// ROHR
	{
		if (Zustand == 'ID_FLUIDZUSTAND_GASFOERMIG')
		{
			if (Gruppe == 'ID_FLUID_GRUPPE_GEFAEHRLICH') {
				Kategorie = Diagramm6(DN, PS);
				if ((DN >= 25) && ((Kategorie == 1) || (Kategorie == 2)))
				{
					if(document.getElementById('IDC_DGRL_WARNUNG_INSTABIL') != null)
						document.getElementById('IDC_DGRL_WARNUNG_INSTABIL').style.visibility = 'visible';
				}
			}
			else {	// UNGEFAEHRLICH
				Kategorie = Diagramm7(Typ, DN, PS);
			}
		}
		else	// FLUESSIG
		{
			if (Gruppe == 'ID_FLUID_GRUPPE_GEFAEHRLICH')
				Kategorie = Diagramm8(DN, PS);
			else	// UNGEFAEHRLICH
				Kategorie = Diagramm9(DN, PS);
		}
	}
	
	return (Kategorie);
}

function Diagramm1(V, PS)
{
	var PSV = V * PS;
	var Kategorie = 0;

	if (PS <= 200)
	{
		if (V <= 1.0)
			Kategorie = 0;
		else
		{
			if (PSV <= 25)
				Kategorie = 0;
			else if (PSV <= 50)
				Kategorie = 1;
			else if (PSV <= 200)
				Kategorie = 2;
			else if (PSV <= 1000)
				Kategorie = 3;
			else 
				Kategorie = 4;
		}
	}
	else if (PS <= 1000)
	{
		if (V <= 1.0)
			Kategorie = 3;
		else
		{
			if (PSV <= 1000)
				Kategorie = 3;
			else 
				Kategorie = 4;
		}
	}
	else
		Kategorie = 4;

	return Kategorie;
}

function Diagramm2(V, PS)
{
	var PSV = V * PS;
	var Kategorie = 0;

	if (PS <= 4)
	{
		if (PSV <= 50)
			Kategorie = 0;
		else if (PSV <= 200)
			Kategorie = 1;
		else if (PSV <= 1000)
			Kategorie = 2;
		else 
			Kategorie = 4;
	}
	else if (PS <= 1000)
	{
		if (V <= 1.0)
			Kategorie = 0;
		else
		{
			if (PSV <= 50)
				Kategorie = 0;
			else if (PSV <= 200)
				Kategorie = 1;
			else if (PSV <= 1000)
				Kategorie = 2;
			else if (PSV <= 3000)
				Kategorie = 3;
			else 
				Kategorie = 4;
		}
	}
	else if (PS <= 3000)
	{
		if (V <= 1.0)
			Kategorie = 3;
		else
		{
			if (PSV <= 3000)
				Kategorie = 3;
			else 
				Kategorie = 4;
		}
	}
	else
		Kategorie = 4;

	return Kategorie;
}

function Diagramm3(V, PS)
{
	var PSV = V * PS;
	var Kategorie = 0;

	if (PS <= 10)
	{
		if (PSV <= 200)
			Kategorie = 0;
		else 
			Kategorie = 1;
	}
	else if (PS <= 500)
	{
		if (V <= 1.0)
			Kategorie = 0;
		else
		{
			if (PSV <= 200)
				Kategorie = 0;
			else 
				Kategorie = 2;
		}
	}
	else
	{
		if (V <= 1.0)
			Kategorie = 2;
		else
			Kategorie = 3;
	}
	return Kategorie;
}

function Diagramm4(V, PS)
{
	var PSV = V * PS;
	var Kategorie = 0;

	if (PS <= 10)
	{
		Kategorie = 0;
	}
	else if (PS <= 500)
	{
		if (PSV <= 10000)
			Kategorie = 0;
		else 
			Kategorie = 1;
	}
	else if (PS <= 1000)
	{
		if (PSV <= 10000)
			Kategorie = 0;
		else 
			Kategorie = 2;
	}
	else
	{
		if (V <= 10)
			Kategorie = 1;
		else
			Kategorie = 2;
	}
	return Kategorie;
}

function Diagramm6(DN, PS)
{
	var PSDN = DN * PS;
	var Kategorie = 0;

	if(PS <= 0.5)
	{
	      Kategorie = -1;     
	}
	else if (PS <= 10)
	{
		if (DN <= 25)
			Kategorie = 0;
		else if (DN <= 100)
			Kategorie = 1;
		else if (DN <= 350)
			Kategorie = 2;
		else 
			Kategorie = 3;
	}
	else if (PS <= 35)
	{
		if (DN <= 25)
			Kategorie = 0;
		else 
		{
			if (PSDN <= 1000)
				Kategorie = 1;
			else if (PSDN <= 3500)
				Kategorie = 2;
			else 
				Kategorie = 3;
		}
	}
	else if (PS <= 40)
	{
		if (DN <= 25)
			Kategorie = 0;
		else 
		{
			if (PSDN <= 1000)
				Kategorie = 1;
			else if (DN <= 100)
				Kategorie = 2;
			else 
				Kategorie = 3;
		}
	}
	else
	{
		if (DN <= 25)
			Kategorie = 0;
		else if (DN <= 100)
			Kategorie = 2;
		else
			Kategorie = 3;
	}
	return Kategorie;
}

function Diagramm7(Typ, DN, PS)
{
	var PSDN = DN * PS;
	var Kategorie = 0;
	
	if(PS <= 0.5)
	{
	      Kategorie = -1;     
	}
	if (PS <= 20)
	{
		if (PSDN <= 1000)
			Kategorie = 0;
		else if (PSDN <= 3500)
			Kategorie = 1;
		else if (PSDN <= 5000)
			Kategorie = 2;
		else 
			Kategorie = 3;
	}
	else if (PS <= 31.25)
	{
		if (PSDN <= 1000)
			Kategorie = 0;
		else 
		{
			if (PSDN <= 3500)
				Kategorie = 1;
			else if (DN <= 250)
				Kategorie = 2;
			else 
				Kategorie = 3;
		}
	}
	else if (PS <= 35)
	{
		if (DN <= 32)
			Kategorie = 0;
		else 
		{
			if (PSDN <= 3500)
				Kategorie = 1;
			else if (DN <= 250)
				Kategorie = 2;
			else 
				Kategorie = 3;
		}
	}
	else
	{
		if (DN <= 32)
			Kategorie = 0;
		else if (DN <= 100)
			Kategorie = 1;
		else if (DN <= 250)
			Kategorie = 2;
		else
			Kategorie = 3;
	}
	// Achtung: Feld bei KP UND MS einbauen!
	if(Typ == 'MS')
	       TEMPERATUR	= document.getElementById('IDC_BETRIEBSTEMPERATUR').value;
	else if(Typ == 'MS_ERGAENZEN')
	       TEMPERATUR	= document.getElementById('IDC_BETRIEBSTEMPERATUR_EDIT').value;
	else
	       TEMPERATUR	= document.getElementById('vorgabe_TEMP').value;
	
	if ((Kategorie == 2) && (DN > 32) && (PSDN > 1000) && (TEMPERATUR > 350))
		Kategorie = 3;
		
	return Kategorie;
}

function Diagramm8(DN, PS)
{
	var PSDN = DN * PS;
	var Kategorie = 0;
        
	if(PS <= 0.5)
	{
	      Kategorie = -1;     
	}
	if (PS <= 10)
	{
		if (PSDN <= 2000)
			Kategorie = 0;
		else 
			Kategorie = 1;
	}
	else if (PS <= 80)
	{
		if (PSDN <= 2000)
			Kategorie = 0;
		else 
			Kategorie = 2;
	}
	else if (PS <= 500)
	{
		if (DN <= 25)
			Kategorie = 0;
		else 
			Kategorie = 2;
	}
	else
	{
		if (DN <= 25)
			Kategorie = 0;
		else
			Kategorie = 3;
	}
	return Kategorie;
}

function Diagramm9(DN, PS)
{
	var PSDN = DN * PS;
	var Kategorie = 0;

	if(PS <= 0.5)
	{
	      Kategorie = -1;     
	}
	if (PS <= 10)
	{
		Kategorie = 0;
	}
	else if (PS <= 25)
	{
		if (PSDN <= 5000)
			Kategorie = 0;
		else 
			Kategorie = 1;
	}
	else if (PS <= 500)
	{
		if (DN <= 200)
			Kategorie = 0;
		else 
			Kategorie = 1;
	}
	else
	{
		if (DN <= 200)
			Kategorie = 0;
		else
			Kategorie = 2;
	}
	return Kategorie;
}