Cascade.panel.definition_stahlbau = function() 
{
	var form;
	var comboStore;
	
	return {
		init: function(idx) {
			if (!form) {
				comboStore = new Ext.data.Store({
					proxy: new Ext.data.HttpProxy({url: 'definition_stahlbau/get_traegergroessen' }),
					reader: new Ext.data.JsonReader({
						root: 'traeger'
						/*totalProperty: 'count',*/
						/*id: 'id'*/
					}, [
						{name: 'value'},
						{name: 'text'},
						{name: 'Btr'},
						{name: 'Htr'},
						{name: 'tG'}
					   ])
				});
				
				form = new Ext.FormPanel( {
					url:'definition-stahlbau/set-values',
					frame: true,
					labelAlign: 'top',
					title: '$DEFINITION_STAHLBAU$',
					id: 'definition_stahlbau',
					bodyStyle:'padding:5px 5px 0',
					baseParams: { __STORE_PATH__ : 'DLGDATA.CA.FORMS.DEFINITION_STAHLBAU' },
					listeners: {
						'actioncomplete': this.onActionComplete
					},
					
					items: [{
						xtype: 'fieldset',
						//width: 600,
						title: '$TRAEGER_NACH_DIN$', 
							
						autoHeight: true,
						autoWidth: true,
						
						items: [{
							layout: 'column',
							
							items: [ {
								width: 75,
								layout: 'form',
								
								layoutConfig: {
									labelSeparator: ''
								},
								items: {
									xtype: 'radio',
									id: 'IDC_INP',
									inputValue: 'INP',
									boxLabel:'INP',
									name:'IDC_TRAEGER',
									fieldLabel: '',
									hideLabel: true,
									listeners: {
										'check' : this.onRadioCheck
									}
								}
							},{
								width: 75,
								layout: 'form',
								layoutConfig: {
									labelSeparator: ''
								},
								
								items: {
									xtype: 'radio',
									id: 'IDC_IPE',
									inputValue: 'IPE',
									boxLabel:'IPE',
									fieldLabel: '',
									name:'IDC_TRAEGER',
									hideLabel: true,
									listeners: {
										'check' : this.onRadioCheck
									}
								}
							},{
								width: 75,
								layout: 'form',
								layoutConfig: {
									labelSeparator: ''
								},
								
								items: {
									xtype: 'radio',
									id: 'IDC_HEA',
									inputValue: 'HEA',
									boxLabel:'HEA',
									fieldLabel: '',
									name:'IDC_TRAEGER',
									hideLabel: true,
									listeners: {
										'check' : this.onRadioCheck
									}
								}
							},{
								width: 75,
								layout: 'form',
								
								layoutConfig: {
									labelSeparator: ''
								},
								items: {
									xtype: 'radio',
									id: 'IDC_HEB',
									inputValue: 'HEB',
									boxLabel:'HEB',
									fieldLabel: '',
									name:'IDC_TRAEGER',
									hideLabel: true,
									listeners: {
										'check' : this.onRadioCheck
									}
								}
							},{
								width: 75,
								layout: 'form',
								layoutConfig: {
									labelSeparator: ''
								},
								
								items: {
									xtype: 'radio',
									id: 'IDC_HEM',
									inputValue: 'HEM',
									boxLabel:'HEM',
									name:'IDC_TRAEGER',
									hideLabel: true,
									listeners: {
										'check' : this.onRadioCheck
									}
								}
							}]
						}]
					},{
						xtype: 'fieldset',
						//width: 600,
						title: '$TRAEGER_NACH_AISC$', 
							
						autoHeight: true,
						autoWidth: true,
						
						items: [{
							layout: 'column',
							
							items: [ {
								width: 75,
								layout: 'form',
								layoutConfig: {
									labelSeparator: ''
								},
								
								items: {
									xtype: 'radio',
									id: 'IDC_HP',
									inputValue: 'HP',
									boxLabel:'HP',
									name:'IDC_TRAEGER',
									hideLabel: true,
									listeners: {
										'check' : this.onRadioCheck
									}
								}
							},{
								width: 75,
								layout: 'form',
								layoutConfig: {
									labelSeparator: ''
								},
								
								items: {
									xtype: 'radio',
									id: 'IDC_M',
									inputValue: 'M',
									boxLabel:'M',
									name:'IDC_TRAEGER',
									hideLabel: true,
									listeners: {
										'check' : this.onRadioCheck
									}
								}
							},{
								width: 75,
								layout: 'form',
								layoutConfig: {
									labelSeparator: ''
								},
								
								items: {
									xtype: 'radio',
									id: 'IDC_W',
									inputValue: 'W',
									boxLabel:'W',
									name:'IDC_TRAEGER',
									hideLabel: true,
									listeners: {
										'check' : this.onRadioCheck
									}
								}
							}]
						}]
					},{
						xtype: 'fieldset',
						//width: 600,
						title: '$SONDERTRAEGER$', 
							
						autoHeight: true,
						autoWidth: true,
						items: [{
							layout: 'column',
							
							items: [ {
								width: 75,
								layout: 'form',
								layoutConfig: {
									labelSeparator: ''
								},
								
								items: {
									xtype: 'radio',
									id: 'IDC_SONDER',
									inputValue: 'SONDER',
									boxLabel:'$SONDER$',
									name:'IDC_TRAEGER',
									hideLabel: true,
									listeners: {
										'check' : this.onRadioCheck
									}
								}
							}]
						}]
					},{
						layout: 'column',
						
						items: [ {
							width: 200,
							layout: 'form',
							layoutConfig: {
								labelSeparator: ''
							},
							items: {
								xtype: 'combo',
								labelAlign: 'top',
								fieldLabel: '$TRAEGER_GROESSE$',
								hiddenName:'IDC_TRAEGER_GROESSE',
								store: comboStore,
								displayField:'text',
								typeAhead: true,
								mode: 'local',
								triggerAction: 'all',
								selectOnFocus:true,
								listeners: {
									'select' : this.onComboSelect
								}
							}
						},{
							width: 130,
							layout: 'form',
							layoutConfig: {
								labelSeparator: ''
							},
							items: {
								xtype: 'textfield',
								id: 'IDC_TRAEGERHOEHE',
								fieldLabel: '$TRAEGERHOEHE$',
								width: 75,
								disabled: true
							}
						},{
							width: 130,
							layout: 'form',
							layoutConfig: {
								labelSeparator: ''
							},
							items: {
								xtype: 'textfield',
								id: 'IDC_TRAEGERBREITE',
								fieldLabel: '$TRAEGERBREITE$',
								width: 75,
								disabled: true
							}
						},{
							width: 130,
							layout: 'form',
							layoutConfig: {
								labelSeparator: ''
							},
							items: {
								xtype: 'textfield',
								id: 'IDC_FLANSCHDICKE',
								fieldLabel: '$FLANSCHDICKE$',
								width: 75,
								disabled: true
							}
						}]
					}]
				});
				
				var cp = Ext.getCmp('center-panel');
					
				cp.insert(idx, form);
				cp.doLayout();
				
				// Funktioniert nicht !
				// var field = form.getForm().findField('IDC_TRAEGER');
				// var checked = field.getGroupValue();
				// alert( checked );
				// comboStore.load( { params: { IDC_TRAEGER: 'HEB' } } );
				
				Ext.DomHelper.insertAfter('IDC_TRAEGERHOEHE', {tag:'span', html:'&nbsp;mm'});
				Ext.DomHelper.insertAfter('IDC_TRAEGERBREITE', {tag:'span', html:'&nbsp;mm'});
				Ext.DomHelper.insertAfter('IDC_FLANSCHDICKE', {tag:'span', html:'&nbsp;mm'});
			}
			
			form.getForm().reset();
			form.load({ url: 'definition-stahlbau/get-values' });
			Ext.getCmp('move-next').enable();
		},
		
		onRadioCheck : function(radio, checked)
		{
			var f = form.getForm();
			
			if ( checked ) {
				if ( radio.id == 'IDC_SONDER') {
					f.findField('IDC_TRAEGER_GROESSE').disable();
					f.findField('IDC_TRAEGERHOEHE').enable();
					f.findField('IDC_TRAEGERBREITE').enable();
					f.findField('IDC_FLANSCHDICKE').enable();
				} else {
					f.findField('IDC_TRAEGER_GROESSE').enable();
					f.findField('IDC_TRAEGERHOEHE').disable();
					f.findField('IDC_TRAEGERBREITE').disable();
					f.findField('IDC_FLANSCHDICKE').disable();
					
					var combo = f.findField('IDC_TRAEGER_GROESSE');
					comboStore.reload({ params: { IDC_TRAEGER : radio.inputValue } });
					combo.clearValue();
					
					f.findField('IDC_TRAEGERHOEHE').reset();
					f.findField('IDC_TRAEGERBREITE').reset();
					f.findField('IDC_FLANSCHDICKE').reset();
				}
			}
		},
		
		/**
		 * Werte setzen
		 */
		onComboSelect : function( combo, record, idx ) 
		{
			var f = form.getForm();
			f.findField('IDC_TRAEGERHOEHE').setValue( record.get('Htr') );
			f.findField('IDC_TRAEGERBREITE').setValue( record.get('Btr') );
			f.findField('IDC_FLANSCHDICKE').setValue( record.get('tG') );
		},
        
        /**
         * Form after Action
         */
         onActionComplete: function(form, action) {
            var checked = form.findField('IDC_INP').getGroupValue();
            comboStore.load( { params: { IDC_TRAEGER: checked } } );
            
            Cascade.app.getNextPanel(form,action);
         }
	}
}();