Ext.namespace('Cascade.base');
/**
 * @category   Client Base
 * @copyright  Copyright (c) 2011 Plan Software GmbH (http://www.plansoft.de)
 * @version 1.0 - 2011 Special Tooltip -
 * @class Cascade.base.Tooltip
 * <br><b>Group: Base</b> Definition to Standard Tooltip's
 * @see onMouseOutInfo()	Tooltip close
 * @see onMouseOverInfo()	Tooltip with Mouse overview
 * @see onMouseClickInfo() 	Tooltip open with "X" close
 */
Cascade.base.Tooltip = function(){
	var tooltipObject,lastItem,lastItem1;
	var posXY,nXPos,nYPos;
	/**
	 * @private tooltip function
	 * @param [htmlText] {String} TooltipText
	 * @param [dVersion] {Double} 
	 * <li> Version 1 - XCat Standard Tooltip: Overview
	 * <li> Version 2 - XCat Standard Tooltip: Click Icon "Click the X to close this Tooltip"
	 */
	var tooltipfunction = function(htmlText,dVersion,nXPos,nYPos,dWidth){
        if(dVersion == 1){	        
	        var tooltiptest = new Ext.ToolTip({
	            html		: htmlText,
	            text		: null,
	            //renderTo	: document.body,
	            autoHide	: true,
	            width		: dWidth/*,
	            getTargetXY: function() {
	            	return [nXPos, nYPos];
	            }*/
	        });
	        return tooltiptest;
        }
        else if(dVersion == 2){
        	var tooltiptest = new Ext.ToolTip({
	            html		: htmlText+'<br><br>"Click X to close"',
	            text		: null,
	            autoHide	: false,
        		closable	: true,
        		draggable	: true/*,        		
	            getTargetXY : function() {
	            	return [nXPos, nYPos];
	            }*/
	        });
	        return tooltiptest;        	
        }
    }
	
	return {
		/**
         * @deprecated event open Tooltip  - version 1.0
         * @param [id] {String} Tooltip Id
         * @param [htmlinfo] {String} Tooltip info
         * @param [dVersion] {Double} Tooltip mode 
         * @param [nXPos] {Double} x-position
         * @param [nYPos] {Double} y-position
         */
		onMouseOverSelectionInfo: function(id,htmlinfo,dVersion,nXPos,nYPos,dWidth){
	        dWidth = (!dWidth ? 300 : dWidth);
	        if(lastItem1 !== id && !lastItem){
	        	lastItem  = lastItem1;
	        	Cascade.base.Tooltip.onMouseOutSelectionInfo(lastItem);
	        	lastItem1 = ''; 
	        	tooltipObject = tooltipfunction(htmlinfo,dVersion,nXPos,nYPos,dWidth);       	
	        }
	        else if(!lastItem1 && !lastItem)
	        	tooltipObject = tooltipfunction(htmlinfo,dVersion,nXPos,nYPos,dWidth);  
	        else if(lastItem !== id && !lastItem1){
	        	Cascade.base.Tooltip.onMouseOutSelectionInfo(lastItem);
	        	tooltipObject = tooltipfunction(htmlinfo,dVersion,nXPos,nYPos,dWidth); 
	        }
	        else if(lastItem !== id && lastItem1){	
	        	lastItem  = lastItem1;
	        	Cascade.base.Tooltip.onMouseOutSelectionInfo(lastItem);
	        	lastItem1 = ''; 
	        	tooltipObject = tooltipfunction(htmlinfo,dVersion,nXPos,nYPos,dWidth); 
	        }
	        else if(dVersion == 2 && lastItem){
	        	Cascade.base.Tooltip.onMouseOutSelectionInfo(lastItem);
	        	tooltipObject = tooltipfunction(htmlinfo,dVersion,nXPos,nYPos,dWidth);
	        }
	        		
			if(dVersion == 1 && !lastItem1){
		        Ext.fly(id).addClass('x-grid-col-INFO');
		        lastItem = id;
		        tooltipObject.hideDelay = 0;
		        tooltipObject.showDelay = 500000;
		        tooltipObject.dismissDelay = 500000;
			}
			else if(dVersion == 2){
				 Ext.fly(id).addClass('x-grid-col-INFO');
				 lastItem  = '';
				 lastItem1 = id;			
			}
			
			tooltipObject.targetXY = [nXPos,nYPos];
	        tooltipObject.show();
		},
		/**
         * @deprecated event hide Tooltip with Tooltip initial version 1  - version 1.0
         * @param [id] {String} tooltip id
         */
		onMouseOutSelectionInfo : function(id){
	        try{
	        	if(lastItem){
		        	Ext.fly(lastItem).removeClass('x-view-over');
		        	tooltipObject.hide();
		        	lastItem = '';
	        	}
	        }
	        catch(err){
	        	
	        }    
		},
		/**
         * @deprecated event for Collapsible Tooltip  - version 1.0
         */
		onCollapsibleTooltip: function(){
			if(lastItem1){
            	lastItem  = lastItem1;
	        	Cascade.base.Tooltip.onMouseOutSelectionInfo(lastItem);
	        	lastItem1 = '';                                     
            }
		},
		/**
         * @deprecated event hide all Tooltip  - version 1.0
         */
		closeAllTooltips: function(){
			if(lastItem1){
            	lastItem  = lastItem1;
	        	Cascade.base.Tooltip.onMouseOutSelectionInfo(lastItem);
	        	lastItem1 = '';                                     
            }
            
            if(lastItem)
            	Cascade.base.Tooltip.onMouseOutSelectionInfo(lastItem);
		},
		/**
         * @deprecated special Tooltip function for preconfig functions - version 1.0
         */
		onMouseClickInfo:function(id){
			Cascade.base.Tooltip.onMouseOverInfo(id,2);
		},	
		/**
         * @deprecated special Tooltip function for preconfig functions - version 1.0
         */	
		onMouseOverInfo:function(id,dVersion){
			
		},	
		/**
         * @deprecated special Tooltip function for preconfig functions - version 1.0
         */			
		onMouseOutInfo:function(id){
			
		}		
	};
}();