Ext.namespace('Cascade.base.Messages');

/**
 * @class Cascade.base.Info_Message
 * <br>Group: Cascade Base
 * <br> build Standard Info Message Dialog
 * <br>
 * @param [message] {String} Info message
 */
Cascade.base.Messages.Info_Message = function(message){
    Ext.MessageBox.show({
       title	: '$IDC_INFO$',
       msg	: message,
       maxWidth : 800,
       minWidth : 400,
       buttons	: Ext.MessageBox.OK,
       icon	: 'ext-mb-info'
    });
}

/**
 * @class Cascade.base.Messages.Error_Message
 * <br>Group: Cascade Base
 * <br> build Standard Error Message Dialog
 * <br>
 * @param [message] {String} Warning message
 */
Cascade.base.Messages.Error_Message = function(message){
    Ext.MessageBox.show({
       title	: '$IDC_PARSING_WARNINGS$',
       msg	: message,
       maxWidth : 800,
       minWidth : 400,
       buttons	: Ext.MessageBox.OK,
       icon	: 'ext-mb-error'
    });
}

/**
 * @class Cascade.base.Messages.Warning_Message
 * <br>Group: Cascade Base
 * <br> build Standard Warning Message Dialog
 * <br>
 * @param [message] {String} Warning message
 */
Cascade.base.Messages.Warning_Message = function(message){
    Ext.MessageBox.show({
       title	: '$WARNINGS$',
       msg	: message,
       maxWidth : 800,
       minWidth : 400,
       buttons	: Ext.MessageBox.OK,
       icon	: 'ext-mb-warning'
    });
}