Cascade.panel.auswahl_haengergroesse = function() 
{
	var form;
	var retobj;
	
	return {
		init: function(idx) {
			if (!form) {
				form = new Ext.FormPanel( {
					id: 'auswahl_haengergroesse',
					url:'auswahl-haengergroesse/set-values',
					title: '$AUSWAHL_HAENGERGROESSE$',
					
					frame: true,
					bodyStyle:'padding:5px 5px 0',
					
					baseParams: { 
						__STORE_PATH__ : 'DLGDATA.CA.FORMS.AUSWAHL_HAENGERGROESSE' 
					},
					
					listeners: {
						'actioncomplete': Cascade.app.getNextPanel
					},
					
					items: [{
						xtype: 'fieldset',
						id: 'IDC_FH_FS',
						title: 'FH/FS',
						checkboxToggle: true,
						checkboxName: 'IDC_FH_FS_CHECK',
						animCollapse: true,
						titleCollapse: true,
						autoHeight: true,
						width: 680,
						
						listeners: {
							'expand': function(panel) {
								Ext.getCmp('IDC_KH_KS').collapse(true);
							},
							
							'collapse': function(panel) {
								var p = Ext.getCmp('IDC_KH_KS');
								if ( p.collapsed )
									p.expand(true);
							}
						},
						items: [ {
							layout:'column',
							items: [{
								width: 300,
								layout: 'form',
								
								items: [{
									xtype:'numberfield',
									id: 'IDC_LASTGROESSE',
									fieldLabel: '$LASTGROESSE$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_LASTGROESSE'
								},{
									xtype:'numberfield',
									id: 'IDC_WARMLAST',
									fieldLabel: '$WARMLAST$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_WARMLAST'
								},{
									xtype:'numberfield',
									id: 'IDC_KALTLAST',
									fieldLabel: '$KALTLAST$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_KALTLAST'
								},{
									xtype:'numberfield',
									id: 'IDC_FEDERRATE',
									fieldLabel: '$FEDERRATE$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_FEDERRATE'
								},{
									xtype:'numberfield',
									id: 'IDC_ZUS_LAST_EG_FH',
									fieldLabel: '$ZUSATZLAST_AUS_EIGENGEWICHT$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_ZUS_LAST_EG_FH'
								}]
							},{
								width: 300,
								layout: 'form',
								
								items: [{
									xtype:'numberfield',
									id: 'IDC_NENNWEG',
									fieldLabel: '$NENNWEG$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_NENNWEG'
								},{
									xtype:'numberfield',
									id: 'IDC_SOLLWEG_VERTIKAL_AUF',
									fieldLabel: '$SOLLWEG$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_SOLLWEG_VERTIKAL_AUF'
								},{
									xtype:'numberfield',
									id: 'IDC_SOLLWEG_VERTIKAL_AB',
									fieldLabel: '',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_SOLLWEG_VERTIKAL_AB'
								},{
									xtype:'numberfield',
									id: 'IDC_LASTAENDERUNG',
									fieldLabel: '$LASTAENDERUNG$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_LASTAENDERUNG'
								},{
									xtype:'numberfield',
									id: 'IDC_WEGRESERVE_OBEN',
									fieldLabel: '$WEGRESERVE$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_WEGRESERVE_OBEN'
								},{
									xtype:'numberfield',
									id: 'IDC_WEGRESERVE_UNTEN',
									fieldLabel: '',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_WEGRESERVE_UNTEN'
								}]
							},{
								layout: 'form',
								width: 600,
								labelWidth: 120,
								
								items: [{
									xtype: 'textfield',
									id: 'IDC_GRUNDTYP',
									fieldLabel: '$TYP$...',
									
									width: 175,
									disabled: true
								},{
									layout:'column',
									items:[{
										//columnWidth:.65,
										width: 175,
										layout: 'form',
										items: [{
											xtype:'numberfield',
											id: 'IDC_MINDESTWEGRESERVE',
											fieldLabel: '$MINDESTWEGRESERVE$',
											width: 50,
											name: 'IDC_MINDESTWEGRESERVE',
											anchor:'95%'
										}]
									},{
										//columnWidth:.35,
										width: 40,
										layout: 'fit',
										items: [{
											bodyStyle:'padding:3px;font-size:12px;',
											html:' [mm]'
										}]
									},{
										width: 100,
										
										items: [ {
											xtype: 'button',
											text: '$KORRIGIEREN$',
											handler: function() {
												Ext.Ajax.request(
													{ 	url: 'auswahl_haengergroesse/korrigiere_values', 
														params : { IDC_MINDESTWEGRESERVE : form.getForm().findField('IDC_MINDESTWEGRESERVE').getValue() }, 
														success: Cascade.panel.auswahl_haengergroesse.updateDialog 
													} 
												);
											}
										}]
									}]
								},{
									layout: 'form',
									
									items: {
										xtype: 'combo',
										fieldLabel: '$ALTERNATIVEN$',
										hiddenName:'IDC_ALTERNATIVEN',
										store: new Ext.data.SimpleStore({
											fields: ['value', 'text'],
											data : []
										}),
										displayField:'text',
										valueField:'value',
										typeAhead: true,
										editable: false,
										mode: 'local',
										triggerAction: 'all',
										emptyText:'$NENNWEITE_WAEHLEN$',
										selectOnFocus:true,
										width:280,
                                        listWidth:280
									}
								}]
							}]
						}]
					},{
                        id: 'FH_MESSAGE',
						html: '<b>Warnung </b>'
                    },{
						xtype: 'fieldset',
						title: 'KH/KS',
						id: 'IDC_KH_KS',
						checkboxToggle: true,
						checkboxName: 'IDC_KH_KS_CHECK',
						collapsed: true,
						animCollapse: true,
						titleCollapse: true,
						autoHeight: true,
						width: 680,
						listeners: {
							'expand': function(panel) {
								Ext.getCmp('IDC_FH_FS').collapse(true);
							},
							
							'collapse': function(panel) {
								var p = Ext.getCmp('IDC_FH_FS');
								if ( p.collapsed )
									p.expand(true);
							}
						},
						
						items: [ {
							layout:'column',
							items: [ {
								width: 300,
								layout: 'form',
								
								items: [{
									xtype:'numberfield',
									id: 'IDC_LASTGROESSE_KH',
									fieldLabel: '$LASTGROESSE$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_LASTGROESSE_KH'
								},{
									xtype:'numberfield',
									id: 'IDC_SOLLLAST_KH',
									fieldLabel: '$SOLLLAST$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_SOLLLAST_KH'
								},{
									xtype:'numberfield',
									id: 'IDC_WEGRESERVE_KH',
									fieldLabel: '$WEGRESERVE$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_WEGRESERVE_KH'
								},{
									xtype:'numberfield',
									id: 'IDC_ZUS_LAST_EG_KH',
									fieldLabel: '$ZUSATZLAST_AUS_EIGENGEWICHT$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_ZUS_LAST_EG_KH'
								}]
							},{
								width: 300,
								layout: 'form',
								
								items: [{
									xtype:'numberfield',
									id: 'IDC_NENNWEG_KH',
									fieldLabel: '$NENNWEG$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_NENNWEG_KH'
								},{
									xtype:'numberfield',
									id: 'IDC_SOLLWEG_KH_AUF',
									fieldLabel: '$SOLLWEG$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_SOLLWEG_KH_AUF'
								},{
									xtype:'numberfield',
									id: 'IDC_SOLLWEG_KH_AB',
									fieldLabel: '',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_SOLLWEG_KH_AB'
								},{
									xtype:'textfield',
									id: 'IDC_LASTJUSTIERUNG_KH',
									fieldLabel: '$LASTJUSTIERUNG$',
									width: 50,
									disabled: true,
									labelSeparator:'',
									name: 'IDC_LASTJUSTIERUNG_KH'
								}]
							}]
						},{
							layout: 'form',
							width: 600,
							labelWidth: 200,
							items: [{
								xtype: 'textfield',
								id: 'IDC_GRUNDTYP_KH',
								fieldLabel: '$TYP$...',
								width: 175,
								disabled: true
							},{
								xtype: 'fieldset',
								width: 550,
								autoHeight: true,
								items: [
								{
									xtype: 'checkbox',
									id: 'IDC_KH_ALLE_VARIANTEN_ZEIGEN',
									fieldLabel: '$IDC_KH_ALLE_VARIANTEN_ZEIGEN$'
								},{
									layout:'column',
									items:[{
										//columnWidth:.65,
										width: 275,
										layout: 'form',
										items: [{
											xtype:'numberfield',
											id: 'IDC_MINDESTWEGRESERVE_KH',
											fieldLabel: '$MINDESTWEGRESERVE$',
											width: 50,
											name: 'IDC_MINDESTWEGRESERVE_KH'
										}]
									},{
										//columnWidth:.35,
										width: 40,
										layout: 'fit',
										items: [{
											bodyStyle:'padding:3px;font-size:12px;',
											html:' [mm]'
										}]
									},{
										width: 100,
										
										items: [ {
											xtype: 'button',
											text: '$KORRIGIEREN$',
											handler: function() {
												Ext.Ajax.request(
													{ 	url: 'auswahl_haengergroesse/korrigiere_values', 
														params : { IDC_MINDESTWEGRESERVE_KH : form.getForm().findField('IDC_MINDESTWEGRESERVE_KH').getValue(), 
																   IDC_KH_ALLE_VARIANTEN_ZEIGEN : form.getForm().findField('IDC_KH_ALLE_VARIANTEN_ZEIGEN').getValue()}, 
														success: Cascade.panel.auswahl_haengergroesse.updateDialog 
													} 
												);
											}
										}]
									}]
								}]
							}, {
								layout: 'form',
								
								items: {
									xtype: 'combo',
									fieldLabel: '$ALTERNATIVEN$',
									hiddenName:'IDC_ALTERNATIVEN_KH',
									store: new Ext.data.SimpleStore({
										fields: ['value', 'text'],
										data : []
									}),
									displayField:'text',
									valueField:'value',
									typeAhead: true,
									editable: false,
									mode: 'local',
									triggerAction: 'all',
									/*emptyText:'$NENNWEITE_WAEHLEN$',*/
									selectOnFocus:true,
                                    listWidth:280,
									width:280
								}
							}]
						}]
					},{
                        id: 'KH_MESSAGE',
						html: '<b>Warnung </b>'
                    }]
				});
				
				var cp = Ext.getCmp('center-panel');
				
				cp.insert(idx,form);
				cp.doLayout();
				
				Ext.DomHelper.insertAfter('IDC_WARMLAST', {tag:'span', html:'&nbsp;[kN]'});
				Ext.DomHelper.insertAfter('IDC_KALTLAST', {tag:'span', html:'&nbsp;[kN]'});
				Ext.DomHelper.insertAfter('IDC_FEDERRATE', {tag:'span', html:'&nbsp;[N/mm]'});
				Ext.DomHelper.insertAfter('IDC_ZUS_LAST_EG_FH', {tag:'span', html:'&nbsp;[kN]'});
				Ext.DomHelper.insertAfter('IDC_NENNWEG', {tag:'span', html:'&nbsp;[mm]'});
				Ext.DomHelper.insertAfter('IDC_SOLLWEG_VERTIKAL_AUF', {tag:'span', html:'&nbsp;[mm] $IDC_LABEL_RICHTUNG_AUF$'});
				Ext.DomHelper.insertAfter('IDC_SOLLWEG_VERTIKAL_AB', {tag:'span', html:'&nbsp;[mm] $IDC_LABEL_RICHTUNG_AB$'});
				Ext.DomHelper.insertAfter('IDC_LASTAENDERUNG', {tag:'span', html:'&nbsp;[%]'});
				Ext.DomHelper.insertAfter('IDC_WEGRESERVE_OBEN', {tag:'span', html:'&nbsp;[mm] $ID_OBEN$'});
				Ext.DomHelper.insertAfter('IDC_WEGRESERVE_UNTEN', {tag:'span', html:'&nbsp;[mm] $ID_UNTEN$'});
				
				Ext.DomHelper.insertAfter('IDC_SOLLLAST_KH', {tag:'span', html:'&nbsp;[kN]'});
				Ext.DomHelper.insertAfter('IDC_WEGRESERVE_KH', {tag:'span', html:'&nbsp;[mm]'});
				Ext.DomHelper.insertAfter('IDC_ZUS_LAST_EG_KH', {tag:'span', html:'&nbsp;[kN]'});
				Ext.DomHelper.insertAfter('IDC_NENNWEG_KH', {tag:'span', html:'&nbsp;[mm]'});
				Ext.DomHelper.insertAfter('IDC_SOLLWEG_KH_AUF', {tag:'span', html:'&nbsp;[mm] $IDC_LABEL_RICHTUNG_AUF$'});
				Ext.DomHelper.insertAfter('IDC_SOLLWEG_KH_AB', {tag:'span', html:'&nbsp;[mm] $IDC_LABEL_RICHTUNG_AB$'});
				Ext.DomHelper.insertAfter('IDC_LASTJUSTIERUNG_KH', {tag:'span', html:'&nbsp;[%]'});
				
				form.getForm().findField('IDC_ALTERNATIVEN').on('select', this.setFormValues );
				form.getForm().findField('IDC_ALTERNATIVEN_KH').on('select', this.setFormValuesKH );
			}
			
			this.getValues();
		},
		
		setFormValues : function(combo, record, idx ) 
		{
			// Event wurde nicht von der Combo selbst geschmissen
			if ( typeof combo == "undefined" ) {
				form.getForm().setValues( retobj.fherg[retobj.selected] );
			}	
			else {
				form.getForm().setValues( retobj.fherg[idx] );
			}
		},
		
		setFormValuesKH : function( combo, record, idx )
		{
			if ( typeof combo == "undefined" ) {
				form.getForm().setValues( retobj.kherg[retobj.selected_kh] );
			} else {
				form.getForm().setValues( retobj.kherg[idx] );
			}
		},
		
		getValues : function()
		{
			// Dieser Handler sorgt dafr, dass die Werte vom Controller geladen werden
			// Danach verteilt er die der selektierten Zeile in der Form
			Ext.Ajax.request(
				{ url: 'auswahl_haengergroesse/get_values',
					success: this.updateDialog } );
		},
		
		updateDialog : function( response, options )
		{
			retobj = Ext.util.JSON.decode( response.responseText );
			
			// FH
			var items_fh = [];
			
			for ( var i = 0; i < retobj.fherg.length; i++ )
				items_fh.push( [ i, retobj.fherg[i].IDC_COMBOTYP ] );
			
			var combo_fh = form.getForm().findField('IDC_ALTERNATIVEN');
			combo_fh.store.loadData( items_fh );
			combo_fh.setValue(retobj.selected);
			combo_fh.fireEvent('select');
			
            if (((retobj.fherg.length <= 0) ||
                 (( typeof retobj.msg != "undefined" ) && (retobj.msg != ""))) && 
                (retobj.kherg.length >= 0))
            {
                // Ext.getCmp('IDC_KH_KS').toggleCollapse();
                Ext.getCmp('IDC_FH_FS').collapse();
                Ext.getCmp('IDC_KH_KS').expand();
			}
            // FH Message kann auch kommen wenn Ergebnisse da (z.B. Wegreserve kleiner Norm)
            var fhMsgLabel = Ext.getCmp('FH_MESSAGE');
            if (( typeof retobj.msg != "undefined" ) && (retobj.msg != ""))
            {
                // Ext.MessageBox.alert('Message', retobj.msg);
                fhMsgLabel.getEl().update("<b>" + retobj.msg + "</b><br>&nbsp;");
			}
            else
                fhMsgLabel.getEl().update('');
            // fhMsgLabel.doLayout();
            
            // KH
            if (retobj.kherg.length > 0)
            {
                Ext.getCmp('IDC_KH_KS').enable();  
                var items_kh = [];
                
                for ( var i=0; i < retobj.kherg.length; i++ )
                    items_kh.push( [ i, retobj.kherg[i].IDC_COMBOTYP_KH ] );
                    
                var combo_kh = form.getForm().findField('IDC_ALTERNATIVEN_KH');
                combo_kh.store.loadData( items_kh );
                combo_kh.setValue(retobj.selected_kh );
                combo_kh.fireEvent('select');
            }
            else
            {
                //form.getForm().findField('IDC_KH_KS_CHECK').disable();
                //form.getForm().findField('IDC_KH_KS').disable();
                Ext.getCmp('IDC_FH_FS').expand();
                Ext.getCmp('IDC_KH_KS').collapse();
                Ext.getCmp('IDC_KH_KS').disable();  // oder hide() ??
            }
            
            var khMsgLabel = Ext.getCmp('KH_MESSAGE');
			if (( typeof retobj.msg_kh != "undefined" ) && (retobj.msg_kh != "" ))
				// Ext.MessageBox.alert('Message', retobj.msg_kh );
                khMsgLabel.getEl().update("<b>" + retobj.msg_kh + "</b><br>&nbsp;");
            else
                khMsgLabel.getEl().update('');
                
            if (( typeof retobj.disabled != "undefined" ) && (retobj.disabled != "" ))
            {
                Ext.getCmp(retobj.disabled).disable();
            }			
		}
	}
}();