Ext.override(Ext.form.BasicForm, {
	setValues : function(values){
        if(values instanceof Array){             
			for(var i = 0, len = values.length; i < len; i++){
                var v = values[i];
                var f = this.findField(v.id);
                if(f){
					if ( f.getEl().dom.type == 'radio' ) {
						var group = this.el.dom.elements[f.getName()];
						for ( var i=0; i < group.length; i++ ) {
							if ( group[i].value == v.value ) {
								group[i].checked = true;
								
							}
						}
					} else {
						f.setValue(v.value);
					}
					
                    if(this.trackResetOnLoad){
                        f.originalValue = f.getValue();
                    }
                }
            }
        }else{             
			var field, id;
            for(id in values){
                if(typeof values[id] != 'function' && (field = this.findField(id))){
					if ( field.getEl().dom.type == 'radio' ) {
						var group = this.el.dom.elements[field.getName()];
						for ( var i=0; i < group.length; i++ ) {
							if ( group[i].value == values[id] ) {
								group[i].checked = true;
							}
						}
					} else {
						field.setValue(values[id]);
					}
                    
					if(this.trackResetOnLoad){
                        field.originalValue = field.getValue();
                    }
					
                }
            }
        }
        return this;
    }
});

Ext.override(Ext.form.Radio, {
    onRender : function(ct, position) {
        Ext.form.Radio.superclass.onRender.call(this, ct, position);
        this.el.dom.__ext_field = this;
    },

    setValue : function(v) {
        if(v === true || v === 'true' || v == '1' || v === false || v === 'false' || v == '0') {

            // Select all radios of this group
            var radios = this.el.up('form').select('input[type=radio]');

            this.checked = (v === true || v === 'true' || v == '1');
            if(this.el && this.el.dom) {
                this.el.dom.checked = this.checked;
            }

            // When a radio is checked, all other radios with the same name are unchecked automatically by
            // the browser, so the DOM part is done. Now we must set checked = false on the Ext object
            // and fire the "check" (false) event with the correct parameters
            // This cycles over all the radios...
            for(var i = 0; i < radios.elements.length; i++) {
                if(radios.elements[i].__ext_field && radios.elements[i].__ext_field != this && radios.elements[i].name == this.el.dom.name && radios.elements[i].__ext_field.el.dom.checked == false)
                {
                    radios.elements[i].__ext_field.checked = false;
                    radios.elements[i].__ext_field.fireEvent("check", radios.elements[i].__ext_field, false);
                }
            }

            // Lastly, we must fire the "check" (true) event on the selected radio
            this.fireEvent("check", this, this.checked);
        }
    },
	
	/**
	 * Enables a whole group of radios
	 */
	enableGroup : function() {
		var group = this.el.up('form').dom[this.name];
		
		for ( var i=0, len = group.length; i < len; ++i )
			group[i].disabled = false;
	},
	
	/**
	 * Disables the group the radio button is in
	 */
	disableGroup : function() {
		var group = this.el.up('form').dom[this.name];
		
		for ( var i=0, len = group.length; i < len; ++i )
			group[i].disabled = true;
	}
});

Ext.apply( Ext.lib.Ajax, 
{
	request : function(method, uri, cb, data, options) {
		var obj = Ext.urlDecode( data );
		
		if ( typeof data == "undefined" || data == "" )
			method = "POST";
		
		if ( typeof EasyKat.SessionId != "undefined" )
			obj.sessionid = EasyKat.SessionId;
		
		data = Ext.urlEncode( obj );
		
		if(options){
			var hs = options.headers;
			if(hs){
				for(var h in hs){
					if(hs.hasOwnProperty(h)){
						this.initHeader(h, hs[h], false);
					}
				}
			}
			if(options.xmlData){
				this.initHeader('Content-Type', 'text/xml', false);
				method = 'POST';
				data = options.xmlData;
			}else if(options.jsonData){
				this.initHeader('Content-Type', 'text/javascript', false);
				method = 'POST';
				data = typeof options.jsonData == 'object' ? Ext.encode(options.jsonData) : options.jsonData;
			}
		}

		return this.asyncRequest(method, uri, cb, data);
	},
	
	serializeForm : function(form) {
		if(typeof form == 'string') {
			form = (document.getElementById(form) || document.forms[form]);
		}

		var el, name, val, disabled, data = '', hasSubmit = false;
		for (var i = 0; i < form.elements.length; i++) {
			el = form.elements[i];
			disabled = form.elements[i].disabled;
			name = form.elements[i].name;
			val = form.elements[i].value;
			
			// We need all Formfields even the disabled ones
			if (/*!disabled &&*/ name){
				switch (el.type)
						{
					case 'select-one':
					case 'select-multiple':
						for (var j = 0; j < el.options.length; j++) {
							if (el.options[j].selected) {
								if (Ext.isIE) {
									data += encodeURIComponent(name) + '=' + encodeURIComponent(el.options[j].attributes['value'].specified ? el.options[j].value : el.options[j].text) + '&';
								}
								else {
									data += encodeURIComponent(name) + '=' + encodeURIComponent(el.options[j].hasAttribute('value') ? el.options[j].value : el.options[j].text) + '&';
								}
							}
						}
						break;
					case 'radio':
						if (el.checked) {
							data += encodeURIComponent(name) + '=' + encodeURIComponent(val) + '&';
						}
						break;
					// We need all data, even empty checkboxes.
					case 'checkbox':
						if (el.checked) {
							data += encodeURIComponent(name) + '=' + encodeURIComponent(val) + '&';
						} else {
							data += encodeURIComponent(name) + '=&';
						}
						break;
					case 'file':

					case undefined:

					case 'reset':

					case 'button':

						break;
					case 'submit':
						if(hasSubmit == false) {
							data += encodeURIComponent(name) + '=' + encodeURIComponent(val) + '&';
							hasSubmit = true;
						}
						break;
					default:
						data += encodeURIComponent(name) + '=' + encodeURIComponent(val) + '&';
						break;
				}
			}
		}
		data = data.substr(0, data.length - 1);
		//alert( data );
		return data;
	}
});

Ext.override(Ext.form.Field, 
{
    showContainer: function() {
        this.enable();
        this.show();
        this.getEl().up('.x-form-item').setDisplayed(true); // show entire container and children (including label if applicable)
    },
    
    hideContainer: function() {
        this.disable(); // for validation
        this.hide();
        this.getEl().up('.x-form-item').setDisplayed(false); // hide container and children (including label if applicable)
    },
    
    setContainerVisible: function(visible) {
        if (visible) {
            this.showContainer();
        } else {
            this.hideContainer();
        }
        return this;
    },
	
	setLabel: function(text) {
		this.getEl().up('.x-form-item').dom.firstChild.innerHTML = text;
	},

	setBoxLabel: function(text) {
		this.getEl().next().dom.innerHTML = text;
	},
    
    hideBoxLabel: function() {
		this.getEl().next().hide();
	},

	showBoxLabel: function() {
		this.getEl().next().show();
	}
});


if ( typeof( EasyKat ) == "undefined"  )
    EasyKat = {};
if ( typeof( EasyKat.util ) == "undefined"  )
    EasyKat.util = {};


EasyKat.util.downloadMessage = function(config) {
    var strMessage;
    var strLinkText;
    if (config.message)
        strMessage = config.message;
    else
        strMessage = "If download does not start use the follwing link:";
    if (config.linktext)
        strLinkText = config.linktext;
    else
        strLinkText = "Start Download";
        
    Ext.Msg.show({
        title: config.title || 'Download Message',
        msg: config.msg || (strMessage + '<br/><br/><a href="' + config.url + '" />'+strLinkText+'</a>'),
        buttons: config.buttons || Ext.Msg.OK,
        icon: config.icon || Ext.Msg.INFO
    });
}
