//<?php
/*
EasyGUI XP is free software released under the terms of the following BSD license.

Copyright (c) 2005,2006 Gaetan Lauff (glauff@plansoft.de)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

- Redistributions of source code must retain the above copyright notice, 
this list of conditions and the following disclaimer. 

- Redistributions in binary form must reproduce the above copyright notice, 
this list of conditions and the following disclaimer in the documentation 
and/or other materials provided with the distribution.

- Neither the name of the developer nor the names of its contributors may 
be used to endorse or promote products derived from this software without 
specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**
 * Defines all Component Templates
 *
 * @author Gaetan Lauff	<glauff@plansoft.de>
 * @version $Id: components.php 198 2006-11-24 18:57:17Z glauff $
 */


$components = new Array;

$components['dialog'] = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<meta http-equiv="content-type" content="application/xhtml+xml; charset=%EK_ENCODING%">
<meta name="generator" content="EasyKat Produkt und Angebotskonfigurator">
<meta http-equiv="msthemecompatible" content="yes">
<head>
	<title>%text%</title>
	<link id="easygui" href="%EK_PATH%/css/easygui.css" rel="stylesheet" type="text/css" />	
	<link id="custom" href="%stylesheet%" rel="stylesheet" type="text/css" />
	<script type="text/javascript" >initFunctions=new String();</script>
	<script type="text/javascript" >ek_path = \'%EK_PATH%\'; ek_appmode = \'%APPMODE%\';</script>
	<script type="text/javascript" src="%EK_PATH%/prototype.js"></script>
	<script type="text/javascript" src="%EK_PATH%/scriptaculous.js"></script>
	<script type="text/javascript" src="%EK_PATH%/easygui.js"  ></script>
	
</head>
<body {attributes:id;resizedialog;modal;centerdialog;validate;allowselect} dialogwidth="%width%" dialogheight="%height%" background="%image%" scroll="no" style="{styles:imagerepeat;horizontalalign;verticalalign;backgroundcolor}" onload="EasyGUI.initUI();%onload%">
<form id="isycat" name="isycat" method="post" action="%EK_SUBMIT_TARGET%" enctype="multipart/form-data" onsubmit="return false">
%components%
	<input type="hidden" id="port" name="port" value="%port%" />
	<input type="hidden" id="sessionid" name="sessionid" value="%sessionid%" />
	<input type="hidden" id="stateid" name="stateid" value="%stateid%" />
	<input type="hidden" id="IDC_EASYGUI_VERSION" name="IDC_EASYGUI_VERSION" value="%EK_VERSION%" />
	<input type="hidden" id="IDC_EASYGUI_BUILD" name="IDC_EASYGUI_BUILD" value="%EK_BUILD%" />
	<input type="hidden" id="IDC_EASYGUI_REVISION" name="IDC_EASYGUI_REVISION" value="%EK_REVISION%" />
	<input type="hidden" id="APPMODE" name="APPMODE" value="%APPMODE%" />
	<input type="hidden" id="APPLANG" name="APPLANG" value="%APP_LANG%" />
	<input type="hidden" id="EKSUBMITEVENT" name="EKSUBMITEVENT" value="" />
	<input type="hidden" id="EK_ACTION" name="EK_ACTION" value="" />
	<input type="hidden" id="EK_TARGET" name="EK_TARGET" value="" />
	<input type="hidden" id="EK_REQUEST"	name="EK_REQUEST" value="false" />
	<input type="hidden" id="EK_NOSTACK"	name="EK_NOSTACK" value="false" />
</form>
<div id="GUI_DISABLE" style="position: absolute; left: 0px; top: 0px; width: 1px; height: 1px; background-image: url(%EK_PATH%/gfx/blank.gif); visibility: hidden; z-Index:10000; cursor: wait;"></div>
<iframe id="isyiframe" name="isyiframe" src="javascript: false;" style="position:absolute; left: -10px; top:-10px; height: 1px; width: 1px;"></iframe>
<iframe id="isyajax" name="isyajax" src="javascript: false;" onload="onComplete(this);" style="visibility: hidden; height: 1px;"></iframe>
</body>
</html>
';


$components['container'] = 
'<div style="position:absolute; {styles:left;top;width;height;verticalalign;horizontalalign}">
	%s
</div>';

$components['cdata'] = 
'%data%';

$components['button'] = 
'<button {attributes} type_="button" name="%id%" style="{styles}" ektype="Button" value="%text%">
	%text%
	%components%
</button>
<script>widgets.push("EasyGUI_button:%id%");</script>';

$components['imagebutton'] = 
'<input type="image" {attributes} name="%id%" style="{styles}"  />';

/**
 * label templates
 */
$components['label_left'] = 
'<table cellspacing="0" cellpadding="0" border="0" style="{styles:position;top;left;height;width}">
	<tr style="{styles:backgroundcolor}">
		<td>
			<table cellspacing="0" cellpadding="0" border="0">
				<tr >
					<td class="%labelstyle%">
						<label id="%id%_LABEL" for="%id%" accesskey="%accesskey%" style="white-space: nowrap; {styles}">(label|text)</label>
					</td>
					<td>%s</td>
				</tr>
			</table>
		</td>
	</tr>
</table>';

$components['label_right'] =
'<table cellspacing="0" cellpadding="0" border="0" style="{styles:position;top;left;width;height}">
	<tr style="{styles:backgroundcolor}"><td>
		<table cellspacing="0" cellpadding="0" border="0" >
			<tr >
				<td>
					%s
				</td>
				<td class="%labelstyle%">
					<label id="%id%_LABEL" for="%id%" accesskey="%accesskey%" style="white-space: nowrap;{styles}">(label|text)</label>
				</td>
			</tr>
		</table>
	</td></tr>
</table>';

$components['checkbox'] = 
'<input type="checkbox" {attributes} label="%text%" name="%id%" style="{styles:!width;!height};"  ektype="Checkbox" />
<script>widgets.push("EasyGUI_checkbox:%id%");</script>';

$components['radiobutton'] = 
'<input type="radio" {attributes} style="{styles:!width;!height}" ektype="Radiobutton" />
<script>widgets.push("EasyGUI_radiobutton:%id%");</script>';

$components['password'] = 
'<input type="password" {attributes} name="%id%" style="{styles:!height}"  />';

$components['edit'] = 
'<input {attributes} name="%id%" style="{styles:!height}" value="%text%" ektype="Edit"/>
<script>widgets.push("EasyGUI_edit:%id%");</script>';

$components['maskedit'] = 
'<input type="text" {attributes} name="%id%" value="%text%" style="{styles:!height}"  />';

$components['hidden'] = 
'<input type="hidden" id="%id%" name="%id%" value="%text%"/>';

$components['groupbox'] = 
'<fieldset {attributes} name="%id%" style="margin: 0px; padding: 0px; {styles}" >
	<legend>%text%</legend>
</fieldset>';

$components['hiddentext'] = 
'<input type="hidden" id="%id%" name="%id%" value="%text%"/>';

$components['text'] = 
'<table cellspacing="0" cellpadding="0" style="{styles:position;top;left;width;height;backgroundcolor;visibility}" > 
	<tr> 
        <td {attributes:id;verticalalign;horizontalalign;style;onclicked;onmouseover;onmouseout} style="white-space: normal; {styles:textcolor;font;fontsize;bold;italic}" ektype="Text">%text%</td> 
    </tr> 
</table><script>widgets.push("EasyGUI_text:%id%");</script>';

$components['image'] =
'<img {attributes} style="{styles}"  />';

$components['table'] =
'<div {attributes:id} style="overflow: auto;  visibility: hidden; {styles:position;top;left;width;height}" >
	<table id="%id%_TABLE" tableid="%id%" {attributes} tablelayout="%tablelayout%" type="%type%" style="{styles:backgroundcolor;textcolor;font;fontsize;bold;italic}"  ektype="Table" >
		%components%
	</table>
</div>
<script>widgets.push("EasyGUI_table:%id%");</script>';


$components['basictable'] =
'<div {attributes:id} style="overflow: auto;  visibility: visible; {styles:position;top;left;width;height}" >
	<table basictable="true" id="%id%_TABLE" tableid="%id%" {attributes} style="{styles:backgroundcolor;textcolor;font;fontsize;bold;italic}"  ektype="Table" >
		%components%
	</table>
</div>
';

$components['htmltable'] =
'<table {attributes} style="{styles}" cellspacing="0">
	%components%
</table>';

$components['tr'] = 
'<tr {attributes} style="{styles}"  >
	%components%
</tr>';

$components['td'] =
'<td {attributes} style="{styles}" >%text%%components%</td>';

$components['iframe'] =
'<div id="%id%_IFRAME" style="{styles:position;left;top;width}" class="%style%">
	<iframe id="%id%" name="%id%" src="%src%" style="width: 100%; background-color: white; {styles:height}"  frameborder="%border%" onload="%onload%" ></iframe>
</div>';

$components['textarea'] = 
'<textarea {attributes} name="%id%" style="{styles}"  text="%text%" ektype="Edit"></textarea>
<script>widgets.push("EasyGUI_edit:%id%");</script>';

$components['script'] =
'<script type="text/javascript" {attributes} >
//<![CDATA[
	%cdata_value%
//]]>
</script>';

$components['staticscript'] = 
'<script type="text/javascript">
//<![CDATA[
	%handlerbody%
//]]>
</script>';

$components['menu'] =
'<div {attributes} style="display: none; {styles}" ektype="Menu" >
	%components%
</div><script>widgets.push("EasyGUI_Menu:%id%");</script>';

$components['menuitem'] = 
'<div style="display: none; {styles}" >
	<a {attributes} href="#" >(label|text)</a>
	%components%
</div>';

$components['treectrl'] = 
'<div {attributes} style="display: none; overflow: auto; {styles}" ektype="TreeCtrl" >
	%components%
</div><script>widgets.push("EasyGUI_TreeCtrl:%id%");</script>';

$components['treeitem'] =
'<div style="position: relative; display: none; {styles}"  >
	<a {attributes} href="#" style="display: block" ><nobr>(label|text)</nobr></a>
	%components%
</div>';

$components['tabctrl'] =
'<div {attributes} ektype="TabCtrl" style="{styles};" >
	%components%
</div><script>widgets.push("EasyGUI_TabCtrl:%id%");</script>';

$components['tabheader'] =
'<span tabtype="header" tabpanel="%id%" href="#" {attributes}>%components%</span>'; //<a href="#" onclick="switchTab(this)" >%text%</a>';

$components['tab'] = 
'<div {attributes} style="display: none" ctrltype="tabpanel">
	<a href="#" tabpanel="%id%" style="{styles:visibility;}">%text%</a>
	%components%
</div>';

$components['contextmenu'] = 
'<div {attributes} style="visibility: hidden; {styles}" ektype="ContextMenu">
	%components%
</div>
<script>widgets.push("EasyGUI_ContextMenu:%id%");</script>';

$components['contextmenuitem'] = 
'<a {attributes} style="{styles}" >%label%</a>';

$components['combobox'] =
'<select {attributes} name="%id%" style="{styles:!height}" ektype="Combobox" >
	%components%
</select>
<script>widgets.push("EasyGUI_combobox:%id%");</script>';

$components['option'] = 
'<option value="%value%">%components%</option>';

$components['listbox'] = 
'<select {attributes} name="%id%" style="{styles:!height}" size="2" ektype="Combobox">
	%components%
</select>
<script>widgets.push("EasyGUI_combobox:%id%");</script>';

$components['itemrow'] = 
'<tr {attributes} style="{styles}">
	%components%
</tr>';

$components['itemcell'] = 
'<td {attributes} style="{styles}">
	%text%
</td>';

$components['link'] = 
'<a {attributes} style="{styles};" >(label|text)</a>';

$components['hr'] =
'<hr {attributes} style="{styles};" />';

$components['h1'] = 
'<h1 {attributes} style="{styles};" >(label|text)</h1>';

$components['h2'] = 
'<h2 {attributes} style="{styles};" >(label|text)</h2>';

$components['h3'] = 
'<h3 {attributes} style="{styles};" >(label|text)</h3>';

$components['h4'] = 
'<h4 {attributes} style="{styles};" >(label|text)</h4>';

$components['h5'] = 
'<h5 {attributes} style="{styles};" >(label|text)</h5>';

$components['h6'] = 
'<h6 {attributes} style="{styles};" >(label|text)</h6>';

$components['border'] = 
'<div {attributes} style="{styles}" ></div>';

$components['ek_include'] = 
'%components%';

$components['htmltext'] =
'<div {attributes} style="{styles}" >
	%text%
</div>';

$components['div'] =
'<div {attributes} style="{styles}" >
	%components%
</div>';

$components['simple_container'] = 
'%components%';

$components['tdh']='<td {attributes} style="{styles}" >%cdata_value%</td>';

/**
 * Empty Components
 */
$components['tablecolumn'] = '<td {attributes} style="{styles}" >%headertext%%components%</td>';
$components['style'] = '';
$components['enhancedcombobox'] = '';
$components['default'] = '<%name%>%components%</%name%>';
$components['group'] = '<span id="%id%_GROUP" selected="%selected%" ></span>'; 
$components['puretext'] = '<span {attributes} style="{styles}">%text%</span>';
//?>