/**
 * @class Window Registry
 * @constructor
 * Class that handles Modal and non modal Dialogs
 *
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @package	js.win
 * @version $Id: class.winregistry.js 241 2007-02-06 11:00:54Z glauff $
 */
function windowRegistry()
{
	/**
	 * The Window Registry
	 * @type	array
	 */
	this.registry = new Array();
	
	/**
	 * Rgeisters a window in the registry
	 * @param	{string}	win
	 */
	this.registerWindow = function(win)
	{
		this.registry.push(win);
	};
	
	/**
	 * @returns The Window from the registry, FALSE otherwise
	 */
	this.getGuiWindow = function(id)
	{
		for (var i=0; i < this.registry.length; i++) {
			if (this.registry[i] != null) {
				if (this.registry[i].id == id) {
					return this.registry[i];
				}
			}
		}
		
		return false;
	};
	
	/**
	 * Starts an observer for a modal window
	 * @param	{string}	id
	 */
	this.startModalObserver = function(id)
	{
		var observable = this.getGuiWindow(id);
		
		if (!observable) {
			return;
		}
		
		observable.intervalHandler = setInterval("observeModalWindow('" + id + "')", 100);
	};
	
	/**
	 * Removes a window from the registry
	 * @param	{string}	id
	 */
	this.removeWindow = function(id)
	{
		for (var i=0; i < this.registry.length; i++) {
			if (this.registry[i] != null && this.registry[i].id == id) {
				this.registry[i] = null;
			}
		}
	};
}

/**
 * @param	{string}	id
 * @returns	void
 */
function observeModalWindow(id)
{
	var observable = dialog.winRegistry.getGuiWindow(id);

	if (observable.obj.closed == true) {
		clearInterval(observable.intervalHandler);
		dialog.winRegistry.removeWindow(id);
		dialog.enable();
	}
}

/**
 * @returns The window name
 */
function getWindowName()
{
	return self.name;
}

/**
 * Returns the window opener if one is set
 *
 * @returns The Window Opener,otherwise false
 */
function getOpener()
{
	if (self.opener == null) return false;	
	return self.opener;
}

/**
 * Returns the Top Window
 *
 * @returns The Top Window
 */
function getTopWindow()
{
	if (self.opener == null) return self;
	
	var win = self.opener;
	
	while (win.opener != null) {
		win = win.opener;
	}
	
	return win;
}