/**
 * @fileoverview EasyGUI Table Column Header Class
 *
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @package	js.widgets.table
 *
 * @version	$Id: class.tableheader.js 288 2008-01-15 17:40:20Z glauff $
 */
var EasyGUI_TableHeader = Class.create();

/**
 * Base Class for Table Headers
 *
 * @class EasyGUI_TableColumnHeader
 * @constructor
 * @param	{object}	table	Table Object
 * @private
 */ 
EasyGUI_TableHeader.prototype =
{
	id: null,
	header: null,
	headerTable: null,
	element: null,
	container: null,
	zIndex: 200,
	fl: 0,
	fc: 0,
	height: 0,
	width: 0,
	
	/**
	 * Initializes the Header
	 * @param	table	table object
	 * @returns	void
	 * @private
	 */
	initialize: function( table ) 
	{
		this.id 			= table.id;
		this.element 		= table.element;
		this.container 		= table.container;
		
		this.fl				= table.fixedLines;
		this.fc				= table.fixedColumns;
		
		this.header 		= table.container.cloneNode( true );
		this.table			= table;
		this.headerTable 	= this.header.down();
		
		//this.container.parentNode.appendChild( this.header );
		
		this.headerTable.setStyle( {
			position : 'absolute',
			width : this.container.clientWidth + 'px'
		});
		
		this.setHeight();
		this.setWidth();
		
		this.render();
		
		this.header.setStyle({
			overflow : 'hidden',
			zindex : this.zIndex
		});
	},
	
	/**
	 * @private
	 */
	removeHeaderInputs: function()
	{
		var table = $(this.id + '_FL_TABLE');
		if ( table ) {
			var edits = table.getElementsByTagName('input');
			
			for ( var j=0, jLen = edits.length; j < jLen; ++j ) {
				var el= edits[j];
				el.id = "__" + el.id + "__";
				el.name = "__" + el.id + "__";
				el.style.visibility = 'hidden';
			}
		}
		
		['select','input','textarea'].each( function(name,index) {
			for ( var i=0; i < this.fl; ++i ) {
				$(this.headerTable.rows[i]).select(name).each( function(el) {
					var id = el.id;
					var headerRow = el.parentNode;
					var headerElement = Element.remove(el);
					headerElement.id = "__" + id + "__";
					
					var tableElement = $(id);
					var tableRow = tableElement.parentNode;
					
					tableElement = Element.remove(tableElement);
					tableRow.appendChild(headerElement);
					headerRow.appendChild(tableElement);
					
					headerElement.style.visibility = 'hidden';
				});
			}
		}, this);
		
		for ( var i=0; i < this.fl; ++i ) {
			for ( var j=0, len = this.headerTable.rows[i].cells.length; j < len; ++j ) {
				var cell = this.headerTable.rows[i].cells[j];
				cell.id += '_FL';
			}
		}
	},

	/**
	 * @private
	 */
	setIframe: function() {
		if (is.ie5up) {
			this.header.iframeEl = this.header.parentNode.insertBefore( Util.getIframe(), this.header);
			this.header.iframeEl.id = this.headerIFrameId;
			
			Element.setPosition( this.header.iframeEl, this.header.offsetTop, this.header.offsetLeft );
			
			Element.show( this.header.iframeEl );
			//Element.setStyle( this.header.iframeEl, { 'position': 'absolute', 'z-index': this.zIndex - 1 } );
			
			this.header.iframeEl.style.position = 'absolute';
			this.header.iframeEl.zIndex = this.zIndex - 1;
			Element.setDimension(this.header.iframeEl, this.container.clientWidth, this.height);
		}
	},
	
	/**
	 * @private
	 */
	setWidth: function() {
		for (var i=0; i < this.fl; i++)
			this.width += parseInt(this.element.rows[0].cells[i].offsetWidth);
	},
	
	/**
	 * @private
	 */
	setHeight: function() {
		for (var i=0; i < this.fl; i++)
			this.height += parseInt(this.element.rows[i].offsetHeight);
			
		var tableBorderTop = parseInt( Element.getStyle( this.element, 'border-top-width' ) );
		
		if ( isNaN( tableBorderTop ) )
			tableBorderTop = 0;
			
		this.height += tableBorderTop;
	}
};
