/**
 * @fileoverview EasyGUI Table Row Header Class
 *
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @package	js.widgets.table
 *
 * @version	$Id: class.rowheader.js 286 2007-12-13 15:30:41Z glauff $
 */
var EasyGUI_TableRowHeader = Class.create();
/**
 * @class	EasyGUI_TableRowHeader
 * @constructor
 * @param	{object}	table	The Table Object
 * @returns	void
 * @private
 */
Object.extend( Object.extend( EasyGUI_TableRowHeader.prototype, EasyGUI_TableHeader.prototype ), 
{
	render: function()
	{
		this.header.id 	= this.id + '_FC';
		this.headerTable.id = this.header.id + "_TABLE";
		this.headerIFrameId = this.header.id + '_IFRAME';
		
		var header = $(this.header.id);
		var iframe = $(this.headerIFrameId);
		
		if ( header != null ) {
			header.remove();
		}
		
		if ( iframe != null ) {
			iframe.remove();
		}
		
		this.container.parentNode.appendChild( this.header );
		
		this.setIframe();
		
		Element.setDimension( this.header, this.width, this.container.clientHeight );
		
		this.removeHeaderInputs();
	},

	/**
	 * @private
	 */
	setWidth: function() {
		for (var i=0; i < this.fc; i++)
			this.width += parseInt(this.element.rows[0].cells[i].offsetWidth);
	}
});