/**
 * @fileoverview Fixed Header Class
 
 *
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @package	js.widgets.table
 *
 * @version	$Id: class.fixedheader.js 286 2007-12-13 15:30:41Z glauff $
 */
var EasyGUI_TableFixedHeader = Class.create();
/**
 * @class	EasyGUI_TableFixedHeader
 * @constructor
 * A fixed Header is positioned over all other headers
 * Used when a table has fixed Columns and Lines
 *
 * @param	{object}	table	The Table Object
 * @returns	void
 * @private
 */
Object.extend( Object.extend( EasyGUI_TableFixedHeader.prototype, EasyGUI_TableHeader.prototype ), 
{
	render: function()
	{
		this.zIndex 	= 400;	
		this.header.id 	= this.id + '_FIX';
		this.headerTable.id = this.header.id + "_TABLE";
		this.headerIFrameId = this.header.id + '_IFRAME';
		
		var header = $(this.header.id);
		var iframe = $(this.headerIFrameId);
		
		if ( header != null ) {
			header.remove();
		}
		
		if ( iframe != null ) {
			iframe.remove();
		}
		
		this.container.parentNode.appendChild( this.header );
		
		Element.setDimension( this.header, this.width, this.height );
	},
	
	/**
	 * @private
	 */
	setWidth: function() {
		for (var i=0; i < this.fc; i++)
			this.width += parseInt(this.element.rows[0].cells[i].offsetWidth);
	}
});
