/**
 * @fileoverview EasyGUI Table Column Header Class
 *
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @package	js.widgets.table
 *
 * @version	$Id: class.columnheader.js 286 2007-12-13 15:30:41Z glauff $
 */
var EasyGUI_TableColumnHeader = Class.create();
/**
 * This class creates the column header necessary if table has fixed lines
 *
 * @class EasyGUI_TableColumnHeader
 * @constructor
 * @param	{object}	table	Table Object
 * @private
 */ 
Object.extend( Object.extend( EasyGUI_TableColumnHeader.prototype, EasyGUI_TableHeader.prototype ), 
{
	render: function() 
	{
		this.zIndex		= 300;
		this.header.id 	= this.id + '_FL';
		this.headerTable.id = this.header.id + '_TABLE';
		this.headerIFrameId = this.header.id + '_IFRAME';
		
		var header = $(this.header.id);
		var iframe = $(this.headerIFrameId);
		
		if ( header != null ) {
			header.remove();
		}
		
		if ( iframe != null ) {
			iframe.remove();
		}
		
		this.container.parentNode.appendChild( this.header );
		
		this.setIframe();
		
		Element.setDimension(this.header, this.container.clientWidth, this.height);
		
		this.removeHeaderInputs();
	}
});