/**
 * @fileoverview EasyGUI Text
 * This widget creates a simple Text on the dialog
 *
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @package	js.widgets
 *
 * @version	$Id: class.text.js 286 2007-12-13 15:30:41Z glauff $
 */
var EasyGUI_text = Class.create();

/**
 * @class EasyGUI_Text
 * @constructor
 * @param	{string}	id	ID of widget to create
 * @returns	void
 * @access	public
 */
Object.extend( Object.extend( EasyGUI_text.prototype, EasyGUI_widget.prototype ), {
	text: '',
	
	render: function() {
		this.text = Element.getInnerText( this.element );
		return;
		
		this.text = Element.getAttributeValue( this.element, 'text' );
		
		if ( !this.text ) {
			this.text = Element.getInnerText( this.element );
			this.element.innerHTML = Element.getInnerText( this.element );
		}else {
			this.element.innerHTML = this.text;
		}
	},
	
	getText: function() {
		return this.text;
	},
	
	setText: function( text ) {
		this.text = text;
		this.element.innerHTML = text;
	},
	
	setPosition: function( top, left ) {
		var top = ( typeof top == 'string' ) ? top : top + 'px';
		var left = ( typeof left == 'string' ) ? left : left + 'px';
		
		this.element.up('table').setStyle({
			top : top,
			left: left
		});
	}
});