/**
 * @fileoverview EasyGUI Standard Radiobutton Functions
 *
 * @author 		Gaetan Lauff	<glauff@plansoft.de>
 * @package 	js.widgets
 *
 * @version		$Id: class.radiobutton.js 245 2007-02-19 15:13:48Z glauff $
 */
var EasyGUI_radiobutton = Class.create();

/**
 * @class EasyGUI_Radiobutton
 * @constructor
 * @param	{string} 	id
 */
Object.extend( Object.extend( EasyGUI_radiobutton.prototype, EasyGUI_widget.prototype ), {
	selected: null,
	checked: false,
	
	render: function() {
		this.group = document.forms[0].elements[this.element.name];
		this.groupElement = $( this.element.name + '_GROUP' );
		this.checked = Element.getAttributeValue( this.element, 'checked' );
		
		if (this.groupElement) {
			this.selected = Element.getAttributeValue( this.groupElement, 'selected' );
			this.switchRadio( this.selected );
		}
		
		if (this.checked) {
			this.reset();
			this.element.checked = true;
		}
		
		this.initialized = true;
	},
	
	/**
	 * Switches Radiobutton to a given value
	 * @param	{string}	value
	 * @fires	onclick event
	 * @access	public
	 */
	switchRadio: function ( value, fireEvent ) {
		var group 		= this.group;
		var fireEvent 	= (fireEvent || fireEvent == null) ? true : false;
		
		if (!group.length) {
			if ( group.value == value ) {
				group.checked = true;
			}
		} else {
			for (i=0; i < group.length; i++) {
				group[i].checked = false;
				
				if (group[i].value == value || group[i].id == value) {
					
					group[i].checked = true;
				
					if (this.initialized && document.fireEvent && fireEvent ) {
						bfired = group[i].fireEvent('onclick');
					}
				}
			}
		}
	},
	
	/**
	 * Returns the value of the currently checked radiobutton.
	 * 
	 * @returns the value of the checked radiobuttons
	 * @access public
	 */
	getValue: function () {
		var group = this.group;
		
		if ( !group.length ) {
			return group.value;
		} else {
			for (i=0; i < group.length; i++) {
				if (group[i].checked == true) {
					return group[i].value;
				}
			}
		}
		
		return false;
	},
	
	/**
	 * Alias for getValue
	 */
	getSelected: function()
	{
		return this.getValue();
	},
	
	/**
	 * Resets the radiogroup
	 *
	 * @access	public
	 */
	reset: function () {
		var group = this.group;
		
		if ( !group.length ) {
			group.checked = false;
		} else {
			for (var i=0; i < group.length; i++) {
				if (group[i].checked == true) {
					group[i].checked == false;
				}
			}
		}
	},
	
	hide: function() {
		var group = this.group;
		
		if ( !group.length ) {
			Element.hide( group );
		} else {
			for ( var i=0; i < group.length; i++ ) {
				Element.hide( group[i] );
			}
		}
	},
	
	show: function() {
		var group = this.group;
		
		if ( !group.length ) {
			Element.show( group );
		} else {
			for ( var i=0; i < group.length; i++ ) {
				Element.show( group[i] );
			}
		}
	}
});