/**
 * @fileoverview EasyGUI MenuTree Script
 *
 * This Class is just an Adapter for the EasyGUI TreeCtrl and
 * the EasyGUI Menu
 *
 * @author Gaetan Lauff <glauff@plansoft.de>
 * @package 	js.widgets
 * 
 * @version	$Id: class.menutree.js 241 2007-02-06 11:00:54Z glauff $
 */

/**
 * @class	EasyGUI_MenuTree
 * @constructor
 * @param	{string}	id	ID of Widget to create
 * @returns	void
 * @access	public
 */
var EasyGUI_MenuTree = Class.create();

Object.extend( Object.extend( EasyGUI_MenuTree.prototype, EasyGUI_widget.prototype ),
{ 
	/**
	 * @type	string
	 * @private
	 */
	modus: 'TreeCtrl',
	
	render: function() {
		this.modus = Element.getAttributeValue( this.element, 'modus', 'TreeCtrl' );
		
		if (this.modus == 'TreeCtrl') {
			this.element.setAttribute( 'ektype', 'TreeCtrl' );
			dialog.registerWidget( new EasyGUI_TreeCtrl( id ) );
		} else {
			this.domElement.setAttribute( 'ektype', 'Menu' );
			dialog.registerWidget( new EasyGUI_Menu( id ) );
		}
	}
});