/**
 * @fileoverview	EasyGUI TabCtrl Class
 * This Class creates a fully functional TabCtrl
 * If you want to style your own TabCtrl please consult
 * the EasyGUI XP Users Guide.
 * 
 * The TabCtrl was ported from 
 * Ext JS Library 1.1
 * Copyright(c) 2006-2007, Ext JS, LLC.
 *
 * @author	Gaetan Lauff <glauff@plansoft.de>
 * @package	js.widgets
 *
 * @version	$Id: class.tabctrl.js 275 2007-08-27 12:29:57Z glauff $
 */
var EasyGUI_ExtTabCtrl = Class.create();
/**
 * @Class EasyGUI_TabCtrl
 * @constructor
 * @param	{string}	id	ID of Widget
 * @returns	void
 * @access	public
 */
Object.extend( Object.extend( EasyGUI_ExtTabCtrl.prototype, EasyGUI_widget.prototype ),
{
	/**
	 * All Panels
	 *
	 * @var array
	 */
	panels: [],
	
	/**
	 * All Tabs
	 *
	 * @var array
	 */
	tabs: [],
	
	/**
	 * Selected Tab Index
	 *
	 * @var	integer
	 */
	selectedIndex: 0,
	
	/**
	 * @var object
	 */
	tabBody: {},
	
	selected: 0,
	
	/**
	 * Renders Ext Style Tab Ctrl
	 *
	 * @return void
	 */
	init: function() 
	{
		var panels = this.element.getElementsBySelector('div[ctrltype="tabpanel"]');
		
		if ( isEmptyValue(this.element.className) ) {
			this.element.className = 'easygui-tabs';
		}
		
		var tabStrip = document.createElement('div');
		tabStrip.className = this.getStyleDefinition('wrap');
		this.element.appendChild( tabStrip );
		
		this.tabBody = document.createElement('div');
		this.tabBody.className = this.getStyleDefinition('body');
		this.tabBody.style.height = this.element.getHeight() + "px";
		this.tabBody.style.position = 'relative';
		
		this.element.appendChild( this.tabBody );
		
		var html = '<div class="' + this.getStyleDefinition('strip-wrap') + '">';
		html += '<table class="' + this.getStyleDefinition('strip') + '" cellspacing="0" cellpadding="0" border="0">';
		html += '<tbody><tr></tr></tbody></table></div>';
		
		tabStrip.innerHTML = html;
		
		// Jetzt fgen wir die Strip Elemente hinzu
		stripEl = tabStrip.firstChild.firstChild.firstChild.firstChild;
		
		for (var i=0; i < panels.length; i++ ) {
			var text = panels[i].readAttribute('text');
			var col = document.createElement('td');
			
			var td = stripEl.insertCell(i);
			
			html = '<a href="#" class="' + this.getStyleDefinition('right') + '">';
			html += '<span class="' + this.getStyleDefinition('left') + '">';
			html += '<em class="' + this.getStyleDefinition( 'inner' ) + '">';
			html += '<span title="' + text + '" class="' + this.getStyleDefinition('text') + '">' + text + '</span>';
			html += '</em></span></a>';
			
			td.innerHTML = html;
			
			Event.observe( td, 'click', this.switchTab.bindAsEventListener(this), false);
			// Hier ziehen wir jetzt noch das Panel aus dem Document und fgen es wieder
			
			panels[i].firstDescendant().remove();
			panels[i].firstDescendant().remove();
			
			var panel = panels[i].remove();
			panel.addClassName( this.getStyleDefinition('item-body') );
			panel.setAttribute( 'widgetid', this.id );
			td.setAttribute('panelid', panel.id );
			td.onclick = panel.onclick;
			panel.onclick = null;
			
			this.tabBody.appendChild( panel );
		}
		
		this.panels = $(this.tabBody).getElementsBySelector('div[ctrltype="tabpanel"]');
		this.tabs = $(stripEl).childElements();
		this.element.addClassName( this.getStyleDefinition('top') );
		
		Form.insertHidden( this.id + '_EK_WIDGET_VALUE', '' );
		
		this.selected = this.element.readAttribute('selected') || 0;
	},
	
	/**
	 *
	 */
	finalize: function() 
	{
		this.switchTab( this.selected );
		this.initialized = true;
	},
	
	/**
	 * Returns ID of selected Rab
	 * 
	 * @return string
	 */
	getSelected: function()
	{
		return $F( this.id + '_EK_WIDGET_VALUE');
	},
	
	/**
	 * Return selected Tab Index
	 *
	 * @return	integer
	 */
	getSelectedIndex: function()
	{
		var selectedIndex = 0;
		
		this.tabs.each( function( tab, id ) {
			if ( tab.hasClassName('selected') ) {
				selectedIndex = id;
			}
		});
		
		return selectedIndex;
	},
	
	/**
	 * Returns tab
	 *
	 * @param	{object} tab
	 * @returns object
	 * @todo	implement
	 */
	getTab: function( node )
	{},
	
	/**
	 * Switches Tab from one to another
	 *
	 * @param	{object} tab
	 * @returns	void
	 */
	switchTab: function( evt )
	{
		var idx;
		var fieldId = this.id + '_EK_WIDGET_VALUE';
		
		if ( typeof evt == "object" ) {
			var el = Event.findElement(evt, 'td' );
			el.addClassName('selected');
			idx = el.cellIndex;
		} else {
			idx = evt;
		}
		
		this.tabs.each( function( tab, id ) {
			tab.removeClassName('selected');
			var panelid = tab.getAttribute('panelid');
			
			if ( idx == id || idx == panelid ) {
				tab.addClassName('selected');
				idx = id;
				
				$( fieldId ).value = panelid;
				tab.down('a').blur();
			}
		});
		
		this.panels.each( function( panel, id ) {
			panel.hide();
			
			if ( idx == id ) {
				panel.show();
			}
		});
	},
	
	/**
	 * hides a Tab
	 *
	 * @param	string/number	tab id/idx
	 * @access	public
	 * @todo	implement
	 */
	hideTab: function( idx )
	{
		if ( typeof tab == "number" ) {
			this.tabs[tab].hide();
		} else {
			this.tabs.each( function( tab, id ) {
				var panelid = tab.getAttribute('panelid');
				if ( idx == panelid ) {
					tab.hide();
				}
			});
		}
	},
	
	/**
	 * shows a hidden Tab again
	 *
	 * @param	string/number	tab id/idx
	 * @access	public
	 * @todo	implement
	 */
	showTab: function( idx )
	{
		if ( typeof tab == "number" ) {
			this.tabs[tab].show();
		} else {
			this.tabs.each( function( tab, id ) {
				var panelid = tab.getAttribute('panelid');
				if ( idx == panelid ) {
					tab.show();
				}
			});
		}
	},
	
	/**
	 * Sets new Text to tab
	 *
	 * @param	{string}	tab 	id of tab
	 * @param	{string}	text	new text
	 * @access	public
	 * @todo	implement
	 */
	setTabText: function( tab, text )
	{},
	
	/**
	 * Removes a tab from the Ctrl
	 *
	 * @param	string/number	tab id/idx
	 * @access	public
	 * @todo implement
	 */
	removeTab: function( tab )
	{},
	
	/**
	 * Disables a Tab
	 *
	 * @param	string/number	tab id/idx
	 * @access	public
	 * @todo implement
	 */
	disableTab: function( tab )
	{},
	
	/**
	 * Enables a Tab
	 *
	 * @param	string/number	tab id/idx
	 * @access	public
	 * @todo implement
	 */
	enableTab: function( tab )
	{}
});