/**
 * @fileoverview EasyGUI Rich Edit Boxes
 * This Class creates One- or multiline Edit Boxes
 *
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @package	js.widgets
 *
 * @version	$Id: class.edit.js 248 2007-02-27 10:57:20Z glauff $
 */
var EasyGUI_edit = Class.create();
/**
 * @class EasyGUI_Edit
 * @constructor
 * @param	{string}	id	ID of widget to create
 * @returns	void
 * @access	public
 */
Object.extend( Object.extend( EasyGUI_edit.prototype, EasyGUI_widget.prototype ), {
	multiline: false,
	maxlength: null,
	value: null,
	defaultText: '',
	
	/**
	 * Renders the Component
	 */
	render: function() {
		this.multiline = Element.getAttributeValue( this.element, 'multiline' );
		this.value = Element.getAttributeValue( this.element, 'value' );
		
		if ( this.multiline ) {
			this.maxlength = Element.getAttributeValue( this.element, 'maxlength' );
			this.value = Element.getAttributeValue( this.element, 'text' );
		}
			
		this.defaultText = Element.getAttributeValue( this.element, 'defaulttext', '');

		if (!this.value) {
			if(this.defaultText){
				this.element.value = this.defaultText.replace(/(<br\s+\/>|<br>|\\\\r\\\\n|\\r\\n)/g, '\r\n');
			}
		} else {
			this.element.value = this.value.replace(/(<br\s+\/>|<br>|\\\\r\\\\n|\\r\\n)/g, '\r\n');
		}

		Event.observe(this.element, "focus", this.onFocus.bindAsEventListener(this) );
		Event.observe(this.element, "blur", this.onBlur.bindAsEventListener(this));
		
		if (this.multiline)
			 Event.observe(this.element, "keyup", this.onKeyUp.bindAsEventListener(this));
		
		this.element.blur();
	},
	
	/**
	 * Event Listener
	 */
	onFocus: function() {
		this.delDefaultText();
		this.selectText();
	},
	
	/**
	 * Event Listener
	 */
	onBlur: function() {
		this.setDefaultText();
	},
	
	/**
	 * Event Listener
	 */
	onKeyUp: function() {
		this.checkMaxLength();
	},
	
	/**
	 * Deletes the Default text in the component
	 * @returns	void
	 * @private
	 */
	delDefaultText: function() {
		if ( this.defaultText && ( $F(this.element) == this.defaultText ) ) {
			this.element.value = '';
		}
	},
	
	/**
	 * Sets the default text to a given value
	 * @returns	void
	 * @private
	 */
	setDefaultText: function() {
		if ( this.defaultText && ($F(this.element) == '') ) {
			this.element.value = this.defaultText;
		}
	},
	
	/**
	 * Marks the whole text in the widget
	 * @returns	void
	 * @private
	 */
	selectText: function() {
		this.element.select();
	},
	
	/**
	 * This method checks the maxlength attribute of a given element
	 * If the maxlength is depassed the value of the element is set
	 * to the maxlength
	 * @returns void
	 * @private
	 */
	checkMaxLength: function() {
		if (this.maxlength && (parseInt($F(this.element).length) > this.maxlength) )
			this.element.value = $F(this.element).substring(0, this.maxlength);
	},
	
	/**
	 * Updates the Widget
	 */
	update: function() {
		this.init();
	},
	
	/**
	 * Sets widget readonly
	 *
	 * @returns	void
	 * @access	public
	 */
	setReadonly: function() 
	{
		this.element.readOnly = true;
	},
	
	/**
	 * Sets widget read/write
	 *
	 * @returns	void
	 * @access	public
	 */
	setReadWrite: function() 
	{
		this.element.readOnly = false;
	},
	
	/**
	 * Alias for setValue
	 */
	setText: function( value ) 
	{
		this.setValue( value );
	},
	
	getText: function()
	{
		return this.getValue();
	},
	
	getValue: function()
	{
		return this.element.value;
	}
});