/**
 * @fileoverview EasyGUI Combobox Widget
 * @author	Gaetan Lauff <glauff@plansoft.de>
 * @package js.widgets
 * @version $Id: class.combobox.js 294 2008-02-26 15:21:50Z glauff $
 */

/**
 * @class EasyGUI_Combobox
 * @constructor
 * @param	{string}	id	ID of widget to create
 * @returns	void
 * @access	public
 */
var EKCombos = {};
var EasyGUI_combobox = Class.create();

Object.extend( Object.extend( EasyGUI_combobox.prototype, EasyGUI_widget.prototype ),
{
	active: false,
	/**
	 * @type	string
	 * @private
	 */
	bgColor: 'white',
	
	/**
	 * @type	string
	 * @private
	 */
	textColor: 'black',
	
	/**
	 * @type	string
	 * @private
	 */
	bgColorHl: 'highlight',
	
	/**
	 * @type	integer
	 * @private
	 */
	leftPos: 0,
	
	/**
	 * @type	integer
	 * @private
	 */
	topPos: 0,
	
	/**
	 * @type	string
	 * @private
	 */
	itemList: '',
	
	/**
	 * @type	string
	 * @private
	 */
	selected: null,
	
	/**
	 * @type	boolean
	 * @private
	 */
	isEnhanced: false,
	
	/**
	 * @type	boolean
	 * @private
	 */
	isAddRemove: false,
	
	/**
	 * @type	boolean
	 * @private
	 */
	isInTable: false,
	
	/**
	 * @type	object
	 * @private
	 */
	addButton: null,
	
	/**
	 * type 	object
	 * @private
	 */
	removeButton: null,
	
	/**
	 * type 	object
	 * @private
	 */
	comboButton: null,
	
	/**
	 * type 	object
	 * @private
	 */
	optionList: null,
	
	/**
	 * type 	object
	 * @private
	 */
	targetList: null,
	
	/**
	 * type 	object
	 * @private
	 */
	textDisplay: null,
	
	/**
	 * type		integer
	 * @private
	 */
	textDisplayColumn: null,
	tableId : '',
	
	render: function() 
	{
		var tabCtrl = null;

		if ( tabid = Element.isInTab( this.id ) ) {
			tabCtrl = dialog[$( tabid ).getAttribute('widgetid')];
			tabCtrl.switchTab( tabid );
		}
		
		this.bgColor	= Element.getStyle( this.element, 'background-color', this.bgColor );
		this.bgColor 	= (this.bgColor == 'transparent') ? 'white' : this.bgColor;
		
		this.textColor 	= Element.getStyle( this.element, 'color', this.textColor );
		
		this.leftPos 	= this.getPageOffsetLeft();
		this.topPos  	= this.getPageOffsetTop();
	
		var items = Element.getAttributeValue( this.element, 'items' );
	
		this.setItemList(items);
		
		this.selected		= Element.getAttributeValue(this.element, 'selected', this.selected );
		
		this.isEnhanced 	= Element.getAttributeValue(this.element, 'enhanced' );
		this.isAddRemove 	= Element.getAttributeValue(this.element, 'addremove' );
		this.multiple		= this.element.readAttribute('multiple') || false;
		
		if ( this.multiple )
			this.selectedList = this.selected.split('|');
		
		this.displayTextColIdx = parseInt( Element.getAttributeValue( this.element, 'displaycol', 1 ) );
		this.displayTextColIdx--;
		
		if ( this.displayTextColIdx < 0 ) this.displayTextColIdx = 0;
		
		this.element.observe('change', this.onChange.bindAsEventListener(this));
		
		if ( isEmptyValue(this.element.className) )
			this.element.className = 'easygui-combobox';
			
		if ( this.isInTable || this.element.parentNode.nodeName.toLowerCase() === "td") {
			//this.tableId = this.element.up('table[ektype="Table"]' ).readAttribute('tableid');						
			
			//this.table = dialog[this.tableId];
			
			this.isInTable = true;
			this.column		= this.element.up('td');
			
			this.columnId = this.element.parentNode.id;
			this.posTable = document.createElement('table');
			
			this.posTable.cellSpacing = 0;
			this.posTable.cellPadding = 0;
			this.posTable.border = 0;
		
			this.posTr = this.posTable.insertRow(0);
			this.textDisplayColumn = this.posTr.insertCell(0);
			this.comboButtonColumn = this.posTr.insertCell(1);
		}
				
		if (this.isEnhanced) {
			this.createEnhancedCombo();
			Element.hide( this.element );
			Event.observe(document, 'click', this.closeCombo.bindAsEventListener(this), false);
		} else if (this.isAddRemove) {
			this.createAddRemoveBox();
		} else {
			this.setOptionList();

			this.element.style.margin 	= '0px';
			this.element.style.padding 	= '0px';
			
			/*
			Think over this part.
			Deactivated at the moment.
			if (this.isInTable && (is.ie5 || is.ie6)) {
				this.setTextDisplay();
				this.setComboButton();
				
				//var column = $GE( this.columnId );
				this.column.appendChild( this.posTable );
				
				this.element.style.display = 'none';
				this.element.style.marginTop = '1px';
				
				Event.observe( this.textDisplay, 'mouseover', this.showCombo.bindAsEventListener( this ), false );
				Event.observe( this.comboButton, 'mouseover', this.showCombo.bindAsEventListener( this ), false );
				Event.observe( this.element, 'mouseout', this.hideCombo.bindAsEventListener( this ), false );
				Event.observe( this.element, 'change', this.setComboValue.bindAsEventListener( this ), false );
			}
			*/
		}
	
		if ( tabCtrl != null ) {
			tabCtrl.switchTab( tabCtrl.getSelected() );
		}
	},
	
	onChange : function(evt) {
		var value = this.getSelected();
		
		if ( typeof this.items == 'object' ) {
			for ( var id in this.items ) {
				if ( id == value ) {
					this.element.fire('combo:change', { id: this.id, value: this.getSelected() } );
					this.selected = value;
					break;
				}
			}	
		} else {
			for (var i=0, len = this.items.length; i < len; ++i ) {
				if ( this.items[i].value == value && (this.items[i].disabled === false || this.items[i].disabled === undefined )) {
					this.element.fire('combo:change', { id: this.id, value: this.getSelected() } );
					this.selected = value;
					break;
				}
			}
		}
	},
	
	setItemList: function( items ) 
	{	
		this.items = {};
		
		if ( !items )
			return;
		
		if ( typeof items == "string" ) {
			if ( items && items.indexOf('=') == -1 && items.indexOf('|') == -1 && items.indexOf('{') == -1 )
				items = items + "=" + items;
			
			this.items = Util.getJSObject( items );
			
			if ( !this.items ) {
				this.items = {};
				items = items.split('|');
			
				if ( items.length > 0 ) {
					for (var i=0; i < items.length; i++) {
						if ( items[i] == '' )
							continue;
						 
						var option = items[i].split('=');

						if ( option.length == 1 ) {
							option[1] = option[0];
						}
						
						this.items[option[0]] = option[1].split('#');
					}
				}
			}
		} else {
			this.items = items;
		}
	},
	
	/**
	 * Method to set optionlist in combobox
	 * @returns	void
	 * @private
	 */
	setOptionList: function( obj )
	{
		
		if ( obj != null ) {
			this.items = obj;
		} else if ( typeof EKCombos[this.id] != "undefined" ) {
			this.items = EKCombos[this.id];
		}
		
		if (this.isEnhanced) 
		{
			this.setEnhancedOptionList( obj );
		} 
		else 
		{
			this.element.options.length = this.items.length;
			var options = "";
			
			if ( typeof this.items == "object" && this.items instanceof Array ) 
			{
				for ( var i=0; i < this.items.length; i++ ) 
				{
					var item = this.items[i];
					
					if ( typeof item.value != "undefined" ) {
						this.element.options[i] = new Option( '', item.value, false, false );
						this.element.options[i].innerHTML = item.text;
						
						if ( this.multiple ) {
							if ( this.selected !== false && this.selectedList.indexOf(item.value) !== -1 ) {
								this.element.options[i].selected = true;
							}
						} else {
							if ( this.selected !== false && item.value == this.selected ) {
								this.element.options[i].selected = true;
							}
						}
						// Not working in IE
						if ( typeof item.disabled != "undefined" && item.disabled ) {
							this.element.options[i].disabled = true;
						}
						
						if ( item.style === undefined ) {
							this.element.options[i].style.backgroundColor = 'white';
						} else {
							this.element.options[i].className = item.style;
						}						
					} else {
						for ( var id in item ) 
						{
							if ( item.hasOwnProperty(id) ) 
							{
								var text = item[id];
								this.element.options[i] = new Option( '', id, false, false );
								this.element.options[i].innerHTML = text[0];
								
								if ( this.multiple ) {
									if ( this.selectedList !== false && this.selectedList.indexOf(id) !== -1 ) {
										this.element.options[i].selected = true;
									}
								} else {
									if ( this.selected !== false && id == this.selected ) {
										this.element.options[i].selected = true;
									}
								}
							}
						}
					}
				}
			} 
			else 
			{
				var i=0;
				
				for ( idx in this.items ) {
					if ( this.items.hasOwnProperty( idx ) ) {
						var text=this.items[idx][0].replace(/&equal;/g,"=");
						this.element.options[i] = new Option('', idx, false, false);
						this.element.options[i].innerHTML = text;
						
						if (this.multiple) {
							if ( this.selectedList !== false && this.selectedList.indexOf(idx) !== -1 ) {
								this.element.options[i].selected = true;
							}
						} else {
							if ( this.selected !== false && idx == this.selected ) {
								this.element.options[i].selected = true;
							}
						}
						i++;
					}
				}
			}	
		}
	},
	
	/**
	 * @private
	 */
	setEnhancedOptionList: function( obj ) 
	{
		if ( obj != null ) {
			this.items = obj;
		} else if ( typeof EKCombos[this.id] != "undefined" ) {
			this.items = EKCombos[this.id];
		}
		
		//var optionList			= document.createElement('TABLE');
		var optionList			= new Element('TABLE');
		
		optionList.className 	= this.element.className + '-options';
		//optionList.style.width	= "100%";
		optionList.cellPadding 	= 0;
		optionList.cellSpacing 	= 0;
		optionList.border		= 0;
		
		optionList.style.borderWidth 	= '0px';
		optionList.style.padding 		= '0px';
		
		var length = this.items.length;
		
		if ( typeof this.items == "object" && this.items instanceof Array ) 
		{
			for ( var i=0; i < this.items.length; i++ ) 
			{
				var item = this.items[i];
				
				if ( typeof item.value != "undefined" ) {
					if ( typeof item.text == "string" )
						item.text = [item.text];
					
					this.insertEnhancedOption( optionList, item, i );
				} else {
					for ( var id in item ) 
					{}
				}
			}
		} else {
			var i=0;
			
			for ( idx in this.items ) 
			{
				var selected 	= false;
				var options 	= this.items[idx];
				
				this.insertEnhancedOption(optionList, { value: idx, text: options }, i);
				i++;
			}
		}
		
		document.body.appendChild(optionList);
		var dim = optionList.getWidth();
		
		this.optionList = optionList.remove();
		this.optionList.style.width = "100%";
		this.setOptionsContainer(dim);
	},
	
	insertEnhancedOption : function (optionList, item, i ) 
	{
		var idx = item.value;
		var options 	= item.text;
		var row 		= $(optionList.insertRow(i));
		
		row.className	= this.element.className + '-rows';
		row.style.backgroundColor = 'white';
		
		Event.observe( row, 'click', this.onOptionClick.bindAsEventListener(this) );
		Event.observe( row, 'mouseover', this.onOptionOver.bindAsEventListener(this) );
		Event.observe( row, 'mouseout', this.onOptionOut.bindAsEventListener(this) );
		
		row.writeAttribute( 'value', idx );
		
		if ( typeof item.disabled != "undefined" && item.disabled ) {
			row.writeAttribute( 'disabled', true );
			row.addClassName( 'disabled' );
		}
		
		if ( typeof item.style != "undefined" ) {
			row.addClassName( item.style );
		}
		
		var selected = false;
		
		if ( this.selected !== false && ( idx == this.selected || i == this.selected ) )
		{
			selected = true;
		}
			
		for (var k=0; k < options.length; k++) 
		{
			var text 		= options[k];
			
			var cellValue 	= (text == '') ? '&nbsp;' : text;
			var cell 		= $(row.insertCell(k));
			
			cell.style.padding 	= '2px';
			cell.style.color 	= this.textColor;
			
			cell.update( cellValue );
			
			if (k == this.displayTextColIdx)
			{
				row.setAttribute( 'displayText', text );
				
				if (selected) 
				{
					this.element.options[i] = new Option(text, this.selected, false, true);
					this.textDisplay.value = text;
				}
			}
		}
	},
	
	onOptionOver: function(evt) 
	{
		var row = Event.element(evt).up('tr.' + this.element.className + '-rows' ); //$GE(evt).parentNode;
		
		if ( row === undefined ) return;
		
		if ( row.readAttribute('disabled') == "true" )
			return;
			
		row.style.backgroundColor = ( color = row.getAttribute('bgColorHl') ) ? color : this.bgColorHl;
		
		if ( ! (cells = row.cells) )
		{
			return;
		}
		
		var textColorHl = (color = row.getAttribute('textColorHl') ) ? color : this.textColorHl;
		var length 		= cells.length;
		
		for ( i=0; i < length; i++ ) 
		{
			cells[i].style.color = textColorHl;
		}
		
		Event.stop( evt );
	},
	
	onOptionOut: function(evt)
	{
		//var row = Event.element(evt).up(); //$GE(evt).parentNode;
		var row = Event.element(evt).up('tr.' + this.element.className + '-rows' ); //$GE(evt).parentNode;
		
		if ( row === undefined ) return;
		
		if ( row.readAttribute('disabled') == "true" )
			return;
			
		row.style.backgroundColor = ( color = row.getAttribute('bgColor') ) ? color : this.bgColor;
		var cells = row.cells;
		
		if ( ! (cells) )
		{
			return;
		}

		var textColor 	= (color = row.getAttribute('textColor') ) ? color : this.textColor;
		var length		= cells.length;
		
		for ( i=0; i < length; i++ )
		{
			cells[i].style.color = textColor;
		}
			
		Event.stop( evt );
	},
	
	onOptionClick: function(evt)
	{
		//var row = Event.element(evt).up();//$GE(evt).parentNode;
		var row = Event.element(evt).up('tr.' + this.element.className + '-rows' ); //$GE(evt).parentNode;
		
		if ( row === undefined ) return;
		
		if ( row.readAttribute('disabled') == "true" )
			return;
			
		if ( ! row.cells )
		{
			return;
		}
		
		this.element.options[0] = new Option( row.getAttribute('value'), row.getAttribute('value'), false, true );
		
		this.textDisplay.value 			= row.getAttribute('displayText');
		this.textDisplay.style.color 	= this.textColor;
		
		if ( this.element.onchange )
		{
			this.element.onchange.call( this.element );
		}
		
		this.element.fire('combo:change', { id: this.id, value: this.getSelected() } );
	},
		
	
	/**
	 * Implementation of an Enhanced Combobox
	 * @returns	void
	 * @private
	 */
	createEnhancedCombo: function()
	{
		this.element.style.visibility = 'hidden';
		
		if (this.isInTable)
		{
			var select = this.element.parentNode.removeChild( this.element );
			this.element = select;
			
			var combo = $(document.forms[0]).down('select[id="' + this.id + '"]' );
			
			if ( combo )
				document.forms[0].removeChild( combo );
				
			document.forms[0].appendChild( this.element );
		}
		
		this.bgColorHl 		= Element.getAttributeValue( this.element, 'backgroundcolorhighlight', 'highlight');
		this.textColorHl 	= Element.getAttributeValue( this.element, 'textcolorhighlight', 'highlighttext');
		
		this.setTextDisplay();
		this.setComboButton();
		
		Event.observe(this.textDisplay, 'click', this.toggleCombo.bindAsEventListener(this), false);
		Event.observe(this.comboButton, "click", this.toggleCombo.bindAsEventListener(this), false);
		
		if (this.isInTable)
		{
			var column = $GE( this.columnId );
			column.appendChild( this.posTable );
		}
		
		this.setEnhancedOptionList();
	},
	
	
	/**
	 * Creates the input field for Combobox
	 * @returns	void
	 * @private
	 * @todo 	Implement an editable searchable Combobox
	 */
	setTextDisplay: function()
	{
		var textDisplay = new Element('input'); //document.createElement('INPUT');
		
		textDisplay.className 		= 'easygui-combobox-textdisplay';
		
		if ( is.ie5 || is.ie5_5 ) 
		{
			textDisplay.className 		= 'easygui-combobox-textdisplay-ie5';
		}
		
		textDisplay.readOnly 		= true;
		
		if ( this.element.selectedIndex > -1 )
			textDisplay.value			= this.element.options[this.element.selectedIndex].text;
		
		var padding = '0px';
		var paddingLeft = '4px';
		var paddingTop = '2px';
		
		var height = '18px';
		var width  = parseInt( this.getOffsetWidth() ) - 24 + 'px';
		
		if (is.ie5 || is.ie5_5) 
		{
			height = '22px';
			width  = parseInt( this.getOffsetWidth() ) - 18 + 'px';
		}
	
		if (is.ie5 || is.ie5_5)
		{
			paddingLeft = '3px';
			paddingTop = '1px';
		}
		
		textDisplay.style.backgroundColor = this.bgColor;
		textDisplay.style.color = this.textColor;
		textDisplay.style.height = height;
		textDisplay.style.width = width;
		
		/*
		textDisplay.style.padding = padding;
		textDisplay.style.paddingLeft = paddingLeft;
		textDisplay.style.paddingTop = paddingTop;
		*/
		
		//var editable = Element.getAttributeValue(this.element, 'editable' );
	
		//if (editable) {
			/**
			 * @todo implement editable Combobox
			 */
			/*
			textDisplay.readOnly = false;
			easygui.addEventHandler(textDisplay, 'blur', closeActiveCombo, false);
			*/
		//}
	
		//Event.observe( textDisplay, 'mouseover', this.setHighlightColors.bindAsEventListener(this), false);
		//Event.observe( textDisplay, 'mouseout', this.setNormalColors.bindAsEventListener(this), false);
		
		
		if (this.isInTable)
		{
			textDisplay.style.position = 'relative';
			this.textDisplayColumn.appendChild( textDisplay );
		} 
		else 
		{
			var offset = this.element.positionedOffset();
			Element.setPosition( textDisplay, offset.top, offset.left );
			//document.body.appendChild( textDisplay );
			this.element.up().insert(textDisplay);
		}
		
		this.textDisplay = textDisplay;
	},
	
	/**
	 * Creates the Button to open Combobox
	 * @returns	void
	 * @private
	 */
	setComboButton: function()
	{
		var comboButton 		= new Element('img'); //document.createElement('IMG');
		
		comboButton.style.padding = '1px';
		
		var border 		= '1px solid #7f9db9';
		var borderLeft 	= '1px solid #ffffff';
			
		if (is.ie5 || is.ie5_5)
		{
			var border = '2px inset';
			var borderLeft = '0px solid #ffffff';
		} 

		comboButton.style.backgroundColor = 'white';
		comboButton.style.border = border;
		comboButton.style.borderLeft = borderLeft;
				
		if ( is.winxp && (is.ie6up || is.gecko) )
		{
			comboButton.src = Element.getAttributeValue(this.element, 'combobuttonsrc', ek_path + '/gfx/combobut_xp.gif');
			comboButton.mouseoverimage = Element.getAttributeValue(this.element, 'combobuttonhlsrc', ek_path + '/gfx/combobut_xp_hl.gif');
			
			if (is.ie6up) {
				Event.observe(comboButton, "mouseover", flipImage, false);
				Event.observe(comboButton, "mouseout", flipImage, false);
			}
		} 
		else if (is.winvista && (is.ie6up || is.gecko) ) {
			comboButton.src = Element.getAttributeValue(this.element, 'combobuttonsrc', ek_path + '/gfx/combobut_vista.gif');
			comboButton.mouseoverimage = Element.getAttributeValue(this.element, 'combobuttonhlsrc', ek_path + '/gfx/combobut_vista_hl.gif');
			
			if (is.ie6up) {
				Event.observe(comboButton, "mouseover", flipImage, false);
				Event.observe(comboButton, "mouseout", flipImage, false);
			}
		}
		else 
		{
			comboButton.src = Element.getAttributeValue(this.element, 'combobuttonsrc', ek_path + '/gfx/combobut.gif');
			comboButton.mouseoverimage = Element.getAttributeValue(this.element, 'combobuttonhlsrc', ek_path + '/gfx/combobut_hl.gif');
		}
		
		this.comboButton = comboButton;
		
		if (this.isInTable) 
		{
			this.comboButtonColumn.appendChild( this.comboButton);
		} 
		else 
		{
			var offset = this.element.positionedOffset();
			this.comboButton.style.position = 'absolute';
			Element.setPosition( this.comboButton, offset.top, offset.left + this.textDisplay.offsetWidth );
			this.element.up().insert(this.comboButton);
			//document.body.appendChild( this.comboButton );
		}
	},
	
	/**
	 * @private
	 */
	setOptionsContainer: function(dim)
	{
		if (this.optionsContainer != null)
		{
			this.optionsContainer = null;
		}
		
		var width = this.element.getWidth();
		
		if ( dim > width ) width = dim;
		
		if ( is.ie6up )
			width += 22;
			
		var optionsContainer 	= document.createElement('DIV');
		
		var droppedWidth 		= parseInt( this.element.readAttribute('droppedwidth')) || width;
		var droppedHeight 		= parseInt( this.element.readAttribute('droppedheight')) || 100;

		this.droppedHeight 		= droppedHeight;
		
		optionsContainer.className 	= this.element.className + '-optionsContainer';
		
		optionsContainer.style.overflowX 	= 'hidden';
		optionsContainer.style.overflowY 	= 'auto';
		optionsContainer.style.position 	= 'absolute';
		optionsContainer.style.border 		= '1px solid black';
		
		Element._hide( optionsContainer );
		
		optionsContainer.appendChild(this.optionList);
		
		document.body.appendChild(optionsContainer);
		
		var optionsHeight = parseInt(this.optionList.offsetHeight);
		var optionsWidth = parseInt(this.optionList.offsetWidth);
		
		if (droppedHeight > optionsHeight)
		{
			droppedHeight = optionsHeight;
		}
		
		Element.setDimension(optionsContainer, droppedWidth, droppedHeight);
		Element.setPosition(optionsContainer, 0, 0);
	
		this.optionsContainer = optionsContainer;
		
		if (is.ie5up)
		{
			optionsContainer.iframeEl = optionsContainer.parentNode.insertBefore( Util.getIframe(), optionsContainer);
			
			Element.hide( optionsContainer.iframeEl );
			optionsContainer.iframeEl.style.position = "absolute";
		}
	},
	
	/**
	 * This function opens the combobox
	 *
	 * @private
	 */
	toggleCombo: function( evt )
	{
		if (this.active)
		{
			this.closeCombo();
			return;
		}

		this.openCombo();
		Event.stop( evt );
	},
	
	openCombo: function()
	{
		this.active = true;
		
		var container 	= this.optionsContainer;
		var display 	= this.textDisplay;
		//var table 		= dialog[this.tableId]; //this.table;
		
		var height = this.optionList.offsetHeight;
		
		if ( this.droppedHeight > height ) {
			this.droppedHeight = height;
		}
		
		container.style.height = this.droppedHeight + 'px';
		
		var pos = display.cumulativeOffset();
		
		var left 	= pos.left;
		var top 	= pos.top + display.offsetHeight;
		
		if (this.isInTable)
		{
			var scrollOffset = display.cumulativeScrollOffset();
			
			left 	-= scrollOffset.left;
			top 	-= scrollOffset.top;
		}
		
		var openHeight 	= top + container.offsetHeight;
		var innerHeight = Dialog.getInnerHeight();
			
		if ( openHeight > innerHeight )
		{
			top = top - display.offsetHeight - container.offsetHeight;
		}
		
		Element.setPosition(container, top , left );
		
		if (this.optionsContainer.iframeEl != null)
		{
			var iframeEl = container.iframeEl;
			
			Element.setPosition( iframeEl, container.style.top,  container.style.left);
			Element.setDimension( iframeEl, container.offsetWidth, container.offsetHeight);
	    	
			Element.show( container.iframeEl );
		}
		
		container.style.visibility = 'visible';
		container.style.zIndex = 100000;
	},
	
	/**
	 * Closes Combobox
	 * @private
	 */
	closeCombo: function( evt )
	{
		this.active = false;
		this.optionsContainer.style.visibility = 'hidden';
		
		if (this.optionsContainer.iframeEl != null)
		{
	      	Element.hide( this.optionsContainer.iframeEl );
		}
	},
	
	/**
	 * Shows Combo
	 * when nested inside a table.
	 * @todo implement
	 */
	showCombo : function(evt) {
		return false;
	},
	
	/**
	 * Hides Combo
	 * when nested inside a table
	 * @todo implement
	 */
	hideCombo : function(evt) {
		return false;
	},
	
	/**
	 * Implementation of Multiple List Combobox
	 * @private
	 */
	createAddRemoveBox: function()
	{
		var element = this.element;

		this.setOptionList();
		var width = (this.getOffsetWidth() / 2 - 25) + 'px';
		
		element.style.width = width;
		
		var leftOffset = this.leftPos + this.getOffsetWidth();
		targetList = element.cloneNode(false);
		targetList.multiple = true;
		
		element.setAttribute('id', this.id + '_SOURCE');
		element.setAttribute('name', this.id + '_SOURCE');
	
		targetList.style.position = 'absolute';
		targetList.style.zIndex = 0;
		
		Element.setPosition( targetList, this.topPos, leftOffset + 50 );
		
		var topOffset 	= this.topPos + (this.getOffsetHeight() / 2);
		
		this.addButton 		= Element.create('button', this.id + '_ADD_BUTTON', 23, 23, (leftOffset + 12), (topOffset - 23) );
		this.removeButton 	= Element.create('button', this.id + '_REMOVE_BUTTON', 23, 23, (leftOffset + 12), (topOffset) );
		
		this.addButton.style.position = 'absolute';
		this.addButton.style.padding = '0px';
		this.addButton.style.fontFamily = 'Arial, sans serif';
		this.addButton.style.fontSize = '12px';
		
		this.removeButton.style.position = 'absolute';
		this.removeButton.style.padding = '0px';
		this.removeButton.style.fontFamily = 'Arial, sans serif';
		this.removeButton.style.fontSize = '12px';
		
		this.addButton.innerHTML 	= '<b>>></b>';
		this.removeButton.innerHTML = '<b><<</b>';
		
		Event.observe(this.addButton, 'click', this.addItems.bindAsEventListener( this ), false);
		Event.observe(this.removeButton, 'click', this.removeItems.bindAsEventListener(this), false);
		
		this.targetList = targetList;
		
		document.forms[0].appendChild(this.targetList);
		document.body.appendChild(this.addButton);
		document.body.appendChild(this.removeButton);
	},
	
	/**
	 * Method to remove items from target listbox
	 * @private
	 */
	removeItems: function()
	{
		var tgtList = this.targetList;
		
		for (var i = tgtList.length - 1; i >= 0; i--)
		{
			if (tgtList.options[i].selected)
			{
				tgtList.options[i] = null;
				i = tgtList.length;
			}
		}
	},
	
	/**
	 * Method to add items to target listbox
	 * @private
	 */
	addItems: function()
	{
		var srcList = this.element;
		var tgtList = this.targetList;
		
		for ( var i = 0; i < srcList.options.length; i++ )
		{
			if ( srcList.options[i].selected )
			{
				var tgtListIdx 	= tgtList.length;	
				var exists 		= false;
				
				for (var j=0; j < tgtList.length; j++)
				{
					if (srcList.options[i].value == tgtList.options[j].value)
					{
						exists = true;
					}
					
					tgtList.options[j].selected = true;
				}
				
				if (!exists)
				{
					tgtList.options[tgtListIdx] = new Option(srcList.options[i].text, srcList.options[i].value, false, false);
					tgtList.options[tgtListIdx].selected = true;
				}			
			}
		}
		
		srcList.selectedIndex = -1;
	},
	
	/**
	 * @private
	 */
	update: function()
	{
		this.init();
	},
	
	/**
	 * Disables the combobox
	 *
	 * @access public
	 * @returns	void
	 */
	disable: function() 
	{
		this.element.disabled = true;
		
		if (this.isAddRemove)
		{	
			this.addButton.disabled 	= true;
			this.removeButton.disabled 	= true;
			this.targetList.disabled	= true;
		}
		
		if (this.isEnhanced)
		{
			this.textDisplay.disabled = true;
			this.comboButton.disabled = true;
			
			Event.stopObserving(this.textDisplay, 'click', this.toggleCombo, false);
			Event.stopObserving(this.comboButton, 'click', this.toggleCombo, false);
		}
	},
	
	/**
	 * Enables the Combobox
	 *
	 * @returns	void
	 * @access	public
	 */
	enable: function() 
	{
		this.element.disabled = false;
		
		if (this.isAddRemove)
		{
			this.addButton.disabled 	= false;
			this.removeButton.disabled 	= false;
			this.targetList.disabled 	= false;
		}
		
		if (this.isEnhanced)
		{
			this.textDisplay.disabled 	= false;
			this.comboButton.disabled 	= false;
			
			Event.observe(this.textDisplay, 'click', this.toggleCombo.bindAsEventListener( this ), false);
			Event.observe(this.comboButton, 'click', this.toggleCombo.bindAsEventListener( this ), false);
		}
	},
	
	/**
	 * Returns the current selected Value
	 *
	 * @returns	The current selected value
	 * @access public
	 */
	getValue: function() 
	{
		return $F(this.element);
	},
	
	/**
	 * Alias for getValue
	 */
	getSelected: function()
	{
		return this.getValue();
	},
	
	/**
	 * Returns the current selected Text
	 *
	 * @returns the current selected text
	 * @access	public
	 */
	getSelectedText: function()
	{
		return this.element.options[this.element.selectedIndex].text;
	},
	
	/**
	 * Sets a new selected Index
	 *
	 * @param	{integer}	idx		New Selected Index
	 * @returns	void
	 * @access	public
	 */
	setSelectedIndex: function( idx ) 
	{
		if ( idx < 0 ) 
		{
			alert( 'New selected Index out of range !');
		}
		
		if (!this.isEnhanced) 
		{
			if ( idx == null )
			{
				idx = 0;
			}
			
			if ( typeof idx == 'string' )
			{
				for ( var i=0; i < this.element.options.length; i++ )
				{
					var option = this.element.options[i].value;
				
					if ( option == idx )
					{
						idx = i;
					}
				}
			}
				
			this.element.selectedIndex = idx;
			/*
			if (this.isInTable)
			{
				this.textDisplay.value = this.element.options[idx].text;
				this.textDisplay.style.color = this.element.options[idx].style.color;
			}
			*/
		} 
		else 
		{
			for ( var i=0; i < this.optionList.rows.length; i++)
			{
				if ( i == idx ) 
				{
					this.textDisplay.value = this.optionList.rows[i].getAttribute('displayText');
					this.textDisplay.style.color = this.optionList.rows[i].textColor;
					
					this.element.options[0].value = this.optionList.rows[i].value;
					this.element.selectedIndex = 0;
				}
			}
		}
	},

	/**
	 * Sets the Text Color for a specific Option in the Combobox
	 *
	 * @param	{integer}	idx		option idx
	 * @param	{string}	color	new text color
	 * @param	{string}	hl		new highlight text color
	 * @returns	void
	 * @access	public
	 */
	setOptionColor: function( idx, color, hl ) 
	{
		if (idx == null)
		{
			return;
		}
		
		var color 	= (color == null) ? 'black' : color;
		var hl		= (hl == null) ? 'highlighttext': hl;
		
		if (this.isEnhanced)
		{
			var rows 	= this.optionList.rows;
			var rlength 	= rows.length;
			
			for (var i=0; i < rlength; i++)
			{
				if (idx == i)
				{
					var cells = rows[i].cells;
					var clength = cells.length;
					
					for (var j=0; j < clength; j++)
					{
						cells[j].style.color = color;
					}
				
					rows[i].setAttribute( 'textColor', color );
					rows[i].setAttribute( 'textColorHl', hl );
				}
			}
		} 
		else
		{
			this.element.options[idx].style.color = color;
		}
	},
	
	/**
	 * Sets the Background Color for a specific Option in the Combobox
	 *
	 * @param	{integer}	idx		option idx
	 * @param	{string}	color	new background color
	 * @param	{string}	hl		new background highlight color
	 * @returns	void
	 * @access	public
	 */
	setOptionBgColor: function( idx, color, hl )
	{
		if (idx == null)
		{
			return;
		}
		
		var color = (color == null) ? 'white' : color;
		var hl		= (hl == null) ? 'highlight': hl;
		
		if (this.isEnhanced)
		{
			var rows 	= this.optionList.rows;
			var length 	= rows.length;
			
			for (var i=0; i < length; i++) 
			{
				if (idx == i)
				{
					rows[i].style.backgroundColor = color;
					rows[i].setAttribute( 'bgColor', color );
					rows[i].setAttribute( 'bgColorHl', hl );
				}
			}
		} 
		else
		{
			this.element.options[idx].style.backgroundColor = color;
		}
	},
	
	/**
	 * Sets Combo Value in TextDisplay when select is nested in a table and browser is an ie6 or ie5
	 *
	 * @param	{mixed} 	evt	Event / Widget / Id
	 * @return	void
	 * @private
	 */
	setComboValue: function() 
	{
		this.textDisplay.value = this.element.options[this.element.selectedIndex].text;
		this.textDisplay.style.color = this.element.options[this.element.selectedIndex].style.color;
	},
	
	setNewItemList: function ( items ) 
	{
		this.setItemList( items );
		this.setOptionList();
	}
});