/**
 * @fileoverview EasyGUI Standard Checkbox Functions
 *
 * @author 		Gaetan Lauff	<glauff@plansoft.de>
 * @package 	js.widgets
 *
 * @version 	$Id: class.checkbox.js 260 2007-04-26 13:13:42Z glauff $
*/
var EasyGUI_checkbox = Class.create();

Object.extend( Object.extend( EasyGUI_checkbox.prototype, EasyGUI_widget.prototype ),
{
	checked: false,
	label: '',
	
	render: function()
	{
		this.checked	= Element.getAttributeValue( this.element, 'checked' );
		this.label		= Element.getAttributeValue( this.element, 'label' );
		
		if ( this.checked )
			this.element.checked = 'checked';
			
		//this.element.onfocus = function() { this.blur(); };
		Event.observe(this.element, "focus", this.onFocus.bindAsEventListener(this) );
		this.onclicked = eval( this.element.onclick );
		
		this.element.onclick = null;
		
		Event.observe( this.element, 'click', this.onCheckboxClicked.bindAsEventListener(this) );
	},
	
	onFocus: function( evt )
	{
		var element = $GE(evt);
		element.blur();
	},
	
	show: function()
	{
		if ( this.label )
			$(this.id + '_LABEL').style.visibility = 'visible';
			
		this.element.style.visibility = 'visible';
	},
	
	hide: function()
	{
		if ( this.label )
			$(this.id + '_LABEL').style.visibility = 'hidden';
			
		this.element.style.visibility = 'hidden';
	},
	
	isChecked: function()
	{
		return ( this.element.checked );
	},
	
	/**
	 * @hacked Give the browser the possibility to set the checkmark in the box before submit funtion is called
	 */
	onCheckboxClicked: function( evt )
	{
		if ( this.onclicked )
			window.setTimeout( this.onclicked, 1 );
	}
});