/**
 * @class EasyGUI Validator
 * @constructor
 *
 * This is the Basic EasyGUI Validator.
 * If you want to implement your own Validator simply extend this Class
 * and implement your own rules.
 *
 * @author 	Gaetan Lauff 	<glauff@plansoft.de>
 *
 * @version $Id: class.validator.js 245 2007-02-19 15:13:48Z glauff $
 */
var EasyGUI_Validator = Class.create();

EasyGUI_Validator.prototype = 
{
	initialize: function( obj ) 
	{
		this.rules		= [];
		this.element 	= null;
		this.value		= null;
		this.valid 		= true;
		
		Object.extend( this, obj );
	},
	
	// Check if there's a possibility for sprintf
	
	throwMessage: function( rule )
	{
		if ( this.valid )
		{
			return;
		}
			
		var rule = ( !rule ) ? 'invalid' : rule;
		
		for ( msg in this.messages )
		{
			if ( msg == rule )
			{
				var message = 'No message for ' + rule;
				
				if ( $( this.messages[rule] ) )
				{
					message = dialog.getMessage( this.messages[rule] );
				}
			}
		}
		
		alert( message );
		//alert( message.replace('%d', value) );
	},
	
	validate: function( element ) 
	{
		this.element 	= $( element );
		this.value		= $F( element );
	
		this.valid 		= this.isvalid();
		
		if ( !this.valid )
		{
			this.throwMessage( 'invalid' );
			return this.valid;
		}
		
		var rule = null;
		
		for ( var i=0; i < this.rules.length; i++ )
		{
			var method = this.rules[i][0];
			var value  = this.rules[i][1];
			
			if ( this[method] ) 
			{
				if ( ! (this.valid = this[method].call( this, value ) ) )
				{
					break;
				}
			}
		}
		
		this.throwMessage( method );
		return this.valid;
	},
	
	/**
	 * @abstract
	 */
	isvalid: function()
	{
		return true;
	},
	
	maxlength: function( value )
	{
		return ( this.value.length < parseFloat( value ) );
	},
	
	minlength: function( value )
	{
		return ( this.value.length > parseInt( value ) );
	},
	
	minvalue: function( value )
	{
		return ( this.value > parseFloat( value.replace( ',','.' ) ) );
	},
	
	maxvalue: function( value )
	{
		return ( this.value < parseFloat( value.replace( ',','.' ) ) );
	},

	range: function( value ) 
	{
		return ( this.value > parseFloat( value.replace(',','.') ) && 
				 this.value < parseFloat( value.replace(',','.') ) );
	}		
}