function JS_Timer()
{
	// PRIVATE PROPERTIES

    /**
    * @private
    */
    this._starttime = '';
    /**
    * @private
    */
    this._endtime = '';
    /**
    * @private
    */
    this._elapsedtime = '';
   
    /**
    * Starts the timer
    *
    */
    this.startTimer = function()
    {
        mtime = new Date();
        this._starttime = mtime.getTime();
    };

    /**
    * Stops the timer
    *
    * @return   float   elapsed time to degree of percision specified
    *
    */
    this.stopTimer = function()
    {
        mtime = new Date();
        this._endtime = mtime.getTime();
        this._setElapsedTime();

        // We are going to assume that when the timer is stopped
        // they will want the elapsed time immediately
        return this.getElapsedTime();
    };

    /** 
    * Restarts the timer
    *
    * Same as starTimer excepts this clears everything out first
    *
    */
    this.restart = function()
    {
        this._endtime = '';
        this._elapsedtime = '';
        
        this.startTimer();      
    };

    /**
    * Gets the elapsed time
    *
    * This returns the elapsed time with the proper number of 
    * significant digits
    *
    * @return   float   Elasped time in seconds formatted to degree of percision specified
    *
    */
    this.getElapsedTime = function()
    {
        return ( this._elapsedtime / 1000 );
    };

    // PRIVATE METHODS

    /**
    * Sets the elapsed time
    *
    * once stop timer is called this gets called to calculate
    * the elapsed time for later retrieval
    *
    * @access private
    */
    this._setElapsedTime = function()
    {
        this._elapsedtime = this._endtime - this._starttime;
    };
}