/**
 * @fileoverview Library of util functions for daily gui tasks :-)
 * requires lib.dom.js
 * requires lib.style.js
 * 
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @version $Id: lib.util.js 258 2007-03-27 09:08:06Z glauff $
 */

/**
 * Cancels all Selection by user
 * @param	{object}	evt		Event Object
 * @returns	True (Selection allowed} if element type is an edit field or a textarea, otherwise false.
 * @access	private
 */
function noSelect(evt)
{
	var element = $GE(evt);
	
	if (element.type == "text" || element.nodeName == 'TEXTAREA')
	{
		return true;
	}
	
	return false;
}

/**
 * Checks if the given value is empty
 * Empty means is an empty string, null, undefined, false or the value 0
 * @param	{mixed}	value	String or numeric value
 * @returns	True if value is set to one of the empty identifiers, false otherwise.
 * @access	public
 */
function isEmptyValue( value )
{
	switch(value) 
	{
		case 'undefined':
		case null:
		case '0':
		case '':
		case false:
		
			return true;
			break;
	}
	
	return false;
}

/**
 * Sleep Function
 * Stops execution of Program for the given amount of time in Miliseconds
 * @param	{int}	ms	Time in Miliseconds
 * @returns	void
 * @access	public
 */
function sleep( ms )
{
	if ( !ms ) 
	{
		return;
	}
	
	var d = new Date();
	
	while ( true )	
	{
		var mill = new Date();
		var diff = mill - d;
		
		if( diff > ms) 
		{ 
			break;
		}
	}
}

/**
 * Toggles Enter key to Tab
 * Only works in IE
 * @param	{object}	evt	
 * @access	private
 */
function toggleEnterKey(evt)
{
	var element = $GE(evt);
	
	var keyCode = 	evt.keyCode ? evt.keyCode :
               		evt.charCode ? evt.charCode :
					evt.which ? evt.which : void 0;
					
	if (element.nodeName != 'INPUT' || (keyCode && keyCode != 13)) 
	{
		return;
	}

	if ( keyCode && window.event && !window.opera ) 
	{
		window.event.keyCode = 9;
		return true;
	} 
	else if (evt.keyCode) 
	{
		/**
		 * This is not possible in mozilla browsers today
		 * Perhaps one day they will implement it
		 */
		//return evt.which = 9;
	}
}

/**
 * changekey function found on www.faqts.com
 * Allows to replace keyCode in input fields and textareas
 * by Martin Honnen, Pon Bakyaraj, Adam Finster
 */
function changeKey (textControl, evt, keyChecker) 
{
	var keyCode = 	evt.keyCode ? evt.keyCode :
               		evt.charCode ? evt.charCode :
					evt.which ? evt.which : void 0;
				
  	var key;
  
	if (keyCode)
	{
	  	key = String.fromCharCode(keyCode);
	}

	var keyCheck = keyChecker(keyCode, key);

	if (keyCode && window.event && !window.opera)
	{
	    if (keyCheck.cancelKey)
	    {
	    	return false;
	    } 
	    else if (keyCheck.replaceKey) 
	    {
	    	window.event.keyCode = keyCheck.newKeyCode;
	    	
	      	if (window.event.preventDefault)
	      	{
	      		window.event.preventDefault();
	      	}
	      	
	     	return true;
	    } 
	    else
	    {
	      	return true;
	    }
	  } 
	  else if (typeof textControl.setSelectionRange != 'undefined') 
	  {
	    	if (keyCheck.cancelKey) 
	    	{
	      		if (evt.preventDefault)
	      		{
	        		evt.preventDefault();
	      		}
	      		
	      		return false;
	    	} 
	    	else if (keyCheck.replaceKey) 
	    	{
    			// cancel the key event and insert the newKey for the current selection
	      		if (evt.preventDefault)
	      		{
		  			evt.preventDefault();
	      		}
	      		
	      		var oldSelectionStart = textControl.selectionStart;
	      		var oldSelectionEnd = textControl.selectionEnd;
	      		var selectedText = textControl.value.substring(oldSelectionStart, oldSelectionEnd);
	      		var newText = typeof keyCheck.newKey != 'undefined' ? keyCheck.newKey : String.fromCharCode(keyCheck.newKeyCode);
	      		
	      		textControl.value = textControl.value.substring(0, oldSelectionStart) + newText +
	        						textControl.value.substring(oldSelectionEnd);
	      
	        	textControl.setSelectionRange(oldSelectionStart + newText.length, oldSelectionStart + newText.length);
	      		return false;
	    	} 
	    	else
	    	{
	      		return true;
	    	}
	  } 
	  else if (keyCheck.cancelKey) 
	  {
	    	if (evt.preventDefault)
	    	{
	      		evt.preventDefault();
	    	}
	      		
	    	return false;
	  } 
	  else
	  {
			return true;
	  }
}

/**
 * Examples for changeKey
 */

/**
 * Change letters to uppercase
 * @param	{int}		keyCode
 * @param	{string}	key
 */
function lettersToUpperCase (keyCode, key)
{
	var newKey = key.toUpperCase();
	
  	if (newKey != key)
  	{
    	return { replaceKey: true, newKeyCode: newKey.charCodeAt(), newKey:newKey };
  	}
  	else
  	{
   		return { cancelKey: false };
  	}
}

/**
 * Replaces Digits with X
 * @param	{int}		keyCode
 * @param	{string}	key
 */
function digitsToX (keyCode, key)
{
	if ("0123456789".indexOf(key) != -1)
	{
		return { replaceKey: true, newKeyCode: "X".charCodeAt(), newKey: "X" };
	}
	else
	{
		return { cancelKey: false };
	}
}

/**
 * Cancels Digits in an input field
 */
function cancelDigits (keyCode, key) 
{
 	return { cancelKey: "0123456789".indexOf(key) != -1 };
}

/* End of Examples */

var Util = 
{
	getJSObject: function ( literal ) 
	{
		try 
		{
			eval ( "obj = " + literal + ";" );
			return ( typeof obj != 'number' ) ? obj : false;
		} 
		catch( e ) 
		{
			return false;
		}
	},
	
	getIframe: function() 
	{
		var myframe = document.createElement("IFRAME");
		myframe.frameBorder = 0;
		myframe.scrolling = 'no';
		myframe.src = "javascript: false";
	
		return myframe;
	}
};