/**
 * @fileoverview Library to patch javascript builtin object prototypes
 *
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @version $Id: lib.easygui.js 241 2007-02-06 11:00:54Z glauff $
 */
/**
 * Defines new Method on Error Prototype to get an Error String
 */
Error.prototype.getError = function ()
{
	return 	"EasyGUI Exception Handler:\n" + 
			"Exception Type: " + this.name + "\n\n" + 
			this.message;
}

/**
 * Extend Prototype Library
 */
Object.extend( Array.prototype, 
{
	toUserString: function( glue ) {
		var usrStr = '';
		
		for (  var i=0; i < this.length; i++ ) {
			usrStr += this[i] + glue;
		}

		return usrStr;
	},
	
	inArray: function( attribute ) 
	{
		for ( var i=0; i < this.length; i++ ) {
			if ( this[i] == attribute ) {
				return true;
			}
		}
		return false;
	},
	
	keyExists: function( key ) 
	{
		if ( this[key] != null ) {
			return true;
		}
		
		return false;
	},
	
	removeEntry: function( value ) 
	{
		var newArr = new Array();
	 
		for (var i=0; i < this.length; i++) {
			if (this[i] != value) {
				newArr[newArr.length] = this[i];
			}
		}
		
		this.length = newArr.length;
		
		for ( var i=0; i < newArr.length; i++ )
			this[i] = newArr[i];
	}
});


/**
 * Patch String Object with some util functions
 * 
 */
Object.extend( String.prototype, {
	
	/**
	 *
	 */
	sprintf: function() {
	   if (!arguments || arguments.length < 1 || !RegExp)
	   {
	      return;
	   }
	   var str = arguments[0];
	   var re = /([^%]*)%('.|0|\x20)?(-)?(\d+)?(\.\d+)?(%|b|c|d|u|f|o|s|x|X)(.*)/;
	   var a = b = [], numSubstitutions = 0, numMatches = 0;
	   while (a = re.exec(str))
	   {
	      var leftpart = a[1], pPad = a[2], pJustify = a[3], pMinLength = a[4];
	      var pPrecision = a[5], pType = a[6], rightPart = a[7];
	
	      numMatches++;
	      if (pType == '%')
	      {
	         subst = '%';
	      }
	      else
	      {
	         numSubstitutions++;
	         if (numSubstitutions >= arguments.length)
	         {
	            alert('Error! Not enough function arguments (' + (arguments.length - 1)
	               + ', excluding the string)\n'
	               + 'for the number of substitution parameters in string ('
	               + numSubstitutions + ' so far).');
	         }
	         var param = arguments[numSubstitutions];
	         var pad = '';
	                if (pPad && pPad.substr(0,1) == "'") pad = leftpart.substr(1,1);
	           else if (pPad) pad = pPad;
	         var justifyRight = true;
	                if (pJustify && pJustify === "-") justifyRight = false;
	         var minLength = -1;
	                if (pMinLength) minLength = parseInt(pMinLength);
	         var precision = -1;
	                if (pPrecision && pType == 'f')
	                   precision = parseInt(pPrecision.substring(1));
	         var subst = param;
	         switch (pType)
	         {
	         case 'b':
	            subst = parseInt(param).toString(2);
	            break;
	         case 'c':
	            subst = String.fromCharCode(parseInt(param));
	            break;
	         case 'd':
	            subst = parseInt(param) ? parseInt(param) : 0;
	            break;
	         case 'u':
	            subst = Math.abs(param);
	            break;
	         case 'f':
	            subst = (precision > -1)
	             ? Math.round(parseFloat(param) * Math.pow(10, precision))
	              / Math.pow(10, precision)
	             : parseFloat(param);
	            break;
	         case 'o':
	            subst = parseInt(param).toString(8);
	            break;
	         case 's':
	            subst = param;
	            break;
	         case 'x':
	            subst = ('' + parseInt(param).toString(16)).toLowerCase();
	            break;
	         case 'X':
	            subst = ('' + parseInt(param).toString(16)).toUpperCase();
	            break;
	         }
	         var padLeft = minLength - subst.toString().length;
	         if (padLeft > 0)
	         {
	            var arrTmp = new Array(padLeft+1);
	            var padding = arrTmp.join(pad?pad:" ");
	         }
	         else
	         {
	            var padding = "";
	         }
	      }
	      str = leftpart + padding + subst + rightPart;
	   }
	   return str;
	},
	
	/**
	 * Left trim
	 *
	 * @param	string	trimchar	Character to trim
	 * @return	string
	 * @access	public
	 */
	ltrim: function( trimchar ) 
	{
		var str = this.valueOf();
		
		while ((str.charAt(0) == " ") || (str.charAt(0) == "\t") || (str.charAt(0) == trimchar) ) 
		{
  			str = str.substring(1, str.length);
		}
		
		return str;
	},
	
	/**
	 * Right trim
	 *
	 * @param	string	trimchar	Character to trim from the right side
	 * @return	string
	 * @access	public
	 */
	rtrim: function( trimchar ) 
	{
		var str = this.valueOf();

		while ((str.charAt(str.length-1) == " " || str.charAt(str.length-1) == "\t" || str.charAt( str.length-1) == trimchar ))
		{
			str = str.substring(0, str.length - 1);
		}
		
		return str;
	},
	
	/**
	 * Remove a given string from the right side
	 *
	 * @param	string	strTrim	String to remove from the right side
	 * @return	string
	 * @access	public
	 */
	trimright: function( strTrim ) 
	{
		var str = this.valueOf();
		
		if (strTrim.length == 0 || strTrim.length > str.length)
		{
			return str;
		}

		var nDifflen = strTrim.length;
		var nEndPos = str.length - 1;
		
		while (str.lastIndexOf(strTrim, nEndPos) == (nEndPos - nDifflen + 1)) 
		{
			nEndPos -= nDifflen;
		}
		
		str = str.substring(0, nEndPos + 1);
		
		return str;
	},
	
	/**
	 * Url Decode the string
	 * 
	 * @return	string
	 * @access public
	 */
	urldecode: function()
	{
		var str = this.valueOf();
		str = str.replace(/%20/g, ' ');
		return str;
	}
});