/** 
 * @fileoverview EasyGUI XP JavaScript Base
 * This initializes the whole Client Site Widget System
 *
 * @author Gaetan Lauff <glauff@plansoft.de>
 * @package	js
 * @version $Id: easygui.js 291 2008-02-13 12:45:28Z glauff $
 */
var DEBUGTIME	= false;
var DEBUG 		= false;
var validate 	= true;
var closeWindow = false;
var remoteCall	= false;
var initialized = false;
var IFrameObj; 				// our IFrame object

var GUITIME		= '';

var widgets		= new Array();
var dialog;

var EasyGUI = 
{
  	Version: 'XP',
  	Build: '292',

  	PATH: 		'',
	JS_PATH: 	'',
	CSS_PATH: 	'',
	YUI_PATH:	'',
	YUI_EXT_PATH:'',
	
	DEBUG: 		false,
	DEBUGTIME: 	false,
	
	/**
 	 * This is the main function called after the page has loaded
 	 */
	initUI: function()
	{
		if ( EasyGUI.DEBUGTIME ) {
			var timer = new JS_Timer();
			timer.startTimer();
		}
		
		dialog = new Dialog();
		dialog.init();
		
		if ( EasyGUI.DEBUGTIME ) {
			alert( 'Time to build GUI: ' + timer.stopTimer() + "\r\n\r\n" + GUITIME );
		}
	},
	
	/**
	 * Sets the EasyGUI Path
	 */
  	setPath: function()
	{
		var allScripts = document.getElementsByTagName('script');
		
		for ( var i=0; i < allScripts.length; i++ )
		{
			if ( allScripts[i].src.match(/easygui\.js(\?.*)?$/) )
			{
				EasyGUI.PATH 		= allScripts[i].src.replace( /\/easygui\.js(\?.*)?$/,'');
				break;
			}
			
		}	
	},
	
	/**
	 * Includes an external script by brute force ( from scriptaculous )
	 */
  	require: function( library )
  	{
  		document.writeln('<script type="text/javascript" src="' + library + '"></script>');
  	},
  	
  	/**
  	 * Loads the framework
  	 */
  	load: function( ) 
  	{
  		if ( typeof( BUILD ) != "undefined" && BUILD ) return;
  		
  		EasyGUI.setPath();
	
  		EasyGUI.require( EasyGUI.PATH + "/core/lib/lib.core.js" );
  		EasyGUI.require( EasyGUI.PATH + "/core/lib/lib.compat.js" );
  		
  		EasyGUI.require( EasyGUI.PATH + "/core/class.browser.js" );
  		EasyGUI.require( EasyGUI.PATH + "/core/class.dialog.js" );
  		
  		EasyGUI.require( EasyGUI.PATH + "/lib/lib.easygui.js" );
  		EasyGUI.require( EasyGUI.PATH + "/lib/lib.element.js" );
  		EasyGUI.require( EasyGUI.PATH + "/lib/lib.event.js" );
  		EasyGUI.require( EasyGUI.PATH + "/lib/lib.form.js" );
  		EasyGUI.require( EasyGUI.PATH + "/lib/lib.util.js" );
  		EasyGUI.require( EasyGUI.PATH + "/lib/lib.sort.js" );
  		EasyGUI.require( EasyGUI.PATH + "/lib/lib.datetime.js" );
  		
		EasyGUI.require( EasyGUI.PATH + "/utils/class.timer.js" );
	
		EasyGUI.require( EasyGUI.PATH + "/validator/class.validator.js" );
		EasyGUI.require( EasyGUI.PATH + "/validator/class.validator.date.js" );
		EasyGUI.require( EasyGUI.PATH + "/validator/class.validator.alphanum.js" );
		EasyGUI.require( EasyGUI.PATH + "/validator/class.validator.email.js" );
		EasyGUI.require( EasyGUI.PATH + "/validator/class.validator.num.js" );
		EasyGUI.require( EasyGUI.PATH + "/validator/class.validator.time.js" );
		
		EasyGUI.require( EasyGUI.PATH + "/win/class.guiwindow.js" );
		EasyGUI.require( EasyGUI.PATH + "/win/class.winregistry.js" );
		
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.widget.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.button.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.checkbox.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.combobox.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.menu.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.treectrl.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.menutree.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.radiobutton.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.tabctrl.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.exttabctrl.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.edit.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/class.text.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/table/class.table.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/table/class.tableheader.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/table/class.fixedheader.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/table/class.columnheader.js" );
		EasyGUI.require( EasyGUI.PATH + "/widgets/table/class.rowheader.js" );
		
		EasyGUI.require( EasyGUI.PATH + "/remote/class.request.js" );
  	}
};

EasyGUI.load();