/**
 * @fileoverview EasyGUI Core Library
 * This library contains the most basic functions for EasyGUI to work.
 * @author	Gaetan Lauff	<glauff@plansoft.de>
 * @version $Id: lib.core.js 267 2007-06-13 11:10:19Z glauff $
 */
function $GE( obj ) {
	return Element.getElement( obj );
}
/**
 * Central navigation function
 * @param	{object}	evt
 * @returns	false to prevent anchor tags to follow their default behaviour
 * @access	public
 */
function navigate( evt )
{
	var element = $GE( evt );
	
	var id 			= Element.getParentAttributeValue(element, 'id' );
	var href 		= Element.getParentAttributeValue(element, 'url' );
	var target 		= Element.getParentAttributeValue(element, 'target', '_self');
	var submitField	= Element.getParentAttributeValue(element, 'submitfield' );
	var targetDlg 	= Element.getParentAttributeValue(element, 'targetdlg' );
	
	if (targetDlg) {
		Form.Element.setValue('EK_TARGET', targetDlg);
	}
	
	if (submitField) {
		Form.Element.setValue(submitField, id);
	}
	
	if (!href) {	
		ekSubmit( id, target);
	} else {
		href = href.urldecode();
		
		if (href.indexOf('javascript:') != -1) {
			if (href.indexOf('ekSubmit(') != -1 ) {
				if (href.indexOf('this') != -1) {
					ekSubmit( element );
				} else {
					var test = href.match(/\((\'.*\')\)/);
					var test = test.slice(1);
					var cmd = 'ekSubmit(' + test + ');'
					eval ( cmd );
				}
			} else {
				code = href.substring(11, href.length) + ";";
				code = code.ltrim();
				eval(code);
			}
		} else {
			if ( href.indexOf('http:') != -1 && href.indexOf('void') == -1 && href.indexOf('#') == -1 ) {
				window.open(href, target);
			}
			
			if (href.indexOf('ekSubmit(') != -1) {
				if (href.indexOf('this') != -1) {
					ekSubmit( element );
				} else {
					var test = href.match(/\((\'.*\')\)/);
					var test = test.slice(1);
					var cmd = 'ekSubmit(' + test + ');'
					eval ( cmd );
				}
			} else {
				code = href.ltrim();
				eval(code);
			}
		}
	}

	return false;
}

/**
 * Comtrols the submission and sets the needed parameters
 * @param	{mixed}		element		ID or domElement
 * @param	{string}	target		Target Window or Frame
 * @param	{integer}	timeout		Timeout for submission in milliseconds
 * @param	{string}	actions		Actions that should be executed (Webapp mode)
 *
 * @returns	void
 *
 * @access	public
 */
function ekSubmit( evt, target, timeout)
{
	if (evt == null)
		throw new Error ('ekSubmit: No Submitevent set !');
		
	var form 		= document.forms[0];
	var action 		= null;
	var targetDlg 	= $F('DLG_ID');
	var element 	= null;
	
	var proceed 	= ( target == 'easygui_proceed' );
	var upload 		= ( target == 'easygui_upload' );
	
	var target = ( target == null || target == 'undefined' || target == 'easygui_proceed' || target == 'easygui_upload' ) ? '_self' : target;
	
	if ( typeof document.body.isubmit != "undefined" ) {
		return;
	}
	// @@@Hack
	if ( self != top && target == "_self" ) {
		document.body.isubmit = true;
	}
	
	if (typeof(evt) == 'object' ) {
		element = $GE( evt );
		evt = ( !element.id ) ? Element.getParentAttributeValue( element, 'id') : element.id;
	}
	
	if ( element = $GE( evt ) ) {
		var validate	= Element.getAttributeValue( element, 'validateform', false);
	
		if ( validate )
			if (!Form.validate( document.forms[0] ) )
				return false;
			
		target 		= Element.getAttributeValue( element, 'target', target );
		action		= Element.getAttributeValue( element, 'action', '' );
		targetDlg 	= Element.getAttributeValue( element, 'targetdlg', '');
		submitevt	= element.id;
	}
	
	var ajax 	= ( target == 'easygui_ajax' );
	var remote	= ( target == 'isyiframe' );
	
	if ( proceed )
		action = '';
		
	form.EK_TARGET.value 	= targetDlg;
	form.EK_REQUEST.value 	= 'false';
	form.EK_NOSTACK.value 	= 'false';
	form.EKSUBMITEVENT.value= evt;
	form.EK_ACTION.value 	= action;
	
	if ( DEBUG ) {
		alert( "--EKSUBMIT--\r\nin targetwin: " + target + 
				"\r\n validate: " + validate + 
				"\r\najax: " + ajax +
				"\r\naction: " + $F('EK_ACTION') + 
				"\r\ntargetdlg: " + $F('EK_TARGET') + 
				"\r\nevt: " + $F('EKSUBMITEVENT') + 
				"\r\nvalues: " + Form.serialize( form ) );
	}
	
	sleep(timeout);
	
	if ( remote ) {
		form.EK_NOSTACK.value = 'true';
	}
	
	if ( upload ) {
		form.EK_REQUEST.value = 'iframe';
		form.target = 'isyajax';
		form.submit();
		return;
	}
	
	if ( ajax ) {
		if ( Ajax.getTransport() ) {
			form.EK_REQUEST.value = 'ajax';
			this.params = '__eksubmit_values__=' + Form.serialize( document.forms[0] );
			var ajax = new Ajax.Request( document.forms[0].action, { postBody: this.params, onComplete: onComplete } );
			return;
		} else {
			form.EK_REQUEST.value = 'iframe';
			target = 'isyajax';
		}
	}
	
	var subForm = document.createElement('form');
	
	subForm.name 	= 'easygui_submit';
	subForm.method 	= 'post';
	subForm.action 	= document.forms[0].action;
	
	subForm.target 	= target;
	document.body.appendChild( subForm );

	if (DEBUG) {
		var timer = new JS_Timer();
		timer.startTimer();
	}
	
	var submitValues = Form.serialize( form );
	submitValues = submitValues.replace(/_EK_WIDGET_VALUE/g, '' );
	
	Form.insertHidden( "__eksubmit_values__", submitValues , subForm.name );
	
	if (DEBUG) {
		alert(timer.stopTimer());
	}
	
	$(subForm).fire('form:eksubmit');
	subForm.submit();
	document.body.removeChild(subForm);
}

/**
 * Submits in the Iframe
 */
function ekRemoteSubmit( element ) 
{
	ekSubmit( element, 'isyiframe' );
	dialog.enable();
}

/**
 * ekHttpRequest
 *
 * This function submits into
 *
 */
function ekRequest( element )
{
	ekSubmit( element, 'easygui_ajax' );
	dialog.enable();
}

function ekProceed( element )
{
	ekSubmit( element, 'easygui_proceed' );
	dialog.enable();
}

function ekConfirm( element, msg, request )
{
	if (msg == null) {
		ok = window.confirm('Are you sure ?');
	} else {
		msg = dialog.getMessage( msg );
		ok = window.confirm( msg );
	}
	
	if (ok) {
		if ( request ) {
			ekRequest( element );
		} else {
			ekSubmit( element );
		}
	}
	
	return false;
}

function ekUpload( element )
{
	ekSubmit( element, 'easygui_upload' );
	dialog.enable();
}

/**
 * Returns the Version Number of the Framework
 * @returns	string
 */
function getVersion() {
	return $F( $('IDC_EASYGUI_VERSION') );
}

/**
 * Returns the Build Number of the Framework
 * @returns	string
 */
function getBuild() {
	return $F( $('IDC_EASYGUI_BUILD') );
}