/**
 * @fileoverview Compatibility Library for deprecated EasyGUI Function Calls
 * Used to assure backward compatibility to the old easygui library functions
 * Consider all these functions as deprecated
 *
 * @author	Gaetan Lauff <glauff@plansoft.de>
 *
 * @version $Id: lib.compat.js 241 2007-02-06 11:00:54Z glauff $
 */

/**
 * Show a component
 * @param	{object}	element	domElement to show
 * @return	void
 * @access	public
 * @deprecated
 */
function componentShow( element )
{
	Element._show( element );
}

/**
 * Hide a component
 * @param	{object}	element	domElement o hide
 * @return	void
 * @access	public
 * @deprecated
 */
function componentHide( element )
{
	Element._hide( element );
}

/**
 * Disables a component
 * @param	{string}	id	id of component to disable
 * @return	void
 * @access	public
 * @deprecated
 */
function componentDisable( id )
{
	dialog[id].disable();
}

/**
 * Enables a component
 * @param	{string}	id	id of component to enable
 * @return	void
 * @access	public
 * @deprecated
 */
function componentEnable( id )
{
	dialog[id].enable();
}

/**
 * Add Event Listener to DOM Element
 * @param	{object}	obj	domElement to attach event listener to.
 * @param	{string}	evtType	type of event to react on. (e.g. mouseover, click etc.)
 * @param	{string}	fn	handler function that should be called when event is catched.
 * @param	{boolean}	useCapture
 * @return	void
 * @access	public
 * @deprecated
 */
function addEvent(obj, evType, fn, useCapture)
{
	Event.observe(obj, evType, fn, useCapture);
}

/**
 * Remove an Event Listener from DOM Element
 * @param	{object}	obj	domElement to remove the event listener from.
 * @param	{string}	evtType	type of event to react on. (e.g. mouseover, click etc.)
 * @param	{string}	fn	handler function that should be called when event is catched
 * @param	{boolean}	useCapture
 * @return	void
 * @access	public
 * @deprecated
 */
function removeEvent(obj, evType, fn, useCapture)
{
	Event.stopObserving( obj, evType, fn, useCapture);
}

/**
 * Make Handcursor on mouseover
 * @param	{object}	element	domElement
 * @return	void
 * @access	public
 * @deprecated
 */
function makeHandcursor( element )
{
	if (is.nav6up) {
   		element.style.cursor = 'pointer';
	} else {
    	element.style.cursor = 'hand';
	}
}

/**
 * Make Waitcursor on mouseover
 * @param	{object}	element	domElement
 * @return	void
 * @access	public
 * @deprecated
 */
function makeWaitcursor(element)
{
   	element.style.cursor = 'wait';
}

/**
 * Restores Default Cursor
 * @param	{object}	element	domElement
 * @return	void
 * @access	public
 * @deprecated
 */
function makeDefaultcursor(element) 
{
	element.style.cursor = 'default';
}

/**
 * Inserts a new hidden form field in the form
 * @param	{string}	id	id of form field to insert
 * @param	{string}	value	value of form field to insert
 * @return	void
 * @access	public
 * @deprecated
 */
function createNewHiddenFormField(id, value) 
{
	Form.insertHidden(id, value);
}

/**
 * Sets a new itemlist for a combobox
 * @param	{string}	id	Id of Combobox
 * @return	void
 * @access	public
 * @deprecated
 */
function initCombobox( id ) 
{
	dialog[id].setOptionList();
}

/**
 * Opens a tree item
 * @param	{object}	element	domElement that should be opened
 * @return	void
 * @access	public
 * @deprecated
 */
function openFolder( element ) 
{
	focusItem( element );
}

/**
 * Wrapper for sortColumn Function
 * @param	{mixed}	evt	domElement / Id / Current Event Object
 * @return	void
 * @access	public
 * @deprecated
 */
function sortColumn(evt) 
{
	sortTable( evt );
}

/**
 * Scroll the table to the selected Row
 * @param	{string}	id
 * @deprecated
 */
function scrollToTableElement( id ) 
{
	scrollIntoView( id );
}

 /*
 * @param	{object}	element	DOM Element
 * @deprecated
 */
function getColumnFrom(element) 
{
	var element = Element.getParentElementByTagName( element, 'TD', true );
	return element.id
}

/**
 * Returns the Row 
 * @param	{object}	element	DOM Element
 * @deprecated
 */
function getRowFrom( element ) 
{
	var element = Element.getParentElementByTagName( element, 'TR', true );
	return element.id
}

/**
 * Get Table From
 * @param	{object}	element	DOM Element
 * @deprecated
 */
function getTableFrom(element) 
{ 
	var element = Element.getParentElementByTagName( element, 'DIV', true ); 
    return element.id; 
} 
/**
 * Get Ro Number From Object
 * @param	{object}	obj		DOM Element
 * @deprecated 
 */
function getRowNumFrom(obj) 
{
	var rowid	= getRowFrom(obj);
	var tableid	= getTableFrom(obj);
	
	return rowid.substr(tableid.length+1, rowid.length - tableid.length - 1);
}

/**
 * @param	{object}	element		DOM Element
 * @deprecated
 */
function getElementFrom( element ) 
{
	return $GE( element );
}

/**
 * EK SubmitInIframe is a wrapper for
 * callToServer() Function
 *
 * @deprecated
 */
function ekSubmitInIframe() 
{
	callToServer('isycat');
}

/**
 * Submits in new Window
 * @param	mixed	element
 * @param	integer	width	New Window Width
 * @param	integer	height	New Window Height
 * @return	void
 * @access	public
 */
function ekSubmitInNewWindow(element, width, height)
{
	if (width == null) {
		width = 800;
	}
	
	if (height == null) {
		height = 600;
	}
	
	if (typeof(element) == "string") {
    	var winId = element;
    } else {
    	var winId = element.id;
    }
    
	var win = window.open("about:blank", winId + "_win" ,"width=" + width + " height=" + height + " toolbar=no");
	dialog.winRegistry.registerWindow(new guiWindow(winId + "_win", win));
	
	ekSubmit(element, winId + "_win");
}

/**
 * Old Function for showing content in a new Window
 * Not so flexible
 *
 * Please use window.open( 'url', 'windowname', 'window properties' );
 *
 * The new windowname should not contain blank or '-' characters;
 * If so they will be replaced by underscore
 * @param	object	element
 * @return	void
 */
function showContentInNewWindow(element) 
{
	var newWindowUrl 		= "about:blank";
	var newWindowName 		= "newWindow";
	var newWindowHeight 	= 600;
	var newWindowWidth 		= 800;
	var newWindowToolbar 	= "yes";
	var newWindowMenuBar 	= "no";
	
	if (element.getAttribute('docref')) {
		newWindowUrl 		= element.getAttribute('docref');
	}
   	
   	if(element.getAttribute('newwindowname')) {
   		newWindowName 		= element.getAttribute('newwindowname');
   		newWindowName		= newWindowName.replace(/(\s+|-)/g, '_');
   	}
    
    if (element.getAttribute('newwindowwidth')) {
    	newWindowWidth 		= element.getAttribute('newwindowwidth');
    }
         
    if (element.getAttribute('newwindowheight')) {
    	newWindowHeight 	= element.getAttribute('newwindowheight');
    }
         
    if (element.getAttribute('newwindowtoolbar')) {
    	newWindowToolbar 	= element.getAttribute('newwindowtoolbar');
    }
    
    if (element.getAttribute('newwindowmenubar')) {
    	newWindowMenuBar 	= element.getAttribute('newwindowmenubar');
    }

    var newWindowAttributes = "menubar="+newWindowMenuBar+" toolbar="+newWindowToolbar+" width="+newWindowWidth+" height="+newWindowHeight;
    window.open(newWindowUrl, newWindowName, newWindowAttributes);
}

/**
 * Flips an Image on Mouseover
 * @param	{mixed}	evt	ID or DOM Element
 * @returns	void
 * @access	public
 * @deprecated
 */
function flipImage (evt) 
{
	var element = $GE(evt);
	
	var overimg = element.getAttribute('mouseoverimage' );
	
	if ( typeof (overimg) == "undefined" ) {
		return;
	}
	
    var imagesrc 			= element.src;
    element.src 			= overimg;
    element.setAttribute( 'mouseoverimage', imagesrc );
}

function confirmDelete( element, msg )
{
	ekConfirm( element, msg );
}

function navigate2(element)
{
	navigate(element);
}