// RUN_CATALOG.b
//	
// Im Unterschied zu INIT_CATALOG.b knnen jetzt die Datenbanken verwendet werden, die Aliase
// sind vorbereitet, der tatschliche verwendete Port ist bekannt usw. Es ist der Zeitpunkt
// unmittelbar vor dem ersten Request.
//
// return false;	-> EKat beenden (z.B. Batchmode)
// return true;		-> Browser oder Server Dialog starten

#include "base/EasyKat/EasyKat.es"
#include "custom/index.es"
// EasyKat.Controller.Front.initialize('controllers');

function pdsDeletePosition(strProjectfile, strPos, strMark)
{
    var bUseMarkierung = true;
    if ((strMark == '') && (strPos != ''))
        bUseMarkierung = false;

    // Prfen, ob Projektdatei schon da ist; wenn nein: Ende
    if (! FileName.fileExists(strProjectfile))
        return;

    setstring("PROJECT.PROJECTPATH", "", strProjectfile);
    specialexec("LoadProject");

    var Source, Target, i, j;
    var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
    var nLastPos = getsize(Projectlist, "") - 1;
    for (i = 0; i <= nLastPos; ++i)
    {
        Source = Projectlist + "[" + i + "]";
        var strProductArea   = getstring("PRODUCT_AREA", Source);
        var strCurPos        = getstring("POS", Source);
        var strCurMarkierung = "";
        if ((strProductArea == "RH") || (strProductArea == "CA") || (strProductArea == "FP"))
        {
            if (strProductArea == "FP")
                strCurMarkierung = getstring("FP.MARKIERUNG", Source);
            else
                strCurMarkierung = getstring("CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", Source);

            if ((bUseMarkierung && (strMark == strCurMarkierung)) ||
                (!bUseMarkierung && (strCurPos == strPos)))
            {
                for (j = i+1; j <= nLastPos; ++j)
                {
                    Source = Projectlist + "[" + j + "]";
                    Target = Projectlist + "[" + (j-1) + "]";
                    delete(Target, "");
                    copy(Source, Target);
                }
                delete(Projectlist + "[" + nLastPos + "]", "");
                break;
            }
        }
    }
    specialexec("SaveProject");
}

function pdsCombineProjects(strProjectfile1, strProjectfile2, strProjectfileNew)
{
    // Prfen, ob Projektdateien da sind; wenn nein: Ende
    if (! FileName.fileExists(strProjectfile1) || ! FileName.fileExists(strProjectfile2))
        return;

    setstring("PROJECT.PROJECTPATH", "", strProjectfile1);
    specialexec("LoadProject");
    
    // lese Datei 2 nach ProjectlistImport
    loadxml("TEMP.IMPORT", strProjectfile2, "true");

    var Source, Target, i;
    var Projectlist       = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
    var ProjectlistImport = "TEMP.IMPORT.POSITIONS.PROJECTLIST_ITEMS";
    var nLastPos = getsize(Projectlist, "") - 1;
    var nLastPosImport = getsize(ProjectlistImport, "") - 1;

    var nPos = 10;
    if(nLastPos >= 0)
    {
        nPos = (atoi(getstring("POS", Projectlist + "[" + nLastPos + "]")) / 10 + 1) * 10;	
    }
	/*
    if(nLastPosImport >= 0)
    {
        nPos = (atoi(getstring("POS", Projectlist + "[" + nLastPosImport + "]")) / 10 + 1) * 10;	
    }
	*/

    for (var i = 0, j = (nLastPos + 1); i <= nLastPosImport; ++i, ++j)
    {
        Source = ProjectlistImport + "[" + i + "]";
        Target = Projectlist + "[" + j + "]";
        copy(Source, Target);
        setstring("POS", Target, ""+(nPos + i*10));
    }

    // Als neues Projekt abspeichern
    setstring("PROJECT.PROJECTPATH", "", strProjectfileNew);
    specialexec("SaveProject");
}

function pdsOverviewProject(strProjectfile, strOutfile)
{
    // Prfen, ob Projektdatei schon da ist; wenn nein: Ende
    if (! FileName.fileExists(strProjectfile))
        return;

    writefile( strOutfile, ' ', "wc" );

    setstring("PROJECT.PROJECTPATH", "", strProjectfile);
    specialexec("LoadProject");

    var Source, i;
    var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
    var nLastPos = getsize(Projectlist, "") - 1;
    for (i = 0; i <= nLastPos; ++i)
    {
        Source = Projectlist + "[" + i + "]";
        var strProductArea   = getstring("PRODUCT_AREA", Source);
        var strCurPos        = getstring("POS", Source);
        var strCurQty        = getstring("QTY", Source);
        var strOrdCode       = getstring("ORDERCODE_PROJECTLIST", Source);
        var strIdent         = getstring("IDENT", Source);
        var strCurMarkierung = "";
        if ((strProductArea == "RH") || (strProductArea == "CA") || (strProductArea == "FP"))
        {
            if (strProductArea == "FP")
                strCurMarkierung = getstring("FP.MARKIERUNG", Source);
            else
                strCurMarkierung = getstring("CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", Source);
            
            var Zeile = strCurPos + ";" + strCurMarkierung + ";" + strCurQty + ";" + strOrdCode + ";" + strIdent;
            writefile( strOutfile, Zeile + "\r\n", "a" );
        }
    }
}

function pdsDetailsPosition(strProjectfile, strPos, strMark, strOutfile)
{
    var bUseMarkierung = true;
    if ((strMark == '') && (strPos != ''))
        bUseMarkierung = false;

    // Prfen, ob Projektdatei schon da ist; wenn nein: Ende
    if (! FileName.fileExists(strProjectfile))
        return;

    setstring("PROJECT.PROJECTPATH", "", strProjectfile);
    specialexec("LoadProject");

    var Source, i;
    var Target      = "DLGDATA";
    var Projectlist = "PROJECT.POSITIONS.PROJECTLIST_ITEMS";
    var nLastPos = getsize(Projectlist, "") - 1;
    for (i = 0; i <= nLastPos; ++i)
    {
        Source = Projectlist + "[" + i + "]";
        var strProductArea   = getstring("PRODUCT_AREA", Source);
        var strCurPos        = getstring("POS", Source);
        var strCurMarkierung = "";
        if ((strProductArea == "RH") || (strProductArea == "CA") || (strProductArea == "FP"))
        {
            if (strProductArea == "FP")
                strCurMarkierung = getstring("FP.MARKIERUNG", Source);
            else
                strCurMarkierung = getstring("CA.FORMS.UEBERSICHT_LASTKETTE.IDC_ANLAGEN_POS_NR", Source);

            if ((bUseMarkierung && (strMark == strCurMarkierung)) ||
                (!bUseMarkierung && (strCurPos == strPos)))
            {
                delete(Target, "");
                copy(Source, Target);

                caMainController = new CaController();   // ohne var-Deklaration, muss global sein!
                pdmsManager = new CaPdmsManager(caMainController);
                writefile( strOutfile, "\r\n", "wc" );   // Damit die Datei neu erzeugt wird
                pdmsManager.writeStkFromProjectlist(strOutfile);

                break;
            }
        }
    }
}

// ---------------------------------------------------------------------------------------
function pdsListAction(strListfile, strAction)
{
    // Prfen, ob List-Datei da ist; wenn nein: Ende
    if (! FileName.fileExists(strListfile))
        return;
    // einlesen
    var fileBuffer = readfile(strListfile);
    var aLines = fileBuffer.split('\r\n');
    for (var i = 0; i < aLines.length; i++) {
        var Line = aLines[i];
        Line = trimleft(trimright(Line, ' '), ' ');
        Line = trimleft(Line, '﻿');   // ﻿ ist die Byte Order mark fr UTF-8 Dateien (am Dateianfang), die muss raus.
        
        if (Line == '')
            continue;
        
        var aLineContent = Line.split(';');
        
        // CombineProjects: 3 Parameter -> Project 1; Project 2; Neues Project
        // OverviewProject: 2 Parameter -> Project; Name Overview-Ausgabedatei
        // DetailsPosition: 4 Parameter -> Project; Pos-Nummer; Markierung; Name Ausgabedatei
        if ((strAction == 'COMBINE_PROJECTS_LIST') && (aLineContent.length != 3))
            continue;
        else if ((strAction == 'OVERVIEW_PROJ_LIST') && (aLineContent.length != 2))
            continue;
        else if ((strAction == 'DETAILS_POS_LIST') && (aLineContent.length != 4))
            continue;
        
        for (var j = 0; j < aLineContent.length; j++) {
            aLineContent[j] = trimleft(trimright(aLineContent[j], ' '), ' ');
        }

        if (strAction == 'COMBINE_PROJECTS_LIST')
            pdsCombineProjects(aLineContent[0], aLineContent[1],aLineContent[2]);
        else if (strAction == 'OVERVIEW_PROJ_LIST')
            pdsOverviewProject(aLineContent[0], aLineContent[1]);
        else if (strAction == 'DETAILS_POS_LIST')
            pdsDetailsPosition(aLineContent[0], aLineContent[1], aLineContent[2], aLineContent[3]);
    }

}






var cmdLnParam = new Array;

function showCmdLineParam()
{
	if(cmdLnParam.length == 0)
		return;

	var cmd="";
	
	for(var i=0 ; i<cmdLnParam.length ; i++)
	{
		cmd += cmdLnParam[i] + " ";
	}
	
	alert(cmd);
}

main()
{
	var nCmdParams = getsize("CATALOG.CMDLINE","ROOT");
	for(var i=0 ; i<nCmdParams ; i++)
	{
		par = getstring(arraypath("CATALOG.CMDLINE",i)~"PARAM", "ROOT");
		cmdLnParam.push( par );
	}
	
	// showCmdLineParam();

    // Schreiben in den Store hier schon sessionabhngig !!!

	var infile = getstring("CATALOG.CMDLINE[0].PARAM","ROOT");
	if (infile != "") 
	{
        if (left(infile, 11) == "PDS_ACTION=")
        {
            var aAction   = infile.split('='); 
            var strAction = aAction[1];
            var p1 = getstring("CATALOG.CMDLINE[1].PARAM","ROOT");
            var p2 = getstring("CATALOG.CMDLINE[2].PARAM","ROOT");
            var p3 = getstring("CATALOG.CMDLINE[3].PARAM","ROOT");
            var p4 = getstring("CATALOG.CMDLINE[4].PARAM","ROOT");
            var p1A = (p1 != '') ? p1.split('=') : ['', ''];        
            var p2A = (p2 != '') ? p2.split('=') : ['', ''];        
            var p3A = (p3 != '') ? p3.split('=') : ['', ''];        
            var p4A = (p4 != '') ? p4.split('=') : ['', ''];        

            if (strAction == 'DELETE_POS')
                pdsDeletePosition(p1A[1], p2A[1], p3A[1]);
            else if (strAction == 'COMBINE_PROJECTS')
                pdsCombineProjects(p1A[1], p2A[1], p3A[1]);
            else if (strAction == 'OVERVIEW_PROJ')
                pdsOverviewProject(p1A[1], p2A[1]);
            else if (strAction == 'DETAILS_POS')
                pdsDetailsPosition(p1A[1], p2A[1], p3A[1], p4A[1]);
            else if (strAction == 'COMBINE_PROJECTS_LIST')
                pdsListAction(p1A[1], strAction);
            else if (strAction == 'OVERVIEW_PROJ_LIST')
                pdsListAction(p1A[1], strAction);
            else if (strAction == 'DETAILS_POS_LIST')
                pdsListAction(p1A[1], strAction);

            // exitapp();  nicht erforderlich            
            return true;
        }
        else
        {
            infile = replace(infile, "\"", "");
            if (toupper(right(infile, 4)) == ".TCA")
                setstring ("CASCADE_START_TCA", "TMP", infile);

            if (toupper(right(infile, 4)) == ".FIN" || toupper(right(infile, 5)) == ".EFIN")
                setstring ("CASCADE_START_FIN", "TMP", infile);

            if (toupper(right(infile, 3)) == ".IN")
                setstring ("CASCADE_START_VIS_INPUT", "TMP", infile);

            if (toupper(right(infile, 4)) == ".OUT")
                setstring ("CASCADE_START_VIS_PROJECT", "TMP", infile);
        }
	}
	var action = getstring("CATALOG.CMDLINE[1].PARAM","ROOT");
	if (action != "") 
	{
        action = replace(action, "\"", "");
        if ((toupper(action) == "EDIT")     ||
            (toupper(action) == "PLAYEDIT") ||
            (toupper(action) == "COPY")     ||
            (toupper(action) == "PLAYCOPY") ||
            (toupper(action) == "NEW")      ||
            (toupper(action) == "PLAY")     ||
            (toupper(action) == "COPY")     ||
            (toupper(action) == "PLAYNEW")  ||
            (toupper(action) == "PLAYCOPY"))
            setstring ("CASCADE_START_VIS_ACTION", "TMP", tolower(action));
	}
	var wHandle = getstring("CATALOG.CMDLINE[2].PARAM","ROOT");
	if (wHandle != "") 
	{
        setstring ("VIS_WIN_HANDLE", "VIS_ADDITIONALDATA", wHandle);
    }
    
	return false;
}
