//////////////////////////////////////////////////////////////////
// Diese Script wird innerhalb von CEKCatalogSystem::Init
// aufgerufen.
// Bitte beachten dass hier noch keine Datenbank erreichbar ist.
// Es gibt noch keine Sessions usw.
// Es sollten auch keine externen Scripte gestartet werden weil
// der scripts-Ordner nicht unbedingt vorhanden ist und noch keine
// Scripte aus der Datenbank geladen werden knnen.

//////////////////////////////////////////////////////////////////

class XMLConfigParser extends SaxXMLParser
{
	var store, parentNodes;

	readConfig(filename)
	{
		this.store = new Storage;
		this.parentNodes = new Array;
		
		this.parseFile(filename);
	}
	
	startElement()
	{
		var nAttr = this.getAttrCount();
		var nDepth = this.depth();
		this.parentNodes[nDepth] = this.getNodeName().toUpperCase();
		
		var path = "";
		for(var i=1 ; i<=nDepth ; i++)
			path = path ~ this.parentNodes[i];
			
		if(this.getAttrValueFromName("storagetype").compareNoCase("ARRAY") == 0)
			path = path~[this.store.getSize(path)];
			
		for(var i=0 ; i<nAttr ; i++) {
			var name = this.getAttrName(i).toUpperCase();
			var value = this.getAttrValue(i);
			
			this.store.set(path~name, value);
		}
	}
}


//////////////////////////////////////////////////////////////////
// MAIN-Block
{
	debug(0, false);	// Im Release immer debug(0) !!
	res=filecommand("unlink","logfile.txt");
	logtracestate(1);
	logtrace("\n\n\n\n\n\n\n//////////////////////////////////////////////////////////////////////////////\nINIT_CATALOG\n");	
	
	// catalog.xws laden und im Store ablegen
	xmlconf = new XMLConfigParser();
	xmlconf.readConfig("catalog.xws");
}
