
##############################################################################
#
# Author:		H.M. Bauer
# Copyright:	Plan Software GmbH, Saarbrcken
#
##############################################################################



# ============================================================================
# MAIN-Funktion
# ============================================================================

function main()
{
	var strBatchInput	= getstring ("strBatchInput", "TMP");
	var ret = 0;

		// Eingabedatei lesen
		// ---------------------------------------------
    var strFileContent  = readfile(strBatchInput);
    var nAnzRows        = stringtoarray(strFileContent, "TMP.INPUTLINES", "\n");
    var strLine = "", i = 0, j = 0;
    var strExecutable, strParams, strPrgPath; 
    var bInExe, bInParam, bInPath;
    var nAnzAufruf = 0;
    var nSapLogin  = false;

    if (! singleinstance())
    {
        logtrace("Not single instance: abort ...\n");
        alert("Die CAD-Generierung kann nicht mehrmals gleichzeitig laufen. Bitte OK clicken.");
        return;
    }
    
    logtrace("Processing started ...\n");
    alert("Die Erzeugung von CAD-Dateien wird gestartet. Bitte OK clicken.");
    

    var netShare_PRODUKTIV = "\\\\aswi02_g\\USR\\sap\\Transfer\\KPRO\\P01_TEMP";
    var netShare_KSYSTEM   = "\\\\Aswi01\\ifs\\usr\\sap\\Transfer\\KPRO\\K00_TEMP";
    
    var netShare = netShare_KSYSTEM;
    var username = "R3IFS";
    var passwd   = "ftpok5250n";
    
    for (i = 0; i < nAnzRows; i++)
    {
        strExecutable = "";
        strParams     = "";
        strPrgPath    = "";
        
        bInExe   = false;
        bInParam = false;
        bInPath  = false;
        
        strLine = getstring("VALUE", "TMP.INPUTLINES["+i+"]");
        var nLength = strLine.length;
        
        j = 0;
        for (j; j < nLength; j++) 
        {
            var x = strLine.charAt(j);
            if (strLine.charAt(j) == "\"")
            {
                if (bInExe)
                    break;  // exe eingelesen
                else
                    bInExe = true;
            }
            else
            {
                if (bInExe)
                    strExecutable += strLine.charAt(j);
            }
        }
        j++;
        for (j; j < nLength; j++) 
        {
            if (strLine.charAt(j) == "\"")
            {
                if (bInParam)
                    break;  // Params eingelesen
                else
                    bInParam = true;
            }
            else
            {
                if (bInParam)
                    strParams += strLine.charAt(j);
            }
        }
        j++;
        for (j; j < nLength; j++) 
        {
            if (strLine.charAt(j) == "\"")
            {
                if (bInPath)
                    break;  // Prgpath eingelesen
                else
                    bInPath = true;
            }
            else
            {
                if (bInPath)
                    strPrgPath += strLine.charAt(j);
            }
        }
        
        if ((strExecutable != "") && (strParams != "") && (strPrgPath != ""))
        {
            if (strExecutable == "LOGIN")
            {
                ret = copyfile(strParams, strPrgPath, 0);     // 0 = vorhandene Datei berschreiben ...
                nSapLogin  = true;
                var res = FileName.addNetConnection(netShare, username, passwd);
                if(res != "")
                    alert("Fehler beim Zeichnungstransfer auf SAP-Laufwerk: " + res);    
            }
            else if (strExecutable == "copy")
            {
                ret = copyfile(strParams, strPrgPath, 0);     // 0 = vorhandene Datei berschreiben ...
                // alert(ret); --> 1 ist OK, 0 schlug fehl
            }
            else if (strExecutable == "unlink")
            {
                ret = filecommand("unlink", strParams);     
                // alert(ret); --> 1 ist OK, 0 schlug fehl
            }
            else
            {
                nAnzAufruf++;
                // alert("Starte Aufruf " + nAnzAufruf);
                logtrace("   ... process file " +nAnzAufruf+ ": " +strParams+ "\n");
                // shellexecuteexblockingex( "\"" + strExecutable + "\"", "\"" + strParams + "\"", "\"" + strPrgPath + "\"", 0, 256000 );    // show = 1, timeout
                // im Std-EasyKat: shellexecuteexblocking
                shellexecuteexblocking( "\"" + strExecutable + "\"", "\"" + utf8toansi(strParams) + "\"", "\"" + strPrgPath + "\"", 0, 256000 );    // show = 1, timeout
            }
        }
    }

    logtrace("Processing finished ...\n");
    alert("Die Erzeugung von CAD-Dateien ist jetzt beendet. Bitte OK clicken und danach Aktualisieren.");
    
    if (nSapLogin)
        res = FileName.cancelNetConnection(netShare);
    
    /*
	// Testzwecke:
	savexml("BATCH_IMPORT", ".\\_testout.xml")
	var xxx = getstddirectory("PROGRAM") ;
    ut = toupper(strFileContent);
    nPos = find(ut, "XXX");
    if(nPos > -1)
    writefile(strBatchOutput, strXMLFileContent, "c");
    */

	// setexitcode(ret);
}
